/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** Settings */
@JsonPropertyOrder({
  Settings.JSON_PROPERTY_BAND,
  Settings.JSON_PROPERTY_ROAMING,
  Settings.JSON_PROPERTY_TIMEOUT
})
public class Settings {
  public static final String JSON_PROPERTY_BAND = "band";
  private String band;

  public static final String JSON_PROPERTY_ROAMING = "roaming";
  private Boolean roaming;

  public static final String JSON_PROPERTY_TIMEOUT = "timeout";
  private Integer timeout;

  public Settings() {}

  /**
   * The preferred Wi-Fi band, for use if the terminals support multiple bands. Possible values:
   * All, 2.4GHz, 5GHz.
   *
   * @param band The preferred Wi-Fi band, for use if the terminals support multiple bands. Possible
   *     values: All, 2.4GHz, 5GHz.
   * @return the current {@code Settings} instance, allowing for method chaining
   */
  public Settings band(String band) {
    this.band = band;
    return this;
  }

  /**
   * The preferred Wi-Fi band, for use if the terminals support multiple bands. Possible values:
   * All, 2.4GHz, 5GHz.
   *
   * @return band The preferred Wi-Fi band, for use if the terminals support multiple bands.
   *     Possible values: All, 2.4GHz, 5GHz.
   */
  @JsonProperty(JSON_PROPERTY_BAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBand() {
    return band;
  }

  /**
   * The preferred Wi-Fi band, for use if the terminals support multiple bands. Possible values:
   * All, 2.4GHz, 5GHz.
   *
   * @param band The preferred Wi-Fi band, for use if the terminals support multiple bands. Possible
   *     values: All, 2.4GHz, 5GHz.
   */
  @JsonProperty(JSON_PROPERTY_BAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBand(String band) {
    this.band = band;
  }

  /**
   * Indicates whether roaming is enabled on the terminals.
   *
   * @param roaming Indicates whether roaming is enabled on the terminals.
   * @return the current {@code Settings} instance, allowing for method chaining
   */
  public Settings roaming(Boolean roaming) {
    this.roaming = roaming;
    return this;
  }

  /**
   * Indicates whether roaming is enabled on the terminals.
   *
   * @return roaming Indicates whether roaming is enabled on the terminals.
   */
  @JsonProperty(JSON_PROPERTY_ROAMING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRoaming() {
    return roaming;
  }

  /**
   * Indicates whether roaming is enabled on the terminals.
   *
   * @param roaming Indicates whether roaming is enabled on the terminals.
   */
  @JsonProperty(JSON_PROPERTY_ROAMING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoaming(Boolean roaming) {
    this.roaming = roaming;
  }

  /**
   * The connection time-out in seconds. Minimum value: 0.
   *
   * @param timeout The connection time-out in seconds. Minimum value: 0.
   * @return the current {@code Settings} instance, allowing for method chaining
   */
  public Settings timeout(Integer timeout) {
    this.timeout = timeout;
    return this;
  }

  /**
   * The connection time-out in seconds. Minimum value: 0.
   *
   * @return timeout The connection time-out in seconds. Minimum value: 0.
   */
  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getTimeout() {
    return timeout;
  }

  /**
   * The connection time-out in seconds. Minimum value: 0.
   *
   * @param timeout The connection time-out in seconds. Minimum value: 0.
   */
  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }

  /** Return true if this Settings object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Settings settings = (Settings) o;
    return Objects.equals(this.band, settings.band)
        && Objects.equals(this.roaming, settings.roaming)
        && Objects.equals(this.timeout, settings.timeout);
  }

  @Override
  public int hashCode() {
    return Objects.hash(band, roaming, timeout);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Settings {\n");
    sb.append("    band: ").append(toIndentedString(band)).append("\n");
    sb.append("    roaming: ").append(toIndentedString(roaming)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Settings given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Settings
   * @throws JsonProcessingException if the JSON string is invalid with respect to Settings
   */
  public static Settings fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Settings.class);
  }

  /**
   * Convert an instance of Settings to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
