/*
 * Management Webhooks
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.managementwebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** AccountCapabilityData */
@JsonPropertyOrder({
  AccountCapabilityData.JSON_PROPERTY_ALLOWED,
  AccountCapabilityData.JSON_PROPERTY_ALLOWED_LEVEL,
  AccountCapabilityData.JSON_PROPERTY_CAPABILITY,
  AccountCapabilityData.JSON_PROPERTY_PROBLEMS,
  AccountCapabilityData.JSON_PROPERTY_REQUESTED,
  AccountCapabilityData.JSON_PROPERTY_REQUESTED_LEVEL,
  AccountCapabilityData.JSON_PROPERTY_VERIFICATION_DEADLINE,
  AccountCapabilityData.JSON_PROPERTY_VERIFICATION_STATUS
})
public class AccountCapabilityData {
  public static final String JSON_PROPERTY_ALLOWED = "allowed";
  private Boolean allowed;

  public static final String JSON_PROPERTY_ALLOWED_LEVEL = "allowedLevel";
  private String allowedLevel;

  public static final String JSON_PROPERTY_CAPABILITY = "capability";
  private String capability;

  public static final String JSON_PROPERTY_PROBLEMS = "problems";
  private List<CapabilityProblem> problems;

  public static final String JSON_PROPERTY_REQUESTED = "requested";
  private Boolean requested;

  public static final String JSON_PROPERTY_REQUESTED_LEVEL = "requestedLevel";
  private String requestedLevel;

  public static final String JSON_PROPERTY_VERIFICATION_DEADLINE = "verificationDeadline";
  private OffsetDateTime verificationDeadline;

  public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
  private String verificationStatus;

  public AccountCapabilityData() {}

  /**
   * Indicates whether the capability is allowed. Adyen sets this to **true** if the verification is
   * successful.
   *
   * @param allowed Indicates whether the capability is allowed. Adyen sets this to **true** if the
   *     verification is successful.
   * @return the current {@code AccountCapabilityData} instance, allowing for method chaining
   */
  public AccountCapabilityData allowed(Boolean allowed) {
    this.allowed = allowed;
    return this;
  }

  /**
   * Indicates whether the capability is allowed. Adyen sets this to **true** if the verification is
   * successful.
   *
   * @return allowed Indicates whether the capability is allowed. Adyen sets this to **true** if the
   *     verification is successful.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAllowed() {
    return allowed;
  }

  /**
   * Indicates whether the capability is allowed. Adyen sets this to **true** if the verification is
   * successful.
   *
   * @param allowed Indicates whether the capability is allowed. Adyen sets this to **true** if the
   *     verification is successful.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowed(Boolean allowed) {
    this.allowed = allowed;
  }

  /**
   * The allowed level of the capability. Some capabilities have different levels which correspond
   * to thresholds. Higher levels may require additional checks and increased monitoring.Possible
   * values: **notApplicable**, **low**, **medium**, **high**.
   *
   * @param allowedLevel The allowed level of the capability. Some capabilities have different
   *     levels which correspond to thresholds. Higher levels may require additional checks and
   *     increased monitoring.Possible values: **notApplicable**, **low**, **medium**, **high**.
   * @return the current {@code AccountCapabilityData} instance, allowing for method chaining
   */
  public AccountCapabilityData allowedLevel(String allowedLevel) {
    this.allowedLevel = allowedLevel;
    return this;
  }

  /**
   * The allowed level of the capability. Some capabilities have different levels which correspond
   * to thresholds. Higher levels may require additional checks and increased monitoring.Possible
   * values: **notApplicable**, **low**, **medium**, **high**.
   *
   * @return allowedLevel The allowed level of the capability. Some capabilities have different
   *     levels which correspond to thresholds. Higher levels may require additional checks and
   *     increased monitoring.Possible values: **notApplicable**, **low**, **medium**, **high**.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAllowedLevel() {
    return allowedLevel;
  }

  /**
   * The allowed level of the capability. Some capabilities have different levels which correspond
   * to thresholds. Higher levels may require additional checks and increased monitoring.Possible
   * values: **notApplicable**, **low**, **medium**, **high**.
   *
   * @param allowedLevel The allowed level of the capability. Some capabilities have different
   *     levels which correspond to thresholds. Higher levels may require additional checks and
   *     increased monitoring.Possible values: **notApplicable**, **low**, **medium**, **high**.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedLevel(String allowedLevel) {
    this.allowedLevel = allowedLevel;
  }

  /**
   * The name of the capability. For example, **sendToTransferInstrument**.
   *
   * @param capability The name of the capability. For example, **sendToTransferInstrument**.
   * @return the current {@code AccountCapabilityData} instance, allowing for method chaining
   */
  public AccountCapabilityData capability(String capability) {
    this.capability = capability;
    return this;
  }

  /**
   * The name of the capability. For example, **sendToTransferInstrument**.
   *
   * @return capability The name of the capability. For example, **sendToTransferInstrument**.
   */
  @JsonProperty(JSON_PROPERTY_CAPABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCapability() {
    return capability;
  }

  /**
   * The name of the capability. For example, **sendToTransferInstrument**.
   *
   * @param capability The name of the capability. For example, **sendToTransferInstrument**.
   */
  @JsonProperty(JSON_PROPERTY_CAPABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapability(String capability) {
    this.capability = capability;
  }

  /**
   * List of entities that has problems with verification. The information includes the details of
   * the errors and the actions that you can take to resolve them.
   *
   * @param problems List of entities that has problems with verification. The information includes
   *     the details of the errors and the actions that you can take to resolve them.
   * @return the current {@code AccountCapabilityData} instance, allowing for method chaining
   */
  public AccountCapabilityData problems(List<CapabilityProblem> problems) {
    this.problems = problems;
    return this;
  }

  public AccountCapabilityData addProblemsItem(CapabilityProblem problemsItem) {
    if (this.problems == null) {
      this.problems = new ArrayList<>();
    }
    this.problems.add(problemsItem);
    return this;
  }

  /**
   * List of entities that has problems with verification. The information includes the details of
   * the errors and the actions that you can take to resolve them.
   *
   * @return problems List of entities that has problems with verification. The information includes
   *     the details of the errors and the actions that you can take to resolve them.
   */
  @JsonProperty(JSON_PROPERTY_PROBLEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<CapabilityProblem> getProblems() {
    return problems;
  }

  /**
   * List of entities that has problems with verification. The information includes the details of
   * the errors and the actions that you can take to resolve them.
   *
   * @param problems List of entities that has problems with verification. The information includes
   *     the details of the errors and the actions that you can take to resolve them.
   */
  @JsonProperty(JSON_PROPERTY_PROBLEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProblems(List<CapabilityProblem> problems) {
    this.problems = problems;
  }

  /**
   * Indicates whether you requested the capability.
   *
   * @param requested Indicates whether you requested the capability.
   * @return the current {@code AccountCapabilityData} instance, allowing for method chaining
   */
  public AccountCapabilityData requested(Boolean requested) {
    this.requested = requested;
    return this;
  }

  /**
   * Indicates whether you requested the capability.
   *
   * @return requested Indicates whether you requested the capability.
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRequested() {
    return requested;
  }

  /**
   * Indicates whether you requested the capability.
   *
   * @param requested Indicates whether you requested the capability.
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequested(Boolean requested) {
    this.requested = requested;
  }

  /**
   * The level that you requested for the capability. Some capabilities have different levels which
   * correspond to thresholds. Higher levels may require additional checks and increased
   * monitoring.Possible values: **notApplicable**, **low**, **medium**, **high**.
   *
   * @param requestedLevel The level that you requested for the capability. Some capabilities have
   *     different levels which correspond to thresholds. Higher levels may require additional
   *     checks and increased monitoring.Possible values: **notApplicable**, **low**, **medium**,
   *     **high**.
   * @return the current {@code AccountCapabilityData} instance, allowing for method chaining
   */
  public AccountCapabilityData requestedLevel(String requestedLevel) {
    this.requestedLevel = requestedLevel;
    return this;
  }

  /**
   * The level that you requested for the capability. Some capabilities have different levels which
   * correspond to thresholds. Higher levels may require additional checks and increased
   * monitoring.Possible values: **notApplicable**, **low**, **medium**, **high**.
   *
   * @return requestedLevel The level that you requested for the capability. Some capabilities have
   *     different levels which correspond to thresholds. Higher levels may require additional
   *     checks and increased monitoring.Possible values: **notApplicable**, **low**, **medium**,
   *     **high**.
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRequestedLevel() {
    return requestedLevel;
  }

  /**
   * The level that you requested for the capability. Some capabilities have different levels which
   * correspond to thresholds. Higher levels may require additional checks and increased
   * monitoring.Possible values: **notApplicable**, **low**, **medium**, **high**.
   *
   * @param requestedLevel The level that you requested for the capability. Some capabilities have
   *     different levels which correspond to thresholds. Higher levels may require additional
   *     checks and increased monitoring.Possible values: **notApplicable**, **low**, **medium**,
   *     **high**.
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestedLevel(String requestedLevel) {
    this.requestedLevel = requestedLevel;
  }

  /**
   * The verification deadline for the capability that will be disallowed if verification errors are
   * not resolved.
   *
   * @param verificationDeadline The verification deadline for the capability that will be
   *     disallowed if verification errors are not resolved.
   * @return the current {@code AccountCapabilityData} instance, allowing for method chaining
   */
  public AccountCapabilityData verificationDeadline(OffsetDateTime verificationDeadline) {
    this.verificationDeadline = verificationDeadline;
    return this;
  }

  /**
   * The verification deadline for the capability that will be disallowed if verification errors are
   * not resolved.
   *
   * @return verificationDeadline The verification deadline for the capability that will be
   *     disallowed if verification errors are not resolved.
   */
  @JsonProperty(JSON_PROPERTY_VERIFICATION_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getVerificationDeadline() {
    return verificationDeadline;
  }

  /**
   * The verification deadline for the capability that will be disallowed if verification errors are
   * not resolved.
   *
   * @param verificationDeadline The verification deadline for the capability that will be
   *     disallowed if verification errors are not resolved.
   */
  @JsonProperty(JSON_PROPERTY_VERIFICATION_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerificationDeadline(OffsetDateTime verificationDeadline) {
    this.verificationDeadline = verificationDeadline;
  }

  /**
   * The status of the verification checks for the capability. Possible values: * **pending**: Adyen
   * is running the verification. * **invalid**: The verification failed. Check if the
   * &#x60;errors&#x60; array contains more information. * **valid**: The verification was
   * successful. * **rejected**: Adyen checked the information and found reasons to not allow the
   * capability.
   *
   * @param verificationStatus The status of the verification checks for the capability. Possible
   *     values: * **pending**: Adyen is running the verification. * **invalid**: The verification
   *     failed. Check if the &#x60;errors&#x60; array contains more information. * **valid**: The
   *     verification was successful. * **rejected**: Adyen checked the information and found
   *     reasons to not allow the capability.
   * @return the current {@code AccountCapabilityData} instance, allowing for method chaining
   */
  public AccountCapabilityData verificationStatus(String verificationStatus) {
    this.verificationStatus = verificationStatus;
    return this;
  }

  /**
   * The status of the verification checks for the capability. Possible values: * **pending**: Adyen
   * is running the verification. * **invalid**: The verification failed. Check if the
   * &#x60;errors&#x60; array contains more information. * **valid**: The verification was
   * successful. * **rejected**: Adyen checked the information and found reasons to not allow the
   * capability.
   *
   * @return verificationStatus The status of the verification checks for the capability. Possible
   *     values: * **pending**: Adyen is running the verification. * **invalid**: The verification
   *     failed. Check if the &#x60;errors&#x60; array contains more information. * **valid**: The
   *     verification was successful. * **rejected**: Adyen checked the information and found
   *     reasons to not allow the capability.
   */
  @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getVerificationStatus() {
    return verificationStatus;
  }

  /**
   * The status of the verification checks for the capability. Possible values: * **pending**: Adyen
   * is running the verification. * **invalid**: The verification failed. Check if the
   * &#x60;errors&#x60; array contains more information. * **valid**: The verification was
   * successful. * **rejected**: Adyen checked the information and found reasons to not allow the
   * capability.
   *
   * @param verificationStatus The status of the verification checks for the capability. Possible
   *     values: * **pending**: Adyen is running the verification. * **invalid**: The verification
   *     failed. Check if the &#x60;errors&#x60; array contains more information. * **valid**: The
   *     verification was successful. * **rejected**: Adyen checked the information and found
   *     reasons to not allow the capability.
   */
  @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerificationStatus(String verificationStatus) {
    this.verificationStatus = verificationStatus;
  }

  /** Return true if this AccountCapabilityData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountCapabilityData accountCapabilityData = (AccountCapabilityData) o;
    return Objects.equals(this.allowed, accountCapabilityData.allowed)
        && Objects.equals(this.allowedLevel, accountCapabilityData.allowedLevel)
        && Objects.equals(this.capability, accountCapabilityData.capability)
        && Objects.equals(this.problems, accountCapabilityData.problems)
        && Objects.equals(this.requested, accountCapabilityData.requested)
        && Objects.equals(this.requestedLevel, accountCapabilityData.requestedLevel)
        && Objects.equals(this.verificationDeadline, accountCapabilityData.verificationDeadline)
        && Objects.equals(this.verificationStatus, accountCapabilityData.verificationStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        allowed,
        allowedLevel,
        capability,
        problems,
        requested,
        requestedLevel,
        verificationDeadline,
        verificationStatus);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountCapabilityData {\n");
    sb.append("    allowed: ").append(toIndentedString(allowed)).append("\n");
    sb.append("    allowedLevel: ").append(toIndentedString(allowedLevel)).append("\n");
    sb.append("    capability: ").append(toIndentedString(capability)).append("\n");
    sb.append("    problems: ").append(toIndentedString(problems)).append("\n");
    sb.append("    requested: ").append(toIndentedString(requested)).append("\n");
    sb.append("    requestedLevel: ").append(toIndentedString(requestedLevel)).append("\n");
    sb.append("    verificationDeadline: ")
        .append(toIndentedString(verificationDeadline))
        .append("\n");
    sb.append("    verificationStatus: ").append(toIndentedString(verificationStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of AccountCapabilityData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AccountCapabilityData
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     AccountCapabilityData
   */
  public static AccountCapabilityData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AccountCapabilityData.class);
  }

  /**
   * Convert an instance of AccountCapabilityData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
