/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/** Account */
@JsonPropertyOrder({
  Account.JSON_PROPERTY_ACCOUNT_CODE,
  Account.JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D,
  Account.JSON_PROPERTY_BENEFICIARY_ACCOUNT,
  Account.JSON_PROPERTY_BENEFICIARY_MERCHANT_REFERENCE,
  Account.JSON_PROPERTY_DESCRIPTION,
  Account.JSON_PROPERTY_METADATA,
  Account.JSON_PROPERTY_PAYOUT_METHOD_CODE,
  Account.JSON_PROPERTY_PAYOUT_SCHEDULE,
  Account.JSON_PROPERTY_PAYOUT_SPEED,
  Account.JSON_PROPERTY_STATUS
})
public class Account {
  public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
  private String accountCode;

  public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
  private String bankAccountUUID;

  public static final String JSON_PROPERTY_BENEFICIARY_ACCOUNT = "beneficiaryAccount";
  private String beneficiaryAccount;

  public static final String JSON_PROPERTY_BENEFICIARY_MERCHANT_REFERENCE =
      "beneficiaryMerchantReference";
  private String beneficiaryMerchantReference;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = null;

  public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
  private String payoutMethodCode;

  public static final String JSON_PROPERTY_PAYOUT_SCHEDULE = "payoutSchedule";
  private PayoutScheduleResponse payoutSchedule;

  /**
   * Speed with which payouts for this account are processed. Permitted values:
   * &#x60;STANDARD&#x60;, &#x60;SAME_DAY&#x60;.
   */
  public enum PayoutSpeedEnum {
    INSTANT("INSTANT"),

    SAME_DAY("SAME_DAY"),

    STANDARD("STANDARD");

    private String value;

    PayoutSpeedEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayoutSpeedEnum fromValue(String value) {
      for (PayoutSpeedEnum b : PayoutSpeedEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYOUT_SPEED = "payoutSpeed";
  private PayoutSpeedEnum payoutSpeed;

  public static final String JSON_PROPERTY_STATUS = "status";
  private String status;

  public Account() {}

  public Account accountCode(String accountCode) {
    this.accountCode = accountCode;
    return this;
  }

  /**
   * The code of the account.
   *
   * @return accountCode
   */
  @ApiModelProperty(value = "The code of the account.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountCode() {
    return accountCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountCode(String accountCode) {
    this.accountCode = accountCode;
  }

  public Account bankAccountUUID(String bankAccountUUID) {
    this.bankAccountUUID = bankAccountUUID;
    return this;
  }

  /**
   * The bankAccountUUID of the bank account held by the account holder to couple the account with.
   * Scheduled payouts in currencies matching the currency of this bank account will be sent to this
   * bank account. Payouts in different currencies will be sent to a matching bank account of the
   * account holder.
   *
   * @return bankAccountUUID
   */
  @ApiModelProperty(
      value =
          "The bankAccountUUID of the bank account held by the account holder to couple the account with. Scheduled payouts in currencies matching the currency of this bank account will be sent to this bank account. Payouts in different currencies will be sent to a matching bank account of the account holder.")
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBankAccountUUID() {
    return bankAccountUUID;
  }

  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccountUUID(String bankAccountUUID) {
    this.bankAccountUUID = bankAccountUUID;
  }

  public Account beneficiaryAccount(String beneficiaryAccount) {
    this.beneficiaryAccount = beneficiaryAccount;
    return this;
  }

  /**
   * The beneficiary of the account.
   *
   * @return beneficiaryAccount
   */
  @ApiModelProperty(value = "The beneficiary of the account.")
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBeneficiaryAccount() {
    return beneficiaryAccount;
  }

  @JsonProperty(JSON_PROPERTY_BENEFICIARY_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBeneficiaryAccount(String beneficiaryAccount) {
    this.beneficiaryAccount = beneficiaryAccount;
  }

  public Account beneficiaryMerchantReference(String beneficiaryMerchantReference) {
    this.beneficiaryMerchantReference = beneficiaryMerchantReference;
    return this;
  }

  /**
   * The reason that a beneficiary has been set up for this account. This may have been supplied
   * during the setup of a beneficiary at the discretion of the executing user.
   *
   * @return beneficiaryMerchantReference
   */
  @ApiModelProperty(
      value =
          "The reason that a beneficiary has been set up for this account. This may have been supplied during the setup of a beneficiary at the discretion of the executing user.")
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBeneficiaryMerchantReference() {
    return beneficiaryMerchantReference;
  }

  @JsonProperty(JSON_PROPERTY_BENEFICIARY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBeneficiaryMerchantReference(String beneficiaryMerchantReference) {
    this.beneficiaryMerchantReference = beneficiaryMerchantReference;
  }

  public Account description(String description) {
    this.description = description;
    return this;
  }

  /**
   * A description of the account.
   *
   * @return description
   */
  @ApiModelProperty(value = "A description of the account.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  public Account metadata(Map<String, String> metadata) {
    this.metadata = metadata;
    return this;
  }

  public Account putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * A set of key and value pairs for general use by the merchant. The keys do not have specific
   * names and may be used for storing miscellaneous data as desired. &gt; Note that during an
   * update of metadata, the omission of existing key-value pairs will result in the deletion of
   * those key-value pairs.
   *
   * @return metadata
   */
  @ApiModelProperty(
      value =
          "A set of key and value pairs for general use by the merchant. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getMetadata() {
    return metadata;
  }

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }

  public Account payoutMethodCode(String payoutMethodCode) {
    this.payoutMethodCode = payoutMethodCode;
    return this;
  }

  /**
   * The payout method code held by the account holder to couple the account with. Scheduled card
   * payouts will be sent using this payout method code.
   *
   * @return payoutMethodCode
   */
  @ApiModelProperty(
      value =
          "The payout method code held by the account holder to couple the account with. Scheduled card payouts will be sent using this payout method code.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_METHOD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPayoutMethodCode() {
    return payoutMethodCode;
  }

  @JsonProperty(JSON_PROPERTY_PAYOUT_METHOD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutMethodCode(String payoutMethodCode) {
    this.payoutMethodCode = payoutMethodCode;
  }

  public Account payoutSchedule(PayoutScheduleResponse payoutSchedule) {
    this.payoutSchedule = payoutSchedule;
    return this;
  }

  /**
   * Get payoutSchedule
   *
   * @return payoutSchedule
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYOUT_SCHEDULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayoutScheduleResponse getPayoutSchedule() {
    return payoutSchedule;
  }

  @JsonProperty(JSON_PROPERTY_PAYOUT_SCHEDULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutSchedule(PayoutScheduleResponse payoutSchedule) {
    this.payoutSchedule = payoutSchedule;
  }

  public Account payoutSpeed(PayoutSpeedEnum payoutSpeed) {
    this.payoutSpeed = payoutSpeed;
    return this;
  }

  /**
   * Speed with which payouts for this account are processed. Permitted values:
   * &#x60;STANDARD&#x60;, &#x60;SAME_DAY&#x60;.
   *
   * @return payoutSpeed
   */
  @ApiModelProperty(
      value =
          "Speed with which payouts for this account are processed. Permitted values: `STANDARD`, `SAME_DAY`.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_SPEED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayoutSpeedEnum getPayoutSpeed() {
    return payoutSpeed;
  }

  @JsonProperty(JSON_PROPERTY_PAYOUT_SPEED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutSpeed(PayoutSpeedEnum payoutSpeed) {
    this.payoutSpeed = payoutSpeed;
  }

  public Account status(String status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the account. Possible values: &#x60;Active&#x60;, &#x60;Inactive&#x60;,
   * &#x60;Suspended&#x60;, &#x60;Closed&#x60;.
   *
   * @return status
   */
  @ApiModelProperty(
      value =
          "The status of the account. Possible values: `Active`, `Inactive`, `Suspended`, `Closed`.")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStatus() {
    return status;
  }

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(String status) {
    this.status = status;
  }

  /** Return true if this Account object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Account account = (Account) o;
    return Objects.equals(this.accountCode, account.accountCode)
        && Objects.equals(this.bankAccountUUID, account.bankAccountUUID)
        && Objects.equals(this.beneficiaryAccount, account.beneficiaryAccount)
        && Objects.equals(this.beneficiaryMerchantReference, account.beneficiaryMerchantReference)
        && Objects.equals(this.description, account.description)
        && Objects.equals(this.metadata, account.metadata)
        && Objects.equals(this.payoutMethodCode, account.payoutMethodCode)
        && Objects.equals(this.payoutSchedule, account.payoutSchedule)
        && Objects.equals(this.payoutSpeed, account.payoutSpeed)
        && Objects.equals(this.status, account.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountCode,
        bankAccountUUID,
        beneficiaryAccount,
        beneficiaryMerchantReference,
        description,
        metadata,
        payoutMethodCode,
        payoutSchedule,
        payoutSpeed,
        status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Account {\n");
    sb.append("    accountCode: ").append(toIndentedString(accountCode)).append("\n");
    sb.append("    bankAccountUUID: ").append(toIndentedString(bankAccountUUID)).append("\n");
    sb.append("    beneficiaryAccount: ").append(toIndentedString(beneficiaryAccount)).append("\n");
    sb.append("    beneficiaryMerchantReference: ")
        .append(toIndentedString(beneficiaryMerchantReference))
        .append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    payoutMethodCode: ").append(toIndentedString(payoutMethodCode)).append("\n");
    sb.append("    payoutSchedule: ").append(toIndentedString(payoutSchedule)).append("\n");
    sb.append("    payoutSpeed: ").append(toIndentedString(payoutSpeed)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Account given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Account
   * @throws JsonProcessingException if the JSON string is invalid with respect to Account
   */
  public static Account fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Account.class);
  }

  /**
   * Convert an instance of Account to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
