/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** KYCCheckStatusData */
@JsonPropertyOrder({
  KYCCheckStatusData.JSON_PROPERTY_REQUIRED_FIELDS,
  KYCCheckStatusData.JSON_PROPERTY_STATUS,
  KYCCheckStatusData.JSON_PROPERTY_SUMMARY,
  KYCCheckStatusData.JSON_PROPERTY_TYPE
})
public class KYCCheckStatusData {
  public static final String JSON_PROPERTY_REQUIRED_FIELDS = "requiredFields";
  private List<String> requiredFields = null;

  /**
   * The status of the check. Possible values: **AWAITING_DATA** , **DATA_PROVIDED**, **FAILED**,
   * **INVALID_DATA**, **PASSED**, **PENDING**, **RETRY_LIMIT_REACHED**.
   */
  public enum StatusEnum {
    AWAITING_DATA("AWAITING_DATA"),

    DATA_PROVIDED("DATA_PROVIDED"),

    FAILED("FAILED"),

    INVALID_DATA("INVALID_DATA"),

    PASSED("PASSED"),

    PENDING("PENDING"),

    PENDING_REVIEW("PENDING_REVIEW"),

    RETRY_LIMIT_REACHED("RETRY_LIMIT_REACHED"),

    UNCHECKED("UNCHECKED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_SUMMARY = "summary";
  private KYCCheckSummary summary;

  /**
   * The type of check. Possible values: * **BANK_ACCOUNT_VERIFICATION**: Used in v5 and earlier.
   * Replaced by **PAYOUT_METHOD_VERIFICATION** in v6 and later. * **COMPANY_VERIFICATION** *
   * **CARD_VERIFICATION** * **IDENTITY_VERIFICATION** * **LEGAL_ARRANGEMENT_VERIFICATION** *
   * **NONPROFIT_VERIFICATION** * **PASSPORT_VERIFICATION** * **PAYOUT_METHOD_VERIFICATION**: Used
   * in v6 and later. * **PCI_VERIFICATION**
   */
  public enum TypeEnum {
    BANK_ACCOUNT_VERIFICATION("BANK_ACCOUNT_VERIFICATION"),

    CARD_VERIFICATION("CARD_VERIFICATION"),

    COMPANY_VERIFICATION("COMPANY_VERIFICATION"),

    IDENTITY_VERIFICATION("IDENTITY_VERIFICATION"),

    LEGAL_ARRANGEMENT_VERIFICATION("LEGAL_ARRANGEMENT_VERIFICATION"),

    NONPROFIT_VERIFICATION("NONPROFIT_VERIFICATION"),

    PASSPORT_VERIFICATION("PASSPORT_VERIFICATION"),

    PAYOUT_METHOD_VERIFICATION("PAYOUT_METHOD_VERIFICATION"),

    PCI_VERIFICATION("PCI_VERIFICATION");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public KYCCheckStatusData() {}

  public KYCCheckStatusData requiredFields(List<String> requiredFields) {
    this.requiredFields = requiredFields;
    return this;
  }

  public KYCCheckStatusData addRequiredFieldsItem(String requiredFieldsItem) {
    if (this.requiredFields == null) {
      this.requiredFields = new ArrayList<>();
    }
    this.requiredFields.add(requiredFieldsItem);
    return this;
  }

  /**
   * A list of the fields required for execution of the check.
   *
   * @return requiredFields
   */
  @ApiModelProperty(value = "A list of the fields required for execution of the check.")
  @JsonProperty(JSON_PROPERTY_REQUIRED_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getRequiredFields() {
    return requiredFields;
  }

  @JsonProperty(JSON_PROPERTY_REQUIRED_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredFields(List<String> requiredFields) {
    this.requiredFields = requiredFields;
  }

  public KYCCheckStatusData status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the check. Possible values: **AWAITING_DATA** , **DATA_PROVIDED**, **FAILED**,
   * **INVALID_DATA**, **PASSED**, **PENDING**, **RETRY_LIMIT_REACHED**.
   *
   * @return status
   */
  @ApiModelProperty(
      required = true,
      value =
          "The status of the check.  Possible values: **AWAITING_DATA** , **DATA_PROVIDED**, **FAILED**, **INVALID_DATA**, **PASSED**, **PENDING**, **RETRY_LIMIT_REACHED**.")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public KYCCheckStatusData summary(KYCCheckSummary summary) {
    this.summary = summary;
    return this;
  }

  /**
   * Get summary
   *
   * @return summary
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUMMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public KYCCheckSummary getSummary() {
    return summary;
  }

  @JsonProperty(JSON_PROPERTY_SUMMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSummary(KYCCheckSummary summary) {
    this.summary = summary;
  }

  public KYCCheckStatusData type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of check. Possible values: * **BANK_ACCOUNT_VERIFICATION**: Used in v5 and earlier.
   * Replaced by **PAYOUT_METHOD_VERIFICATION** in v6 and later. * **COMPANY_VERIFICATION** *
   * **CARD_VERIFICATION** * **IDENTITY_VERIFICATION** * **LEGAL_ARRANGEMENT_VERIFICATION** *
   * **NONPROFIT_VERIFICATION** * **PASSPORT_VERIFICATION** * **PAYOUT_METHOD_VERIFICATION**: Used
   * in v6 and later. * **PCI_VERIFICATION**
   *
   * @return type
   */
  @ApiModelProperty(
      required = true,
      value =
          "The type of check.  Possible values:   * **BANK_ACCOUNT_VERIFICATION**: Used in v5 and earlier. Replaced by **PAYOUT_METHOD_VERIFICATION** in v6 and later.   * **COMPANY_VERIFICATION**    * **CARD_VERIFICATION**  * **IDENTITY_VERIFICATION**  * **LEGAL_ARRANGEMENT_VERIFICATION**  * **NONPROFIT_VERIFICATION**   * **PASSPORT_VERIFICATION**  * **PAYOUT_METHOD_VERIFICATION**: Used in v6 and later.  * **PCI_VERIFICATION**")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this KYCCheckStatusData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KYCCheckStatusData kyCCheckStatusData = (KYCCheckStatusData) o;
    return Objects.equals(this.requiredFields, kyCCheckStatusData.requiredFields)
        && Objects.equals(this.status, kyCCheckStatusData.status)
        && Objects.equals(this.summary, kyCCheckStatusData.summary)
        && Objects.equals(this.type, kyCCheckStatusData.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requiredFields, status, summary, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class KYCCheckStatusData {\n");
    sb.append("    requiredFields: ").append(toIndentedString(requiredFields)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of KYCCheckStatusData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of KYCCheckStatusData
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     KYCCheckStatusData
   */
  public static KYCCheckStatusData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, KYCCheckStatusData.class);
  }

  /**
   * Convert an instance of KYCCheckStatusData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
