/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** LegalArrangementRequest */
@JsonPropertyOrder({
  LegalArrangementRequest.JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE,
  LegalArrangementRequest.JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODES
})
public class LegalArrangementRequest {
  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE = "legalArrangementCode";
  private String legalArrangementCode;

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODES =
      "legalArrangementEntityCodes";
  private List<String> legalArrangementEntityCodes = null;

  public LegalArrangementRequest() {}

  public LegalArrangementRequest legalArrangementCode(String legalArrangementCode) {
    this.legalArrangementCode = legalArrangementCode;
    return this;
  }

  /**
   * The code of the legal arrangement to be deleted. If you also send
   * &#x60;legalArrangementEntityCodes&#x60;, only the entities listed will be deleted.
   *
   * @return legalArrangementCode
   */
  @ApiModelProperty(
      required = true,
      value =
          "The code of the legal arrangement to be deleted. If you also send `legalArrangementEntityCodes`, only the entities listed will be deleted.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalArrangementCode() {
    return legalArrangementCode;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementCode(String legalArrangementCode) {
    this.legalArrangementCode = legalArrangementCode;
  }

  public LegalArrangementRequest legalArrangementEntityCodes(
      List<String> legalArrangementEntityCodes) {
    this.legalArrangementEntityCodes = legalArrangementEntityCodes;
    return this;
  }

  public LegalArrangementRequest addLegalArrangementEntityCodesItem(
      String legalArrangementEntityCodesItem) {
    if (this.legalArrangementEntityCodes == null) {
      this.legalArrangementEntityCodes = new ArrayList<>();
    }
    this.legalArrangementEntityCodes.add(legalArrangementEntityCodesItem);
    return this;
  }

  /**
   * List of legal arrangement entities to be deleted.
   *
   * @return legalArrangementEntityCodes
   */
  @ApiModelProperty(value = "List of legal arrangement entities to be deleted.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getLegalArrangementEntityCodes() {
    return legalArrangementEntityCodes;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementEntityCodes(List<String> legalArrangementEntityCodes) {
    this.legalArrangementEntityCodes = legalArrangementEntityCodes;
  }

  /** Return true if this LegalArrangementRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LegalArrangementRequest legalArrangementRequest = (LegalArrangementRequest) o;
    return Objects.equals(this.legalArrangementCode, legalArrangementRequest.legalArrangementCode)
        && Objects.equals(
            this.legalArrangementEntityCodes, legalArrangementRequest.legalArrangementEntityCodes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(legalArrangementCode, legalArrangementEntityCodes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LegalArrangementRequest {\n");
    sb.append("    legalArrangementCode: ")
        .append(toIndentedString(legalArrangementCode))
        .append("\n");
    sb.append("    legalArrangementEntityCodes: ")
        .append(toIndentedString(legalArrangementEntityCodes))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of LegalArrangementRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of LegalArrangementRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     LegalArrangementRequest
   */
  public static LegalArrangementRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, LegalArrangementRequest.class);
  }

  /**
   * Convert an instance of LegalArrangementRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
