/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** MigratedShareholders */
@JsonPropertyOrder({
  MigratedShareholders.JSON_PROPERTY_LEGAL_ENTITY_CODE,
  MigratedShareholders.JSON_PROPERTY_SHAREHOLDER_CODE
})
public class MigratedShareholders {
  public static final String JSON_PROPERTY_LEGAL_ENTITY_CODE = "legalEntityCode";
  private String legalEntityCode;

  public static final String JSON_PROPERTY_SHAREHOLDER_CODE = "shareholderCode";
  private String shareholderCode;

  public MigratedShareholders() {}

  public MigratedShareholders legalEntityCode(String legalEntityCode) {
    this.legalEntityCode = legalEntityCode;
    return this;
  }

  /**
   * The unique identifier of the legal entity of that shareholder in the balance platform.
   *
   * @return legalEntityCode
   */
  @ApiModelProperty(
      value =
          "The unique identifier of the legal entity of that shareholder in the balance platform.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalEntityCode() {
    return legalEntityCode;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalEntityCode(String legalEntityCode) {
    this.legalEntityCode = legalEntityCode;
  }

  public MigratedShareholders shareholderCode(String shareholderCode) {
    this.shareholderCode = shareholderCode;
    return this;
  }

  /**
   * The unique identifier of the account of the migrated shareholder in the classic integration.
   *
   * @return shareholderCode
   */
  @ApiModelProperty(
      value =
          "The unique identifier of the account of the migrated shareholder in the classic integration.")
  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShareholderCode() {
    return shareholderCode;
  }

  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShareholderCode(String shareholderCode) {
    this.shareholderCode = shareholderCode;
  }

  /** Return true if this MigratedShareholders object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigratedShareholders migratedShareholders = (MigratedShareholders) o;
    return Objects.equals(this.legalEntityCode, migratedShareholders.legalEntityCode)
        && Objects.equals(this.shareholderCode, migratedShareholders.shareholderCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(legalEntityCode, shareholderCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigratedShareholders {\n");
    sb.append("    legalEntityCode: ").append(toIndentedString(legalEntityCode)).append("\n");
    sb.append("    shareholderCode: ").append(toIndentedString(shareholderCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of MigratedShareholders given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of MigratedShareholders
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     MigratedShareholders
   */
  public static MigratedShareholders fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, MigratedShareholders.class);
  }

  /**
   * Convert an instance of MigratedShareholders to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
