/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** MigratedStores */
@JsonPropertyOrder({
  MigratedStores.JSON_PROPERTY_BUSINESS_LINE_ID,
  MigratedStores.JSON_PROPERTY_STORE_CODE,
  MigratedStores.JSON_PROPERTY_STORE_ID,
  MigratedStores.JSON_PROPERTY_STORE_REFERENCE
})
public class MigratedStores {
  public static final String JSON_PROPERTY_BUSINESS_LINE_ID = "businessLineId";
  private String businessLineId;

  public static final String JSON_PROPERTY_STORE_CODE = "storeCode";
  private String storeCode;

  public static final String JSON_PROPERTY_STORE_ID = "storeId";
  private String storeId;

  public static final String JSON_PROPERTY_STORE_REFERENCE = "storeReference";
  private String storeReference;

  public MigratedStores() {}

  public MigratedStores businessLineId(String businessLineId) {
    this.businessLineId = businessLineId;
    return this;
  }

  /**
   * The unique identifier of the business line associated with the migrated account holder in the
   * balance platform.
   *
   * @return businessLineId
   */
  @ApiModelProperty(
      value =
          "The unique identifier of the business line associated with the migrated account holder in the balance platform.")
  @JsonProperty(JSON_PROPERTY_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBusinessLineId() {
    return businessLineId;
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessLineId(String businessLineId) {
    this.businessLineId = businessLineId;
  }

  public MigratedStores storeCode(String storeCode) {
    this.storeCode = storeCode;
    return this;
  }

  /**
   * The unique identifier of the store associated with the migrated account holder in the classic
   * integration.
   *
   * @return storeCode
   */
  @ApiModelProperty(
      value =
          "The unique identifier of the store associated with the migrated account holder in the classic integration.")
  @JsonProperty(JSON_PROPERTY_STORE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStoreCode() {
    return storeCode;
  }

  @JsonProperty(JSON_PROPERTY_STORE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreCode(String storeCode) {
    this.storeCode = storeCode;
  }

  public MigratedStores storeId(String storeId) {
    this.storeId = storeId;
    return this;
  }

  /**
   * The unique identifier of the store associated with the migrated account holder in the balance
   * platform.
   *
   * @return storeId
   */
  @ApiModelProperty(
      value =
          "The unique identifier of the store associated with the migrated account holder in the balance platform.")
  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStoreId() {
    return storeId;
  }

  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreId(String storeId) {
    this.storeId = storeId;
  }

  public MigratedStores storeReference(String storeReference) {
    this.storeReference = storeReference;
    return this;
  }

  /**
   * Your reference for the store in the classic integration. The [Customer
   * Area](https://ca-test.adyen.com/) uses this value for the store description.
   *
   * @return storeReference
   */
  @ApiModelProperty(
      value =
          "Your reference for the store in the classic integration. The [Customer Area](https://ca-test.adyen.com/) uses this value for the store description.")
  @JsonProperty(JSON_PROPERTY_STORE_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStoreReference() {
    return storeReference;
  }

  @JsonProperty(JSON_PROPERTY_STORE_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreReference(String storeReference) {
    this.storeReference = storeReference;
  }

  /** Return true if this MigratedStores object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigratedStores migratedStores = (MigratedStores) o;
    return Objects.equals(this.businessLineId, migratedStores.businessLineId)
        && Objects.equals(this.storeCode, migratedStores.storeCode)
        && Objects.equals(this.storeId, migratedStores.storeId)
        && Objects.equals(this.storeReference, migratedStores.storeReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessLineId, storeCode, storeId, storeReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigratedStores {\n");
    sb.append("    businessLineId: ").append(toIndentedString(businessLineId)).append("\n");
    sb.append("    storeCode: ").append(toIndentedString(storeCode)).append("\n");
    sb.append("    storeId: ").append(toIndentedString(storeId)).append("\n");
    sb.append("    storeReference: ").append(toIndentedString(storeReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of MigratedStores given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of MigratedStores
   * @throws JsonProcessingException if the JSON string is invalid with respect to MigratedStores
   */
  public static MigratedStores fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, MigratedStores.class);
  }

  /**
   * Convert an instance of MigratedStores to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
