/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/** UpdateAccountRequest */
@JsonPropertyOrder({
  UpdateAccountRequest.JSON_PROPERTY_ACCOUNT_CODE,
  UpdateAccountRequest.JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D,
  UpdateAccountRequest.JSON_PROPERTY_DESCRIPTION,
  UpdateAccountRequest.JSON_PROPERTY_METADATA,
  UpdateAccountRequest.JSON_PROPERTY_PAYOUT_METHOD_CODE,
  UpdateAccountRequest.JSON_PROPERTY_PAYOUT_SCHEDULE,
  UpdateAccountRequest.JSON_PROPERTY_PAYOUT_SPEED
})
public class UpdateAccountRequest {
  public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
  private String accountCode;

  public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
  private String bankAccountUUID;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = null;

  public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
  private String payoutMethodCode;

  public static final String JSON_PROPERTY_PAYOUT_SCHEDULE = "payoutSchedule";
  private UpdatePayoutScheduleRequest payoutSchedule;

  /**
   * Speed with which payouts for this account are processed. Permitted values:
   * &#x60;STANDARD&#x60;, &#x60;SAME_DAY&#x60;.
   */
  public enum PayoutSpeedEnum {
    INSTANT("INSTANT"),

    SAME_DAY("SAME_DAY"),

    STANDARD("STANDARD");

    private String value;

    PayoutSpeedEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayoutSpeedEnum fromValue(String value) {
      for (PayoutSpeedEnum b : PayoutSpeedEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYOUT_SPEED = "payoutSpeed";
  private PayoutSpeedEnum payoutSpeed;

  public UpdateAccountRequest() {}

  public UpdateAccountRequest accountCode(String accountCode) {
    this.accountCode = accountCode;
    return this;
  }

  /**
   * The code of the account to update.
   *
   * @return accountCode
   */
  @ApiModelProperty(required = true, value = "The code of the account to update.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountCode() {
    return accountCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountCode(String accountCode) {
    this.accountCode = accountCode;
  }

  public UpdateAccountRequest bankAccountUUID(String bankAccountUUID) {
    this.bankAccountUUID = bankAccountUUID;
    return this;
  }

  /**
   * The bankAccountUUID of the bank account held by the account holder to couple the account with.
   * Scheduled payouts in currencies matching the currency of this bank account will be sent to this
   * bank account. Payouts in different currencies will be sent to a matching bank account of the
   * account holder.
   *
   * @return bankAccountUUID
   */
  @ApiModelProperty(
      value =
          "The bankAccountUUID of the bank account held by the account holder to couple the account with. Scheduled payouts in currencies matching the currency of this bank account will be sent to this bank account. Payouts in different currencies will be sent to a matching bank account of the account holder.")
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBankAccountUUID() {
    return bankAccountUUID;
  }

  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccountUUID(String bankAccountUUID) {
    this.bankAccountUUID = bankAccountUUID;
  }

  public UpdateAccountRequest description(String description) {
    this.description = description;
    return this;
  }

  /**
   * A description of the account, maximum 256 characters.You can use alphanumeric characters (A-Z,
   * a-z, 0-9), white spaces, and underscores &#x60;_&#x60;.
   *
   * @return description
   */
  @ApiModelProperty(
      value =
          "A description of the account, maximum 256 characters.You can use alphanumeric characters (A-Z, a-z, 0-9), white spaces, and underscores `_`.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  public UpdateAccountRequest metadata(Map<String, String> metadata) {
    this.metadata = metadata;
    return this;
  }

  public UpdateAccountRequest putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * A set of key and value pairs for general use by the merchant. The keys do not have specific
   * names and may be used for storing miscellaneous data as desired. &gt; Note that during an
   * update of metadata, the omission of existing key-value pairs will result in the deletion of
   * those key-value pairs.
   *
   * @return metadata
   */
  @ApiModelProperty(
      value =
          "A set of key and value pairs for general use by the merchant. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getMetadata() {
    return metadata;
  }

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }

  public UpdateAccountRequest payoutMethodCode(String payoutMethodCode) {
    this.payoutMethodCode = payoutMethodCode;
    return this;
  }

  /**
   * The payout method code held by the account holder to couple the account with. Scheduled card
   * payouts will be sent using this payout method code.
   *
   * @return payoutMethodCode
   */
  @ApiModelProperty(
      value =
          "The payout method code held by the account holder to couple the account with. Scheduled card payouts will be sent using this payout method code.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_METHOD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPayoutMethodCode() {
    return payoutMethodCode;
  }

  @JsonProperty(JSON_PROPERTY_PAYOUT_METHOD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutMethodCode(String payoutMethodCode) {
    this.payoutMethodCode = payoutMethodCode;
  }

  public UpdateAccountRequest payoutSchedule(UpdatePayoutScheduleRequest payoutSchedule) {
    this.payoutSchedule = payoutSchedule;
    return this;
  }

  /**
   * Get payoutSchedule
   *
   * @return payoutSchedule
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYOUT_SCHEDULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public UpdatePayoutScheduleRequest getPayoutSchedule() {
    return payoutSchedule;
  }

  @JsonProperty(JSON_PROPERTY_PAYOUT_SCHEDULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutSchedule(UpdatePayoutScheduleRequest payoutSchedule) {
    this.payoutSchedule = payoutSchedule;
  }

  public UpdateAccountRequest payoutSpeed(PayoutSpeedEnum payoutSpeed) {
    this.payoutSpeed = payoutSpeed;
    return this;
  }

  /**
   * Speed with which payouts for this account are processed. Permitted values:
   * &#x60;STANDARD&#x60;, &#x60;SAME_DAY&#x60;.
   *
   * @return payoutSpeed
   */
  @ApiModelProperty(
      value =
          "Speed with which payouts for this account are processed. Permitted values: `STANDARD`, `SAME_DAY`.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_SPEED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayoutSpeedEnum getPayoutSpeed() {
    return payoutSpeed;
  }

  @JsonProperty(JSON_PROPERTY_PAYOUT_SPEED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutSpeed(PayoutSpeedEnum payoutSpeed) {
    this.payoutSpeed = payoutSpeed;
  }

  /** Return true if this UpdateAccountRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateAccountRequest updateAccountRequest = (UpdateAccountRequest) o;
    return Objects.equals(this.accountCode, updateAccountRequest.accountCode)
        && Objects.equals(this.bankAccountUUID, updateAccountRequest.bankAccountUUID)
        && Objects.equals(this.description, updateAccountRequest.description)
        && Objects.equals(this.metadata, updateAccountRequest.metadata)
        && Objects.equals(this.payoutMethodCode, updateAccountRequest.payoutMethodCode)
        && Objects.equals(this.payoutSchedule, updateAccountRequest.payoutSchedule)
        && Objects.equals(this.payoutSpeed, updateAccountRequest.payoutSpeed);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountCode,
        bankAccountUUID,
        description,
        metadata,
        payoutMethodCode,
        payoutSchedule,
        payoutSpeed);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateAccountRequest {\n");
    sb.append("    accountCode: ").append(toIndentedString(accountCode)).append("\n");
    sb.append("    bankAccountUUID: ").append(toIndentedString(bankAccountUUID)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    payoutMethodCode: ").append(toIndentedString(payoutMethodCode)).append("\n");
    sb.append("    payoutSchedule: ").append(toIndentedString(payoutSchedule)).append("\n");
    sb.append("    payoutSpeed: ").append(toIndentedString(payoutSpeed)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of UpdateAccountRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of UpdateAccountRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     UpdateAccountRequest
   */
  public static UpdateAccountRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, UpdateAccountRequest.class);
  }

  /**
   * Convert an instance of UpdateAccountRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
