/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** ViasPhoneNumber */
@JsonPropertyOrder({
  ViasPhoneNumber.JSON_PROPERTY_PHONE_COUNTRY_CODE,
  ViasPhoneNumber.JSON_PROPERTY_PHONE_NUMBER,
  ViasPhoneNumber.JSON_PROPERTY_PHONE_TYPE
})
public class ViasPhoneNumber {
  public static final String JSON_PROPERTY_PHONE_COUNTRY_CODE = "phoneCountryCode";
  private String phoneCountryCode;

  public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
  private String phoneNumber;

  /**
   * The type of the phone number. &gt;The following values are permitted: &#x60;Landline&#x60;,
   * &#x60;Mobile&#x60;, &#x60;SIP&#x60;, &#x60;Fax&#x60;.
   */
  public enum PhoneTypeEnum {
    FAX("Fax"),

    LANDLINE("Landline"),

    MOBILE("Mobile"),

    SIP("SIP");

    private String value;

    PhoneTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PhoneTypeEnum fromValue(String value) {
      for (PhoneTypeEnum b : PhoneTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PHONE_TYPE = "phoneType";
  private PhoneTypeEnum phoneType;

  public ViasPhoneNumber() {}

  public ViasPhoneNumber phoneCountryCode(String phoneCountryCode) {
    this.phoneCountryCode = phoneCountryCode;
    return this;
  }

  /**
   * The two-character country code of the phone number. &gt;The permitted country codes are defined
   * in ISO-3166-1 alpha-2 (e.g. &#39;NL&#39;).
   *
   * @return phoneCountryCode
   */
  @ApiModelProperty(
      value =
          "The two-character country code of the phone number. >The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. 'NL').")
  @JsonProperty(JSON_PROPERTY_PHONE_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPhoneCountryCode() {
    return phoneCountryCode;
  }

  @JsonProperty(JSON_PROPERTY_PHONE_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneCountryCode(String phoneCountryCode) {
    this.phoneCountryCode = phoneCountryCode;
  }

  public ViasPhoneNumber phoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * The phone number. &gt;The inclusion of the phone number country code is not necessary.
   *
   * @return phoneNumber
   */
  @ApiModelProperty(
      value = "The phone number. >The inclusion of the phone number country code is not necessary.")
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPhoneNumber() {
    return phoneNumber;
  }

  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  public ViasPhoneNumber phoneType(PhoneTypeEnum phoneType) {
    this.phoneType = phoneType;
    return this;
  }

  /**
   * The type of the phone number. &gt;The following values are permitted: &#x60;Landline&#x60;,
   * &#x60;Mobile&#x60;, &#x60;SIP&#x60;, &#x60;Fax&#x60;.
   *
   * @return phoneType
   */
  @ApiModelProperty(
      value =
          "The type of the phone number. >The following values are permitted: `Landline`, `Mobile`, `SIP`, `Fax`.")
  @JsonProperty(JSON_PROPERTY_PHONE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PhoneTypeEnum getPhoneType() {
    return phoneType;
  }

  @JsonProperty(JSON_PROPERTY_PHONE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneType(PhoneTypeEnum phoneType) {
    this.phoneType = phoneType;
  }

  /** Return true if this ViasPhoneNumber object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ViasPhoneNumber viasPhoneNumber = (ViasPhoneNumber) o;
    return Objects.equals(this.phoneCountryCode, viasPhoneNumber.phoneCountryCode)
        && Objects.equals(this.phoneNumber, viasPhoneNumber.phoneNumber)
        && Objects.equals(this.phoneType, viasPhoneNumber.phoneType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(phoneCountryCode, phoneNumber, phoneType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ViasPhoneNumber {\n");
    sb.append("    phoneCountryCode: ").append(toIndentedString(phoneCountryCode)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    phoneType: ").append(toIndentedString(phoneType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ViasPhoneNumber given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ViasPhoneNumber
   * @throws JsonProcessingException if the JSON string is invalid with respect to ViasPhoneNumber
   */
  public static ViasPhoneNumber fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ViasPhoneNumber.class);
  }

  /**
   * Convert an instance of ViasPhoneNumber to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
