/*
 * Fund API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Fund API provides endpoints for managing the funds in the accounts on your platform. These management operations include, for example, the transfer of funds from one account to another, the payout of funds to an account holder, and the retrieval of balances in an account.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Fund API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Fund/v6/accountHolderBalance ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayfund;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** SetupBeneficiaryRequest */
@JsonPropertyOrder({
  SetupBeneficiaryRequest.JSON_PROPERTY_DESTINATION_ACCOUNT_CODE,
  SetupBeneficiaryRequest.JSON_PROPERTY_MERCHANT_REFERENCE,
  SetupBeneficiaryRequest.JSON_PROPERTY_SOURCE_ACCOUNT_CODE
})
public class SetupBeneficiaryRequest {
  public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_CODE = "destinationAccountCode";
  private String destinationAccountCode;

  public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
  private String merchantReference;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT_CODE = "sourceAccountCode";
  private String sourceAccountCode;

  public SetupBeneficiaryRequest() {}

  public SetupBeneficiaryRequest destinationAccountCode(String destinationAccountCode) {
    this.destinationAccountCode = destinationAccountCode;
    return this;
  }

  /**
   * The destination account code.
   *
   * @return destinationAccountCode
   */
  @ApiModelProperty(required = true, value = "The destination account code.")
  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDestinationAccountCode() {
    return destinationAccountCode;
  }

  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationAccountCode(String destinationAccountCode) {
    this.destinationAccountCode = destinationAccountCode;
  }

  public SetupBeneficiaryRequest merchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
    return this;
  }

  /**
   * A value that can be supplied at the discretion of the executing user.
   *
   * @return merchantReference
   */
  @ApiModelProperty(value = "A value that can be supplied at the discretion of the executing user.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantReference() {
    return merchantReference;
  }

  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }

  public SetupBeneficiaryRequest sourceAccountCode(String sourceAccountCode) {
    this.sourceAccountCode = sourceAccountCode;
    return this;
  }

  /**
   * The benefactor account.
   *
   * @return sourceAccountCode
   */
  @ApiModelProperty(required = true, value = "The benefactor account.")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSourceAccountCode() {
    return sourceAccountCode;
  }

  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAccountCode(String sourceAccountCode) {
    this.sourceAccountCode = sourceAccountCode;
  }

  /** Return true if this SetupBeneficiaryRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SetupBeneficiaryRequest setupBeneficiaryRequest = (SetupBeneficiaryRequest) o;
    return Objects.equals(
            this.destinationAccountCode, setupBeneficiaryRequest.destinationAccountCode)
        && Objects.equals(this.merchantReference, setupBeneficiaryRequest.merchantReference)
        && Objects.equals(this.sourceAccountCode, setupBeneficiaryRequest.sourceAccountCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(destinationAccountCode, merchantReference, sourceAccountCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SetupBeneficiaryRequest {\n");
    sb.append("    destinationAccountCode: ")
        .append(toIndentedString(destinationAccountCode))
        .append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    sourceAccountCode: ").append(toIndentedString(sourceAccountCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of SetupBeneficiaryRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SetupBeneficiaryRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     SetupBeneficiaryRequest
   */
  public static SetupBeneficiaryRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SetupBeneficiaryRequest.class);
  }

  /**
   * Convert an instance of SetupBeneficiaryRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
