/*
 * Fund API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Fund API provides endpoints for managing the funds in the accounts on your platform. These management operations include, for example, the transfer of funds from one account to another, the payout of funds to an account holder, and the retrieval of balances in an account.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Fund API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Fund/v6/accountHolderBalance ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayfund;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** TransferFundsRequest */
@JsonPropertyOrder({
  TransferFundsRequest.JSON_PROPERTY_AMOUNT,
  TransferFundsRequest.JSON_PROPERTY_DESTINATION_ACCOUNT_CODE,
  TransferFundsRequest.JSON_PROPERTY_MERCHANT_REFERENCE,
  TransferFundsRequest.JSON_PROPERTY_SOURCE_ACCOUNT_CODE,
  TransferFundsRequest.JSON_PROPERTY_TRANSFER_CODE
})
public class TransferFundsRequest {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_CODE = "destinationAccountCode";
  private String destinationAccountCode;

  public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
  private String merchantReference;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT_CODE = "sourceAccountCode";
  private String sourceAccountCode;

  public static final String JSON_PROPERTY_TRANSFER_CODE = "transferCode";
  private String transferCode;

  public TransferFundsRequest() {}

  public TransferFundsRequest amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   *
   * @return amount
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  public TransferFundsRequest destinationAccountCode(String destinationAccountCode) {
    this.destinationAccountCode = destinationAccountCode;
    return this;
  }

  /**
   * The code of the account to which the funds are to be credited. &gt;The state of the Account
   * Holder of this account must be Active.
   *
   * @return destinationAccountCode
   */
  @ApiModelProperty(
      required = true,
      value =
          "The code of the account to which the funds are to be credited. >The state of the Account Holder of this account must be Active.")
  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDestinationAccountCode() {
    return destinationAccountCode;
  }

  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationAccountCode(String destinationAccountCode) {
    this.destinationAccountCode = destinationAccountCode;
  }

  public TransferFundsRequest merchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
    return this;
  }

  /**
   * A value that can be supplied at the discretion of the executing user in order to link multiple
   * transactions to one another.
   *
   * @return merchantReference
   */
  @ApiModelProperty(
      value =
          "A value that can be supplied at the discretion of the executing user in order to link multiple transactions to one another.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantReference() {
    return merchantReference;
  }

  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }

  public TransferFundsRequest sourceAccountCode(String sourceAccountCode) {
    this.sourceAccountCode = sourceAccountCode;
    return this;
  }

  /**
   * The code of the account from which the funds are to be debited. &gt;The state of the Account
   * Holder of this account must be Active and allow payouts.
   *
   * @return sourceAccountCode
   */
  @ApiModelProperty(
      required = true,
      value =
          "The code of the account from which the funds are to be debited. >The state of the Account Holder of this account must be Active and allow payouts.")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSourceAccountCode() {
    return sourceAccountCode;
  }

  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAccountCode(String sourceAccountCode) {
    this.sourceAccountCode = sourceAccountCode;
  }

  public TransferFundsRequest transferCode(String transferCode) {
    this.transferCode = transferCode;
    return this;
  }

  /**
   * The code related to the type of transfer being performed. &gt;The permitted codes differ for
   * each platform account and are defined in their service level agreement.
   *
   * @return transferCode
   */
  @ApiModelProperty(
      required = true,
      value =
          "The code related to the type of transfer being performed. >The permitted codes differ for each platform account and are defined in their service level agreement.")
  @JsonProperty(JSON_PROPERTY_TRANSFER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTransferCode() {
    return transferCode;
  }

  @JsonProperty(JSON_PROPERTY_TRANSFER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferCode(String transferCode) {
    this.transferCode = transferCode;
  }

  /** Return true if this TransferFundsRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferFundsRequest transferFundsRequest = (TransferFundsRequest) o;
    return Objects.equals(this.amount, transferFundsRequest.amount)
        && Objects.equals(this.destinationAccountCode, transferFundsRequest.destinationAccountCode)
        && Objects.equals(this.merchantReference, transferFundsRequest.merchantReference)
        && Objects.equals(this.sourceAccountCode, transferFundsRequest.sourceAccountCode)
        && Objects.equals(this.transferCode, transferFundsRequest.transferCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        amount, destinationAccountCode, merchantReference, sourceAccountCode, transferCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferFundsRequest {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    destinationAccountCode: ")
        .append(toIndentedString(destinationAccountCode))
        .append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    sourceAccountCode: ").append(toIndentedString(sourceAccountCode)).append("\n");
    sb.append("    transferCode: ").append(toIndentedString(transferCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of TransferFundsRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransferFundsRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     TransferFundsRequest
   */
  public static TransferFundsRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TransferFundsRequest.class);
  }

  /**
   * Convert an instance of TransferFundsRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
