/*
 * Hosted onboarding API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Hosted onboarding API provides endpoints that you can use to generate links to Adyen-hosted pages, such as an [onboarding page](https://docs.adyen.com/marketplaces-and-platforms/classic/hosted-onboarding-page) or a [PCI compliance questionnaire](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-partners). You can provide these links to your account holders so that they can complete their onboarding.  ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Hosted onboarding API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Hop/v6/getOnboardingUrl ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayhop;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** CollectInformation */
@JsonPropertyOrder({
  CollectInformation.JSON_PROPERTY_BANK_DETAILS,
  CollectInformation.JSON_PROPERTY_BUSINESS_DETAILS,
  CollectInformation.JSON_PROPERTY_INDIVIDUAL_DETAILS,
  CollectInformation.JSON_PROPERTY_LEGAL_ARRANGEMENT_DETAILS,
  CollectInformation.JSON_PROPERTY_PCI_QUESTIONNAIRE,
  CollectInformation.JSON_PROPERTY_SHAREHOLDER_DETAILS
})
public class CollectInformation {
  public static final String JSON_PROPERTY_BANK_DETAILS = "bankDetails";
  private Boolean bankDetails;

  public static final String JSON_PROPERTY_BUSINESS_DETAILS = "businessDetails";
  private Boolean businessDetails;

  public static final String JSON_PROPERTY_INDIVIDUAL_DETAILS = "individualDetails";
  private Boolean individualDetails;

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_DETAILS = "legalArrangementDetails";
  private Boolean legalArrangementDetails;

  public static final String JSON_PROPERTY_PCI_QUESTIONNAIRE = "pciQuestionnaire";
  private Boolean pciQuestionnaire;

  public static final String JSON_PROPERTY_SHAREHOLDER_DETAILS = "shareholderDetails";
  private Boolean shareholderDetails;

  public CollectInformation() {}

  public CollectInformation bankDetails(Boolean bankDetails) {
    this.bankDetails = bankDetails;
    return this;
  }

  /**
   * Indicates whether [bank account
   * details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/bank-account-check)
   * must be collected. Default is **true**.
   *
   * @return bankDetails
   */
  @ApiModelProperty(
      value =
          "Indicates whether [bank account details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/bank-account-check) must be collected. Default is **true**.")
  @JsonProperty(JSON_PROPERTY_BANK_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getBankDetails() {
    return bankDetails;
  }

  @JsonProperty(JSON_PROPERTY_BANK_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankDetails(Boolean bankDetails) {
    this.bankDetails = bankDetails;
  }

  public CollectInformation businessDetails(Boolean businessDetails) {
    this.businessDetails = businessDetails;
    return this;
  }

  /**
   * Indicates whether [business
   * details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/company-check)
   * must be collected. Default is **true**.
   *
   * @return businessDetails
   */
  @ApiModelProperty(
      value =
          "Indicates whether [business details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/company-check) must be collected. Default is **true**.")
  @JsonProperty(JSON_PROPERTY_BUSINESS_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getBusinessDetails() {
    return businessDetails;
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessDetails(Boolean businessDetails) {
    this.businessDetails = businessDetails;
  }

  public CollectInformation individualDetails(Boolean individualDetails) {
    this.individualDetails = individualDetails;
    return this;
  }

  /**
   * Indicates whether [individual
   * details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/identity-check)
   * must be collected. Default is **true**.
   *
   * @return individualDetails
   */
  @ApiModelProperty(
      value =
          "Indicates whether [individual details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/identity-check) must be collected. Default is **true**.")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIndividualDetails() {
    return individualDetails;
  }

  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndividualDetails(Boolean individualDetails) {
    this.individualDetails = individualDetails;
  }

  public CollectInformation legalArrangementDetails(Boolean legalArrangementDetails) {
    this.legalArrangementDetails = legalArrangementDetails;
    return this;
  }

  /**
   * Indicates whether [legal arrangement
   * details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/legal-arrangements)
   * must be collected. Default is **true**.
   *
   * @return legalArrangementDetails
   */
  @ApiModelProperty(
      value =
          "Indicates whether [legal arrangement details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/legal-arrangements) must be collected. Default is **true**.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getLegalArrangementDetails() {
    return legalArrangementDetails;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementDetails(Boolean legalArrangementDetails) {
    this.legalArrangementDetails = legalArrangementDetails;
  }

  public CollectInformation pciQuestionnaire(Boolean pciQuestionnaire) {
    this.pciQuestionnaire = pciQuestionnaire;
    return this;
  }

  /**
   * Indicates whether answers to a [PCI
   * questionnaire](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-partners#onboard-partner-platform)
   * must be collected. Applies only to partner platforms. Default is **true**.
   *
   * @return pciQuestionnaire
   */
  @ApiModelProperty(
      value =
          "Indicates whether answers to a [PCI questionnaire](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-partners#onboard-partner-platform) must be collected. Applies only to partner platforms. Default is **true**.")
  @JsonProperty(JSON_PROPERTY_PCI_QUESTIONNAIRE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getPciQuestionnaire() {
    return pciQuestionnaire;
  }

  @JsonProperty(JSON_PROPERTY_PCI_QUESTIONNAIRE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPciQuestionnaire(Boolean pciQuestionnaire) {
    this.pciQuestionnaire = pciQuestionnaire;
  }

  public CollectInformation shareholderDetails(Boolean shareholderDetails) {
    this.shareholderDetails = shareholderDetails;
    return this;
  }

  /**
   * Indicates whether [shareholder
   * details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/identity-check)
   * must be collected. Defaults to **true**.
   *
   * @return shareholderDetails
   */
  @ApiModelProperty(
      value =
          "Indicates whether [shareholder details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/identity-check) must be collected. Defaults to **true**.")
  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getShareholderDetails() {
    return shareholderDetails;
  }

  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShareholderDetails(Boolean shareholderDetails) {
    this.shareholderDetails = shareholderDetails;
  }

  /** Return true if this CollectInformation object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CollectInformation collectInformation = (CollectInformation) o;
    return Objects.equals(this.bankDetails, collectInformation.bankDetails)
        && Objects.equals(this.businessDetails, collectInformation.businessDetails)
        && Objects.equals(this.individualDetails, collectInformation.individualDetails)
        && Objects.equals(this.legalArrangementDetails, collectInformation.legalArrangementDetails)
        && Objects.equals(this.pciQuestionnaire, collectInformation.pciQuestionnaire)
        && Objects.equals(this.shareholderDetails, collectInformation.shareholderDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        bankDetails,
        businessDetails,
        individualDetails,
        legalArrangementDetails,
        pciQuestionnaire,
        shareholderDetails);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CollectInformation {\n");
    sb.append("    bankDetails: ").append(toIndentedString(bankDetails)).append("\n");
    sb.append("    businessDetails: ").append(toIndentedString(businessDetails)).append("\n");
    sb.append("    individualDetails: ").append(toIndentedString(individualDetails)).append("\n");
    sb.append("    legalArrangementDetails: ")
        .append(toIndentedString(legalArrangementDetails))
        .append("\n");
    sb.append("    pciQuestionnaire: ").append(toIndentedString(pciQuestionnaire)).append("\n");
    sb.append("    shareholderDetails: ").append(toIndentedString(shareholderDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of CollectInformation given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CollectInformation
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     CollectInformation
   */
  public static CollectInformation fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CollectInformation.class);
  }

  /**
   * Convert an instance of CollectInformation to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
