/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** AccountHolderStatusChangeNotificationContent */
@JsonPropertyOrder({
  AccountHolderStatusChangeNotificationContent.JSON_PROPERTY_ACCOUNT_HOLDER_CODE,
  AccountHolderStatusChangeNotificationContent.JSON_PROPERTY_INVALID_FIELDS,
  AccountHolderStatusChangeNotificationContent.JSON_PROPERTY_NEW_STATUS,
  AccountHolderStatusChangeNotificationContent.JSON_PROPERTY_OLD_STATUS,
  AccountHolderStatusChangeNotificationContent.JSON_PROPERTY_REASON
})
public class AccountHolderStatusChangeNotificationContent {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
  private String accountHolderCode;

  public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
  private List<ErrorFieldType> invalidFields = null;

  public static final String JSON_PROPERTY_NEW_STATUS = "newStatus";
  private AccountHolderStatus newStatus;

  public static final String JSON_PROPERTY_OLD_STATUS = "oldStatus";
  private AccountHolderStatus oldStatus;

  public static final String JSON_PROPERTY_REASON = "reason";
  private String reason;

  public AccountHolderStatusChangeNotificationContent() {}

  public AccountHolderStatusChangeNotificationContent accountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
    return this;
  }

  /**
   * The code of the account holder.
   *
   * @return accountHolderCode
   */
  @ApiModelProperty(required = true, value = "The code of the account holder.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountHolderCode() {
    return accountHolderCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
  }

  public AccountHolderStatusChangeNotificationContent invalidFields(
      List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
    return this;
  }

  public AccountHolderStatusChangeNotificationContent addInvalidFieldsItem(
      ErrorFieldType invalidFieldsItem) {
    if (this.invalidFields == null) {
      this.invalidFields = new ArrayList<>();
    }
    this.invalidFields.add(invalidFieldsItem);
    return this;
  }

  /**
   * in case the account holder has not been updated, contains account holder fields, that did not
   * pass the validation.
   *
   * @return invalidFields
   */
  @ApiModelProperty(
      value =
          "in case the account holder has not been updated, contains account holder fields, that did not pass the validation.")
  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ErrorFieldType> getInvalidFields() {
    return invalidFields;
  }

  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
  }

  public AccountHolderStatusChangeNotificationContent newStatus(AccountHolderStatus newStatus) {
    this.newStatus = newStatus;
    return this;
  }

  /**
   * Get newStatus
   *
   * @return newStatus
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NEW_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AccountHolderStatus getNewStatus() {
    return newStatus;
  }

  @JsonProperty(JSON_PROPERTY_NEW_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNewStatus(AccountHolderStatus newStatus) {
    this.newStatus = newStatus;
  }

  public AccountHolderStatusChangeNotificationContent oldStatus(AccountHolderStatus oldStatus) {
    this.oldStatus = oldStatus;
    return this;
  }

  /**
   * Get oldStatus
   *
   * @return oldStatus
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OLD_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AccountHolderStatus getOldStatus() {
    return oldStatus;
  }

  @JsonProperty(JSON_PROPERTY_OLD_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOldStatus(AccountHolderStatus oldStatus) {
    this.oldStatus = oldStatus;
  }

  public AccountHolderStatusChangeNotificationContent reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The reason for the status change.
   *
   * @return reason
   */
  @ApiModelProperty(value = "The reason for the status change.")
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReason() {
    return reason;
  }

  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReason(String reason) {
    this.reason = reason;
  }

  /** Return true if this AccountHolderStatusChangeNotificationContent object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountHolderStatusChangeNotificationContent accountHolderStatusChangeNotificationContent =
        (AccountHolderStatusChangeNotificationContent) o;
    return Objects.equals(
            this.accountHolderCode, accountHolderStatusChangeNotificationContent.accountHolderCode)
        && Objects.equals(
            this.invalidFields, accountHolderStatusChangeNotificationContent.invalidFields)
        && Objects.equals(this.newStatus, accountHolderStatusChangeNotificationContent.newStatus)
        && Objects.equals(this.oldStatus, accountHolderStatusChangeNotificationContent.oldStatus)
        && Objects.equals(this.reason, accountHolderStatusChangeNotificationContent.reason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolderCode, invalidFields, newStatus, oldStatus, reason);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountHolderStatusChangeNotificationContent {\n");
    sb.append("    accountHolderCode: ").append(toIndentedString(accountHolderCode)).append("\n");
    sb.append("    invalidFields: ").append(toIndentedString(invalidFields)).append("\n");
    sb.append("    newStatus: ").append(toIndentedString(newStatus)).append("\n");
    sb.append("    oldStatus: ").append(toIndentedString(oldStatus)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of AccountHolderStatusChangeNotificationContent given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AccountHolderStatusChangeNotificationContent
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     AccountHolderStatusChangeNotificationContent
   */
  public static AccountHolderStatusChangeNotificationContent fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper()
        .readValue(jsonString, AccountHolderStatusChangeNotificationContent.class);
  }

  /**
   * Convert an instance of AccountHolderStatusChangeNotificationContent to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
