/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** BusinessDetails */
@JsonPropertyOrder({
  BusinessDetails.JSON_PROPERTY_DOING_BUSINESS_AS,
  BusinessDetails.JSON_PROPERTY_LEGAL_BUSINESS_NAME,
  BusinessDetails.JSON_PROPERTY_LISTED_ULTIMATE_PARENT_COMPANY,
  BusinessDetails.JSON_PROPERTY_REGISTRATION_NUMBER,
  BusinessDetails.JSON_PROPERTY_SHAREHOLDERS,
  BusinessDetails.JSON_PROPERTY_SIGNATORIES,
  BusinessDetails.JSON_PROPERTY_STOCK_EXCHANGE,
  BusinessDetails.JSON_PROPERTY_STOCK_NUMBER,
  BusinessDetails.JSON_PROPERTY_STOCK_TICKER,
  BusinessDetails.JSON_PROPERTY_TAX_ID
})
public class BusinessDetails {
  public static final String JSON_PROPERTY_DOING_BUSINESS_AS = "doingBusinessAs";
  private String doingBusinessAs;

  public static final String JSON_PROPERTY_LEGAL_BUSINESS_NAME = "legalBusinessName";
  private String legalBusinessName;

  public static final String JSON_PROPERTY_LISTED_ULTIMATE_PARENT_COMPANY =
      "listedUltimateParentCompany";
  private List<UltimateParentCompany> listedUltimateParentCompany = null;

  public static final String JSON_PROPERTY_REGISTRATION_NUMBER = "registrationNumber";
  private String registrationNumber;

  public static final String JSON_PROPERTY_SHAREHOLDERS = "shareholders";
  private List<ShareholderContact> shareholders = null;

  public static final String JSON_PROPERTY_SIGNATORIES = "signatories";
  private List<SignatoryContact> signatories = null;

  public static final String JSON_PROPERTY_STOCK_EXCHANGE = "stockExchange";
  private String stockExchange;

  public static final String JSON_PROPERTY_STOCK_NUMBER = "stockNumber";
  private String stockNumber;

  public static final String JSON_PROPERTY_STOCK_TICKER = "stockTicker";
  private String stockTicker;

  public static final String JSON_PROPERTY_TAX_ID = "taxId";
  private String taxId;

  public BusinessDetails() {}

  public BusinessDetails doingBusinessAs(String doingBusinessAs) {
    this.doingBusinessAs = doingBusinessAs;
    return this;
  }

  /**
   * The registered name of the company (if it differs from the legal name of the company).
   *
   * @return doingBusinessAs
   */
  @ApiModelProperty(
      value =
          "The registered name of the company (if it differs from the legal name of the company).")
  @JsonProperty(JSON_PROPERTY_DOING_BUSINESS_AS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDoingBusinessAs() {
    return doingBusinessAs;
  }

  @JsonProperty(JSON_PROPERTY_DOING_BUSINESS_AS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDoingBusinessAs(String doingBusinessAs) {
    this.doingBusinessAs = doingBusinessAs;
  }

  public BusinessDetails legalBusinessName(String legalBusinessName) {
    this.legalBusinessName = legalBusinessName;
    return this;
  }

  /**
   * The legal name of the company.
   *
   * @return legalBusinessName
   */
  @ApiModelProperty(value = "The legal name of the company.")
  @JsonProperty(JSON_PROPERTY_LEGAL_BUSINESS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalBusinessName() {
    return legalBusinessName;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_BUSINESS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalBusinessName(String legalBusinessName) {
    this.legalBusinessName = legalBusinessName;
  }

  public BusinessDetails listedUltimateParentCompany(
      List<UltimateParentCompany> listedUltimateParentCompany) {
    this.listedUltimateParentCompany = listedUltimateParentCompany;
    return this;
  }

  public BusinessDetails addListedUltimateParentCompanyItem(
      UltimateParentCompany listedUltimateParentCompanyItem) {
    if (this.listedUltimateParentCompany == null) {
      this.listedUltimateParentCompany = new ArrayList<>();
    }
    this.listedUltimateParentCompany.add(listedUltimateParentCompanyItem);
    return this;
  }

  /**
   * Information about the parent public company. Required if the account holder is 100% owned by a
   * publicly listed company.
   *
   * @return listedUltimateParentCompany
   */
  @ApiModelProperty(
      value =
          "Information about the parent public company. Required if the account holder is 100% owned by a publicly listed company.")
  @JsonProperty(JSON_PROPERTY_LISTED_ULTIMATE_PARENT_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<UltimateParentCompany> getListedUltimateParentCompany() {
    return listedUltimateParentCompany;
  }

  @JsonProperty(JSON_PROPERTY_LISTED_ULTIMATE_PARENT_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setListedUltimateParentCompany(
      List<UltimateParentCompany> listedUltimateParentCompany) {
    this.listedUltimateParentCompany = listedUltimateParentCompany;
  }

  public BusinessDetails registrationNumber(String registrationNumber) {
    this.registrationNumber = registrationNumber;
    return this;
  }

  /**
   * The registration number of the company.
   *
   * @return registrationNumber
   */
  @ApiModelProperty(value = "The registration number of the company.")
  @JsonProperty(JSON_PROPERTY_REGISTRATION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRegistrationNumber() {
    return registrationNumber;
  }

  @JsonProperty(JSON_PROPERTY_REGISTRATION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRegistrationNumber(String registrationNumber) {
    this.registrationNumber = registrationNumber;
  }

  public BusinessDetails shareholders(List<ShareholderContact> shareholders) {
    this.shareholders = shareholders;
    return this;
  }

  public BusinessDetails addShareholdersItem(ShareholderContact shareholdersItem) {
    if (this.shareholders == null) {
      this.shareholders = new ArrayList<>();
    }
    this.shareholders.add(shareholdersItem);
    return this;
  }

  /**
   * Array containing information about individuals associated with the account holder either
   * through ownership or control. For details about how you can identify them, refer to [our
   * verification
   * guide](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process#identify-ubos).
   *
   * @return shareholders
   */
  @ApiModelProperty(
      value =
          "Array containing information about individuals associated with the account holder either through ownership or control. For details about how you can identify them, refer to [our verification guide](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process#identify-ubos).")
  @JsonProperty(JSON_PROPERTY_SHAREHOLDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ShareholderContact> getShareholders() {
    return shareholders;
  }

  @JsonProperty(JSON_PROPERTY_SHAREHOLDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShareholders(List<ShareholderContact> shareholders) {
    this.shareholders = shareholders;
  }

  public BusinessDetails signatories(List<SignatoryContact> signatories) {
    this.signatories = signatories;
    return this;
  }

  public BusinessDetails addSignatoriesItem(SignatoryContact signatoriesItem) {
    if (this.signatories == null) {
      this.signatories = new ArrayList<>();
    }
    this.signatories.add(signatoriesItem);
    return this;
  }

  /**
   * Signatories associated with the company. Each array entry should represent one signatory.
   *
   * @return signatories
   */
  @ApiModelProperty(
      value =
          "Signatories associated with the company. Each array entry should represent one signatory.")
  @JsonProperty(JSON_PROPERTY_SIGNATORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<SignatoryContact> getSignatories() {
    return signatories;
  }

  @JsonProperty(JSON_PROPERTY_SIGNATORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignatories(List<SignatoryContact> signatories) {
    this.signatories = signatories;
  }

  public BusinessDetails stockExchange(String stockExchange) {
    this.stockExchange = stockExchange;
    return this;
  }

  /**
   * Market Identifier Code (MIC).
   *
   * @return stockExchange
   */
  @ApiModelProperty(value = "Market Identifier Code (MIC).")
  @JsonProperty(JSON_PROPERTY_STOCK_EXCHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStockExchange() {
    return stockExchange;
  }

  @JsonProperty(JSON_PROPERTY_STOCK_EXCHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStockExchange(String stockExchange) {
    this.stockExchange = stockExchange;
  }

  public BusinessDetails stockNumber(String stockNumber) {
    this.stockNumber = stockNumber;
    return this;
  }

  /**
   * International Securities Identification Number (ISIN).
   *
   * @return stockNumber
   */
  @ApiModelProperty(value = "International Securities Identification Number (ISIN).")
  @JsonProperty(JSON_PROPERTY_STOCK_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStockNumber() {
    return stockNumber;
  }

  @JsonProperty(JSON_PROPERTY_STOCK_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStockNumber(String stockNumber) {
    this.stockNumber = stockNumber;
  }

  public BusinessDetails stockTicker(String stockTicker) {
    this.stockTicker = stockTicker;
    return this;
  }

  /**
   * Stock Ticker symbol.
   *
   * @return stockTicker
   */
  @ApiModelProperty(value = "Stock Ticker symbol.")
  @JsonProperty(JSON_PROPERTY_STOCK_TICKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStockTicker() {
    return stockTicker;
  }

  @JsonProperty(JSON_PROPERTY_STOCK_TICKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStockTicker(String stockTicker) {
    this.stockTicker = stockTicker;
  }

  public BusinessDetails taxId(String taxId) {
    this.taxId = taxId;
    return this;
  }

  /**
   * The tax ID of the company.
   *
   * @return taxId
   */
  @ApiModelProperty(value = "The tax ID of the company.")
  @JsonProperty(JSON_PROPERTY_TAX_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTaxId() {
    return taxId;
  }

  @JsonProperty(JSON_PROPERTY_TAX_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxId(String taxId) {
    this.taxId = taxId;
  }

  /** Return true if this BusinessDetails object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BusinessDetails businessDetails = (BusinessDetails) o;
    return Objects.equals(this.doingBusinessAs, businessDetails.doingBusinessAs)
        && Objects.equals(this.legalBusinessName, businessDetails.legalBusinessName)
        && Objects.equals(
            this.listedUltimateParentCompany, businessDetails.listedUltimateParentCompany)
        && Objects.equals(this.registrationNumber, businessDetails.registrationNumber)
        && Objects.equals(this.shareholders, businessDetails.shareholders)
        && Objects.equals(this.signatories, businessDetails.signatories)
        && Objects.equals(this.stockExchange, businessDetails.stockExchange)
        && Objects.equals(this.stockNumber, businessDetails.stockNumber)
        && Objects.equals(this.stockTicker, businessDetails.stockTicker)
        && Objects.equals(this.taxId, businessDetails.taxId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        doingBusinessAs,
        legalBusinessName,
        listedUltimateParentCompany,
        registrationNumber,
        shareholders,
        signatories,
        stockExchange,
        stockNumber,
        stockTicker,
        taxId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BusinessDetails {\n");
    sb.append("    doingBusinessAs: ").append(toIndentedString(doingBusinessAs)).append("\n");
    sb.append("    legalBusinessName: ").append(toIndentedString(legalBusinessName)).append("\n");
    sb.append("    listedUltimateParentCompany: ")
        .append(toIndentedString(listedUltimateParentCompany))
        .append("\n");
    sb.append("    registrationNumber: ").append(toIndentedString(registrationNumber)).append("\n");
    sb.append("    shareholders: ").append(toIndentedString(shareholders)).append("\n");
    sb.append("    signatories: ").append(toIndentedString(signatories)).append("\n");
    sb.append("    stockExchange: ").append(toIndentedString(stockExchange)).append("\n");
    sb.append("    stockNumber: ").append(toIndentedString(stockNumber)).append("\n");
    sb.append("    stockTicker: ").append(toIndentedString(stockTicker)).append("\n");
    sb.append("    taxId: ").append(toIndentedString(taxId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of BusinessDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BusinessDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to BusinessDetails
   */
  public static BusinessDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BusinessDetails.class);
  }

  /**
   * Convert an instance of BusinessDetails to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
