/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** KYCLegalArrangementCheckResult */
@JsonPropertyOrder({
  KYCLegalArrangementCheckResult.JSON_PROPERTY_CHECKS,
  KYCLegalArrangementCheckResult.JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE
})
public class KYCLegalArrangementCheckResult {
  public static final String JSON_PROPERTY_CHECKS = "checks";
  private List<KYCCheckStatusData> checks = null;

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE = "legalArrangementCode";
  private String legalArrangementCode;

  public KYCLegalArrangementCheckResult() {}

  public KYCLegalArrangementCheckResult checks(List<KYCCheckStatusData> checks) {
    this.checks = checks;
    return this;
  }

  public KYCLegalArrangementCheckResult addChecksItem(KYCCheckStatusData checksItem) {
    if (this.checks == null) {
      this.checks = new ArrayList<>();
    }
    this.checks.add(checksItem);
    return this;
  }

  /**
   * A list of the checks and their statuses.
   *
   * @return checks
   */
  @ApiModelProperty(value = "A list of the checks and their statuses.")
  @JsonProperty(JSON_PROPERTY_CHECKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<KYCCheckStatusData> getChecks() {
    return checks;
  }

  @JsonProperty(JSON_PROPERTY_CHECKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChecks(List<KYCCheckStatusData> checks) {
    this.checks = checks;
  }

  public KYCLegalArrangementCheckResult legalArrangementCode(String legalArrangementCode) {
    this.legalArrangementCode = legalArrangementCode;
    return this;
  }

  /**
   * The unique ID of the legal arrangement to which the check applies.
   *
   * @return legalArrangementCode
   */
  @ApiModelProperty(value = "The unique ID of the legal arrangement to which the check applies.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalArrangementCode() {
    return legalArrangementCode;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementCode(String legalArrangementCode) {
    this.legalArrangementCode = legalArrangementCode;
  }

  /** Return true if this KYCLegalArrangementCheckResult object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KYCLegalArrangementCheckResult kyCLegalArrangementCheckResult =
        (KYCLegalArrangementCheckResult) o;
    return Objects.equals(this.checks, kyCLegalArrangementCheckResult.checks)
        && Objects.equals(
            this.legalArrangementCode, kyCLegalArrangementCheckResult.legalArrangementCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checks, legalArrangementCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class KYCLegalArrangementCheckResult {\n");
    sb.append("    checks: ").append(toIndentedString(checks)).append("\n");
    sb.append("    legalArrangementCode: ")
        .append(toIndentedString(legalArrangementCode))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of KYCLegalArrangementCheckResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of KYCLegalArrangementCheckResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     KYCLegalArrangementCheckResult
   */
  public static KYCLegalArrangementCheckResult fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, KYCLegalArrangementCheckResult.class);
  }

  /**
   * Convert an instance of KYCLegalArrangementCheckResult to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
