/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** SignatoryContact */
@JsonPropertyOrder({
  SignatoryContact.JSON_PROPERTY_ADDRESS,
  SignatoryContact.JSON_PROPERTY_EMAIL,
  SignatoryContact.JSON_PROPERTY_FULL_PHONE_NUMBER,
  SignatoryContact.JSON_PROPERTY_JOB_TITLE,
  SignatoryContact.JSON_PROPERTY_NAME,
  SignatoryContact.JSON_PROPERTY_PERSONAL_DATA,
  SignatoryContact.JSON_PROPERTY_PHONE_NUMBER,
  SignatoryContact.JSON_PROPERTY_SIGNATORY_CODE,
  SignatoryContact.JSON_PROPERTY_SIGNATORY_REFERENCE,
  SignatoryContact.JSON_PROPERTY_WEB_ADDRESS
})
public class SignatoryContact {
  public static final String JSON_PROPERTY_ADDRESS = "address";
  private ViasAddress address;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_FULL_PHONE_NUMBER = "fullPhoneNumber";
  private String fullPhoneNumber;

  public static final String JSON_PROPERTY_JOB_TITLE = "jobTitle";
  private String jobTitle;

  public static final String JSON_PROPERTY_NAME = "name";
  private ViasName name;

  public static final String JSON_PROPERTY_PERSONAL_DATA = "personalData";
  private ViasPersonalData personalData;

  public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
  private ViasPhoneNumber phoneNumber;

  public static final String JSON_PROPERTY_SIGNATORY_CODE = "signatoryCode";
  private String signatoryCode;

  public static final String JSON_PROPERTY_SIGNATORY_REFERENCE = "signatoryReference";
  private String signatoryReference;

  public static final String JSON_PROPERTY_WEB_ADDRESS = "webAddress";
  private String webAddress;

  public SignatoryContact() {}

  public SignatoryContact address(ViasAddress address) {
    this.address = address;
    return this;
  }

  /**
   * Get address
   *
   * @return address
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ViasAddress getAddress() {
    return address;
  }

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(ViasAddress address) {
    this.address = address;
  }

  public SignatoryContact email(String email) {
    this.email = email;
    return this;
  }

  /**
   * The e-mail address of the person.
   *
   * @return email
   */
  @ApiModelProperty(value = "The e-mail address of the person.")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmail() {
    return email;
  }

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }

  public SignatoryContact fullPhoneNumber(String fullPhoneNumber) {
    this.fullPhoneNumber = fullPhoneNumber;
    return this;
  }

  /**
   * The phone number of the person provided as a single string. It will be handled as a landline
   * phone. Examples: \&quot;0031 6 11 22 33 44\&quot;, \&quot;+316/1122-3344\&quot;, \&quot;(0031)
   * 611223344\&quot;
   *
   * @return fullPhoneNumber
   */
  @ApiModelProperty(
      value =
          "The phone number of the person provided as a single string.  It will be handled as a landline phone. Examples: \"0031 6 11 22 33 44\", \"+316/1122-3344\", \"(0031) 611223344\"")
  @JsonProperty(JSON_PROPERTY_FULL_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFullPhoneNumber() {
    return fullPhoneNumber;
  }

  @JsonProperty(JSON_PROPERTY_FULL_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullPhoneNumber(String fullPhoneNumber) {
    this.fullPhoneNumber = fullPhoneNumber;
  }

  public SignatoryContact jobTitle(String jobTitle) {
    this.jobTitle = jobTitle;
    return this;
  }

  /**
   * Job title of the signatory. Example values: **Chief Executive Officer**, **Chief Financial
   * Officer**, **Chief Operating Officer**, **President**, **Vice President**, **Executive
   * President**, **Managing Member**, **Partner**, **Treasurer**, **Director**, or **Other**.
   *
   * @return jobTitle
   */
  @ApiModelProperty(
      value =
          "Job title of the signatory.  Example values: **Chief Executive Officer**, **Chief Financial Officer**, **Chief Operating Officer**, **President**, **Vice President**, **Executive President**, **Managing Member**, **Partner**, **Treasurer**, **Director**, or **Other**.")
  @JsonProperty(JSON_PROPERTY_JOB_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getJobTitle() {
    return jobTitle;
  }

  @JsonProperty(JSON_PROPERTY_JOB_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobTitle(String jobTitle) {
    this.jobTitle = jobTitle;
  }

  public SignatoryContact name(ViasName name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   *
   * @return name
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ViasName getName() {
    return name;
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(ViasName name) {
    this.name = name;
  }

  public SignatoryContact personalData(ViasPersonalData personalData) {
    this.personalData = personalData;
    return this;
  }

  /**
   * Get personalData
   *
   * @return personalData
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERSONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ViasPersonalData getPersonalData() {
    return personalData;
  }

  @JsonProperty(JSON_PROPERTY_PERSONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPersonalData(ViasPersonalData personalData) {
    this.personalData = personalData;
  }

  public SignatoryContact phoneNumber(ViasPhoneNumber phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Get phoneNumber
   *
   * @return phoneNumber
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ViasPhoneNumber getPhoneNumber() {
    return phoneNumber;
  }

  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumber(ViasPhoneNumber phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  public SignatoryContact signatoryCode(String signatoryCode) {
    this.signatoryCode = signatoryCode;
    return this;
  }

  /**
   * The unique identifier (UUID) of the signatory. &gt;**If, during an Account Holder create or
   * update request, this field is left blank (but other fields provided), a new Signatory will be
   * created with a procedurally-generated UUID.** &gt;**If, during an Account Holder create
   * request, a UUID is provided, the creation of the Signatory will fail while the creation of the
   * Account Holder will continue.** &gt;**If, during an Account Holder update request, a UUID that
   * is not correlated with an existing Signatory is provided, the update of the Signatory will
   * fail.** &gt;**If, during an Account Holder update request, a UUID that is correlated with an
   * existing Signatory is provided, the existing Signatory will be updated.**
   *
   * @return signatoryCode
   */
  @ApiModelProperty(
      value =
          "The unique identifier (UUID) of the signatory. >**If, during an Account Holder create or update request, this field is left blank (but other fields provided), a new Signatory will be created with a procedurally-generated UUID.**  >**If, during an Account Holder create request, a UUID is provided, the creation of the Signatory will fail while the creation of the Account Holder will continue.**  >**If, during an Account Holder update request, a UUID that is not correlated with an existing Signatory is provided, the update of the Signatory will fail.**  >**If, during an Account Holder update request, a UUID that is correlated with an existing Signatory is provided, the existing Signatory will be updated.** ")
  @JsonProperty(JSON_PROPERTY_SIGNATORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSignatoryCode() {
    return signatoryCode;
  }

  @JsonProperty(JSON_PROPERTY_SIGNATORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignatoryCode(String signatoryCode) {
    this.signatoryCode = signatoryCode;
  }

  public SignatoryContact signatoryReference(String signatoryReference) {
    this.signatoryReference = signatoryReference;
    return this;
  }

  /**
   * Your reference for the signatory.
   *
   * @return signatoryReference
   */
  @ApiModelProperty(value = "Your reference for the signatory.")
  @JsonProperty(JSON_PROPERTY_SIGNATORY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSignatoryReference() {
    return signatoryReference;
  }

  @JsonProperty(JSON_PROPERTY_SIGNATORY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignatoryReference(String signatoryReference) {
    this.signatoryReference = signatoryReference;
  }

  public SignatoryContact webAddress(String webAddress) {
    this.webAddress = webAddress;
    return this;
  }

  /**
   * The URL of the person&#39;s website.
   *
   * @return webAddress
   */
  @ApiModelProperty(value = "The URL of the person's website.")
  @JsonProperty(JSON_PROPERTY_WEB_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getWebAddress() {
    return webAddress;
  }

  @JsonProperty(JSON_PROPERTY_WEB_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebAddress(String webAddress) {
    this.webAddress = webAddress;
  }

  /** Return true if this SignatoryContact object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SignatoryContact signatoryContact = (SignatoryContact) o;
    return Objects.equals(this.address, signatoryContact.address)
        && Objects.equals(this.email, signatoryContact.email)
        && Objects.equals(this.fullPhoneNumber, signatoryContact.fullPhoneNumber)
        && Objects.equals(this.jobTitle, signatoryContact.jobTitle)
        && Objects.equals(this.name, signatoryContact.name)
        && Objects.equals(this.personalData, signatoryContact.personalData)
        && Objects.equals(this.phoneNumber, signatoryContact.phoneNumber)
        && Objects.equals(this.signatoryCode, signatoryContact.signatoryCode)
        && Objects.equals(this.signatoryReference, signatoryContact.signatoryReference)
        && Objects.equals(this.webAddress, signatoryContact.webAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        address,
        email,
        fullPhoneNumber,
        jobTitle,
        name,
        personalData,
        phoneNumber,
        signatoryCode,
        signatoryReference,
        webAddress);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SignatoryContact {\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    fullPhoneNumber: ").append(toIndentedString(fullPhoneNumber)).append("\n");
    sb.append("    jobTitle: ").append(toIndentedString(jobTitle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    personalData: ").append(toIndentedString(personalData)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    signatoryCode: ").append(toIndentedString(signatoryCode)).append("\n");
    sb.append("    signatoryReference: ").append(toIndentedString(signatoryReference)).append("\n");
    sb.append("    webAddress: ").append(toIndentedString(webAddress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of SignatoryContact given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SignatoryContact
   * @throws JsonProcessingException if the JSON string is invalid with respect to SignatoryContact
   */
  public static SignatoryContact fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SignatoryContact.class);
  }

  /**
   * Convert an instance of SignatoryContact to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
