/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** TransferFundsNotificationContent */
@JsonPropertyOrder({
  TransferFundsNotificationContent.JSON_PROPERTY_AMOUNT,
  TransferFundsNotificationContent.JSON_PROPERTY_DESTINATION_ACCOUNT_CODE,
  TransferFundsNotificationContent.JSON_PROPERTY_INVALID_FIELDS,
  TransferFundsNotificationContent.JSON_PROPERTY_MERCHANT_REFERENCE,
  TransferFundsNotificationContent.JSON_PROPERTY_SOURCE_ACCOUNT_CODE,
  TransferFundsNotificationContent.JSON_PROPERTY_STATUS,
  TransferFundsNotificationContent.JSON_PROPERTY_TRANSFER_CODE
})
public class TransferFundsNotificationContent {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_CODE = "destinationAccountCode";
  private String destinationAccountCode;

  public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
  private List<ErrorFieldType> invalidFields = null;

  public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
  private String merchantReference;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT_CODE = "sourceAccountCode";
  private String sourceAccountCode;

  public static final String JSON_PROPERTY_STATUS = "status";
  private OperationStatus status;

  public static final String JSON_PROPERTY_TRANSFER_CODE = "transferCode";
  private String transferCode;

  public TransferFundsNotificationContent() {}

  public TransferFundsNotificationContent amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   *
   * @return amount
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  public TransferFundsNotificationContent destinationAccountCode(String destinationAccountCode) {
    this.destinationAccountCode = destinationAccountCode;
    return this;
  }

  /**
   * The code of the Account to which funds were credited.
   *
   * @return destinationAccountCode
   */
  @ApiModelProperty(value = "The code of the Account to which funds were credited.")
  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDestinationAccountCode() {
    return destinationAccountCode;
  }

  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationAccountCode(String destinationAccountCode) {
    this.destinationAccountCode = destinationAccountCode;
  }

  public TransferFundsNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
    return this;
  }

  public TransferFundsNotificationContent addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
    if (this.invalidFields == null) {
      this.invalidFields = new ArrayList<>();
    }
    this.invalidFields.add(invalidFieldsItem);
    return this;
  }

  /**
   * Invalid fields list.
   *
   * @return invalidFields
   */
  @ApiModelProperty(value = "Invalid fields list.")
  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ErrorFieldType> getInvalidFields() {
    return invalidFields;
  }

  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
  }

  public TransferFundsNotificationContent merchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
    return this;
  }

  /**
   * The reference provided by the merchant.
   *
   * @return merchantReference
   */
  @ApiModelProperty(value = "The reference provided by the merchant.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantReference() {
    return merchantReference;
  }

  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }

  public TransferFundsNotificationContent sourceAccountCode(String sourceAccountCode) {
    this.sourceAccountCode = sourceAccountCode;
    return this;
  }

  /**
   * The code of the Account from which funds were debited.
   *
   * @return sourceAccountCode
   */
  @ApiModelProperty(value = "The code of the Account from which funds were debited.")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSourceAccountCode() {
    return sourceAccountCode;
  }

  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAccountCode(String sourceAccountCode) {
    this.sourceAccountCode = sourceAccountCode;
  }

  public TransferFundsNotificationContent status(OperationStatus status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   *
   * @return status
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OperationStatus getStatus() {
    return status;
  }

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(OperationStatus status) {
    this.status = status;
  }

  public TransferFundsNotificationContent transferCode(String transferCode) {
    this.transferCode = transferCode;
    return this;
  }

  /**
   * The transfer code.
   *
   * @return transferCode
   */
  @ApiModelProperty(value = "The transfer code.")
  @JsonProperty(JSON_PROPERTY_TRANSFER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTransferCode() {
    return transferCode;
  }

  @JsonProperty(JSON_PROPERTY_TRANSFER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferCode(String transferCode) {
    this.transferCode = transferCode;
  }

  /** Return true if this TransferFundsNotificationContent object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferFundsNotificationContent transferFundsNotificationContent =
        (TransferFundsNotificationContent) o;
    return Objects.equals(this.amount, transferFundsNotificationContent.amount)
        && Objects.equals(
            this.destinationAccountCode, transferFundsNotificationContent.destinationAccountCode)
        && Objects.equals(this.invalidFields, transferFundsNotificationContent.invalidFields)
        && Objects.equals(
            this.merchantReference, transferFundsNotificationContent.merchantReference)
        && Objects.equals(
            this.sourceAccountCode, transferFundsNotificationContent.sourceAccountCode)
        && Objects.equals(this.status, transferFundsNotificationContent.status)
        && Objects.equals(this.transferCode, transferFundsNotificationContent.transferCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        amount,
        destinationAccountCode,
        invalidFields,
        merchantReference,
        sourceAccountCode,
        status,
        transferCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferFundsNotificationContent {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    destinationAccountCode: ")
        .append(toIndentedString(destinationAccountCode))
        .append("\n");
    sb.append("    invalidFields: ").append(toIndentedString(invalidFields)).append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    sourceAccountCode: ").append(toIndentedString(sourceAccountCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    transferCode: ").append(toIndentedString(transferCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of TransferFundsNotificationContent given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransferFundsNotificationContent
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     TransferFundsNotificationContent
   */
  public static TransferFundsNotificationContent fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TransferFundsNotificationContent.class);
  }

  /**
   * Convert an instance of TransferFundsNotificationContent to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
