/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** UpdateAccountHolderResponse */
@JsonPropertyOrder({
  UpdateAccountHolderResponse.JSON_PROPERTY_ACCOUNT_HOLDER_CODE,
  UpdateAccountHolderResponse.JSON_PROPERTY_ACCOUNT_HOLDER_DETAILS,
  UpdateAccountHolderResponse.JSON_PROPERTY_ACCOUNT_HOLDER_STATUS,
  UpdateAccountHolderResponse.JSON_PROPERTY_DESCRIPTION,
  UpdateAccountHolderResponse.JSON_PROPERTY_INVALID_FIELDS,
  UpdateAccountHolderResponse.JSON_PROPERTY_LEGAL_ENTITY,
  UpdateAccountHolderResponse.JSON_PROPERTY_PRIMARY_CURRENCY,
  UpdateAccountHolderResponse.JSON_PROPERTY_PSP_REFERENCE,
  UpdateAccountHolderResponse.JSON_PROPERTY_RESULT_CODE,
  UpdateAccountHolderResponse.JSON_PROPERTY_VERIFICATION,
  UpdateAccountHolderResponse.JSON_PROPERTY_VERIFICATION_PROFILE
})
public class UpdateAccountHolderResponse {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
  private String accountHolderCode;

  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_DETAILS = "accountHolderDetails";
  private AccountHolderDetails accountHolderDetails;

  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_STATUS = "accountHolderStatus";
  private AccountHolderStatus accountHolderStatus;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
  private List<ErrorFieldType> invalidFields = null;

  /** The legal entity of the account holder. */
  public enum LegalEntityEnum {
    BUSINESS("Business"),

    INDIVIDUAL("Individual"),

    NONPROFIT("NonProfit"),

    PARTNERSHIP("Partnership"),

    PUBLICCOMPANY("PublicCompany");

    private String value;

    LegalEntityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LegalEntityEnum fromValue(String value) {
      for (LegalEntityEnum b : LegalEntityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LEGAL_ENTITY = "legalEntity";
  private LegalEntityEnum legalEntity;

  public static final String JSON_PROPERTY_PRIMARY_CURRENCY = "primaryCurrency";
  private String primaryCurrency;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
  private String resultCode;

  public static final String JSON_PROPERTY_VERIFICATION = "verification";
  private KYCVerificationResult verification;

  public static final String JSON_PROPERTY_VERIFICATION_PROFILE = "verificationProfile";
  private String verificationProfile;

  public UpdateAccountHolderResponse() {}

  public UpdateAccountHolderResponse accountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
    return this;
  }

  /**
   * The code of the account holder.
   *
   * @return accountHolderCode
   */
  @ApiModelProperty(value = "The code of the account holder.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountHolderCode() {
    return accountHolderCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
  }

  public UpdateAccountHolderResponse accountHolderDetails(
      AccountHolderDetails accountHolderDetails) {
    this.accountHolderDetails = accountHolderDetails;
    return this;
  }

  /**
   * Get accountHolderDetails
   *
   * @return accountHolderDetails
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AccountHolderDetails getAccountHolderDetails() {
    return accountHolderDetails;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderDetails(AccountHolderDetails accountHolderDetails) {
    this.accountHolderDetails = accountHolderDetails;
  }

  public UpdateAccountHolderResponse accountHolderStatus(AccountHolderStatus accountHolderStatus) {
    this.accountHolderStatus = accountHolderStatus;
    return this;
  }

  /**
   * Get accountHolderStatus
   *
   * @return accountHolderStatus
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AccountHolderStatus getAccountHolderStatus() {
    return accountHolderStatus;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderStatus(AccountHolderStatus accountHolderStatus) {
    this.accountHolderStatus = accountHolderStatus;
  }

  public UpdateAccountHolderResponse description(String description) {
    this.description = description;
    return this;
  }

  /**
   * The description of the account holder.
   *
   * @return description
   */
  @ApiModelProperty(value = "The description of the account holder.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  public UpdateAccountHolderResponse invalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
    return this;
  }

  public UpdateAccountHolderResponse addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
    if (this.invalidFields == null) {
      this.invalidFields = new ArrayList<>();
    }
    this.invalidFields.add(invalidFieldsItem);
    return this;
  }

  /**
   * in case the account holder has not been updated, contains account holder fields, that did not
   * pass the validation.
   *
   * @return invalidFields
   */
  @ApiModelProperty(
      value =
          "in case the account holder has not been updated, contains account holder fields, that did not pass the validation.")
  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ErrorFieldType> getInvalidFields() {
    return invalidFields;
  }

  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
  }

  public UpdateAccountHolderResponse legalEntity(LegalEntityEnum legalEntity) {
    this.legalEntity = legalEntity;
    return this;
  }

  /**
   * The legal entity of the account holder.
   *
   * @return legalEntity
   */
  @ApiModelProperty(value = "The legal entity of the account holder.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LegalEntityEnum getLegalEntity() {
    return legalEntity;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalEntity(LegalEntityEnum legalEntity) {
    this.legalEntity = legalEntity;
  }

  public UpdateAccountHolderResponse primaryCurrency(String primaryCurrency) {
    this.primaryCurrency = primaryCurrency;
    return this;
  }

  /**
   * The three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes), with which the prospective
   * account holder primarily deals.
   *
   * @return primaryCurrency
   * @deprecated
   */
  @Deprecated
  @ApiModelProperty(
      value =
          "The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes), with which the prospective account holder primarily deals.")
  @JsonProperty(JSON_PROPERTY_PRIMARY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPrimaryCurrency() {
    return primaryCurrency;
  }

  @Deprecated
  @JsonProperty(JSON_PROPERTY_PRIMARY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrimaryCurrency(String primaryCurrency) {
    this.primaryCurrency = primaryCurrency;
  }

  public UpdateAccountHolderResponse pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

  /**
   * The reference of a request. Can be used to uniquely identify the request.
   *
   * @return pspReference
   */
  @ApiModelProperty(
      value = "The reference of a request. Can be used to uniquely identify the request.")
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPspReference() {
    return pspReference;
  }

  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }

  public UpdateAccountHolderResponse resultCode(String resultCode) {
    this.resultCode = resultCode;
    return this;
  }

  /**
   * The result code.
   *
   * @return resultCode
   */
  @ApiModelProperty(value = "The result code.")
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getResultCode() {
    return resultCode;
  }

  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResultCode(String resultCode) {
    this.resultCode = resultCode;
  }

  public UpdateAccountHolderResponse verification(KYCVerificationResult verification) {
    this.verification = verification;
    return this;
  }

  /**
   * Get verification
   *
   * @return verification
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VERIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public KYCVerificationResult getVerification() {
    return verification;
  }

  @JsonProperty(JSON_PROPERTY_VERIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerification(KYCVerificationResult verification) {
    this.verification = verification;
  }

  public UpdateAccountHolderResponse verificationProfile(String verificationProfile) {
    this.verificationProfile = verificationProfile;
    return this;
  }

  /**
   * The identifier of the profile that applies to this entity.
   *
   * @return verificationProfile
   */
  @ApiModelProperty(value = "The identifier of the profile that applies to this entity.")
  @JsonProperty(JSON_PROPERTY_VERIFICATION_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getVerificationProfile() {
    return verificationProfile;
  }

  @JsonProperty(JSON_PROPERTY_VERIFICATION_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerificationProfile(String verificationProfile) {
    this.verificationProfile = verificationProfile;
  }

  /** Return true if this UpdateAccountHolderResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateAccountHolderResponse updateAccountHolderResponse = (UpdateAccountHolderResponse) o;
    return Objects.equals(this.accountHolderCode, updateAccountHolderResponse.accountHolderCode)
        && Objects.equals(
            this.accountHolderDetails, updateAccountHolderResponse.accountHolderDetails)
        && Objects.equals(this.accountHolderStatus, updateAccountHolderResponse.accountHolderStatus)
        && Objects.equals(this.description, updateAccountHolderResponse.description)
        && Objects.equals(this.invalidFields, updateAccountHolderResponse.invalidFields)
        && Objects.equals(this.legalEntity, updateAccountHolderResponse.legalEntity)
        && Objects.equals(this.primaryCurrency, updateAccountHolderResponse.primaryCurrency)
        && Objects.equals(this.pspReference, updateAccountHolderResponse.pspReference)
        && Objects.equals(this.resultCode, updateAccountHolderResponse.resultCode)
        && Objects.equals(this.verification, updateAccountHolderResponse.verification)
        && Objects.equals(
            this.verificationProfile, updateAccountHolderResponse.verificationProfile);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountHolderCode,
        accountHolderDetails,
        accountHolderStatus,
        description,
        invalidFields,
        legalEntity,
        primaryCurrency,
        pspReference,
        resultCode,
        verification,
        verificationProfile);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateAccountHolderResponse {\n");
    sb.append("    accountHolderCode: ").append(toIndentedString(accountHolderCode)).append("\n");
    sb.append("    accountHolderDetails: ")
        .append(toIndentedString(accountHolderDetails))
        .append("\n");
    sb.append("    accountHolderStatus: ")
        .append(toIndentedString(accountHolderStatus))
        .append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    invalidFields: ").append(toIndentedString(invalidFields)).append("\n");
    sb.append("    legalEntity: ").append(toIndentedString(legalEntity)).append("\n");
    sb.append("    primaryCurrency: ").append(toIndentedString(primaryCurrency)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("    verification: ").append(toIndentedString(verification)).append("\n");
    sb.append("    verificationProfile: ")
        .append(toIndentedString(verificationProfile))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of UpdateAccountHolderResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of UpdateAccountHolderResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     UpdateAccountHolderResponse
   */
  public static UpdateAccountHolderResponse fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, UpdateAccountHolderResponse.class);
  }

  /**
   * Convert an instance of UpdateAccountHolderResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
