/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/** ModificationResult */
@JsonPropertyOrder({
  ModificationResult.JSON_PROPERTY_ADDITIONAL_DATA,
  ModificationResult.JSON_PROPERTY_PSP_REFERENCE,
  ModificationResult.JSON_PROPERTY_RESPONSE
})
public class ModificationResult {
  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  /** Indicates if the modification request has been received for processing. */
  public enum ResponseEnum {
    _CAPTURE_RECEIVED_(String.valueOf("[capture-received]")),

    _CANCEL_RECEIVED_(String.valueOf("[cancel-received]")),

    _REFUND_RECEIVED_(String.valueOf("[refund-received]")),

    _CANCELORREFUND_RECEIVED_(String.valueOf("[cancelOrRefund-received]")),

    _ADJUSTAUTHORISATION_RECEIVED_(String.valueOf("[adjustAuthorisation-received]")),

    _DONATION_RECEIVED_(String.valueOf("[donation-received]")),

    _TECHNICAL_CANCEL_RECEIVED_(String.valueOf("[technical-cancel-received]")),

    _VOIDPENDINGREFUND_RECEIVED_(String.valueOf("[voidPendingRefund-received]")),

    AUTHORISED(String.valueOf("Authorised"));

    private String value;

    ResponseEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ResponseEnum fromValue(String value) {
      for (ResponseEnum b : ResponseEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RESPONSE = "response";
  private ResponseEnum response;

  public ModificationResult() {}

  /**
   * This field contains additional data, which may be returned in a particular modification
   * response.
   *
   * @param additionalData This field contains additional data, which may be returned in a
   *     particular modification response.
   * @return the current {@code ModificationResult} instance, allowing for method chaining
   */
  public ModificationResult additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public ModificationResult putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

  /**
   * This field contains additional data, which may be returned in a particular modification
   * response.
   *
   * @return additionalData This field contains additional data, which may be returned in a
   *     particular modification response.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getAdditionalData() {
    return additionalData;
  }

  /**
   * This field contains additional data, which may be returned in a particular modification
   * response.
   *
   * @param additionalData This field contains additional data, which may be returned in a
   *     particular modification response.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }

  /**
   * Adyen&#39;s 16-character string reference associated with the transaction/request. This value
   * is globally unique; quote it when communicating with us about this request.
   *
   * @param pspReference Adyen&#39;s 16-character string reference associated with the
   *     transaction/request. This value is globally unique; quote it when communicating with us
   *     about this request.
   * @return the current {@code ModificationResult} instance, allowing for method chaining
   */
  public ModificationResult pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

  /**
   * Adyen&#39;s 16-character string reference associated with the transaction/request. This value
   * is globally unique; quote it when communicating with us about this request.
   *
   * @return pspReference Adyen&#39;s 16-character string reference associated with the
   *     transaction/request. This value is globally unique; quote it when communicating with us
   *     about this request.
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPspReference() {
    return pspReference;
  }

  /**
   * Adyen&#39;s 16-character string reference associated with the transaction/request. This value
   * is globally unique; quote it when communicating with us about this request.
   *
   * @param pspReference Adyen&#39;s 16-character string reference associated with the
   *     transaction/request. This value is globally unique; quote it when communicating with us
   *     about this request.
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }

  /**
   * Indicates if the modification request has been received for processing.
   *
   * @param response Indicates if the modification request has been received for processing.
   * @return the current {@code ModificationResult} instance, allowing for method chaining
   */
  public ModificationResult response(ResponseEnum response) {
    this.response = response;
    return this;
  }

  /**
   * Indicates if the modification request has been received for processing.
   *
   * @return response Indicates if the modification request has been received for processing.
   */
  @JsonProperty(JSON_PROPERTY_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResponseEnum getResponse() {
    return response;
  }

  /**
   * Indicates if the modification request has been received for processing.
   *
   * @param response Indicates if the modification request has been received for processing.
   */
  @JsonProperty(JSON_PROPERTY_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponse(ResponseEnum response) {
    this.response = response;
  }

  /** Return true if this ModificationResult object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModificationResult modificationResult = (ModificationResult) o;
    return Objects.equals(this.additionalData, modificationResult.additionalData)
        && Objects.equals(this.pspReference, modificationResult.pspReference)
        && Objects.equals(this.response, modificationResult.response);
  }

  @Override
  public int hashCode() {
    return Objects.hash(additionalData, pspReference, response);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModificationResult {\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    response: ").append(toIndentedString(response)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ModificationResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ModificationResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     ModificationResult
   */
  public static ModificationResult fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ModificationResult.class);
  }

  /**
   * Convert an instance of ModificationResult to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
