/*
 * Session authentication API
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.sessionauthentication;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/** Resource */
@JsonPropertyOrder({Resource.JSON_PROPERTY_TYPE})
@JsonIgnoreProperties(
    value =
        "type", // ignore manually set type, it will be automatically generated by Jackson during
    // serialization
    allowSetters = true // allows the type to be set during deserialization
    )
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "type",
    visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = AccountHolderResource.class, name = "accountHolder"),
  @JsonSubTypes.Type(value = BalanceAccountResource.class, name = "balanceAccount"),
  @JsonSubTypes.Type(value = LegalEntityResource.class, name = "legalEntity"),
  @JsonSubTypes.Type(value = MerchantAccountResource.class, name = "merchantAccount"),
  @JsonSubTypes.Type(value = PaymentInstrumentResource.class, name = "paymentInstrument"),
})
public class Resource {
  public static final String JSON_PROPERTY_TYPE = "type";
  private ResourceType type;

  public Resource() {}

  /**
   * type
   *
   * @param type
   * @return the current {@code Resource} instance, allowing for method chaining
   */
  public Resource type(ResourceType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   *
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResourceType getType() {
    return type;
  }

  /**
   * type
   *
   * @param type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(ResourceType type) {
    this.type = type;
  }

  /** Return true if this Resource object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Resource resource = (Resource) o;
    return Objects.equals(this.type, resource.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Resource {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  static {
    // Initialize and register the discriminator mappings.
    Map<String, Class<?>> mappings = new HashMap<>();
    mappings.put("accountHolder", AccountHolderResource.class);
    mappings.put("balanceAccount", BalanceAccountResource.class);
    mappings.put("legalEntity", LegalEntityResource.class);
    mappings.put("merchantAccount", MerchantAccountResource.class);
    mappings.put("paymentInstrument", PaymentInstrumentResource.class);
    mappings.put("Resource", Resource.class);
    JSON.registerDiscriminator(Resource.class, "type", mappings);
  }

  /**
   * Create an instance of Resource given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Resource
   * @throws JsonProcessingException if the JSON string is invalid with respect to Resource
   */
  public static Resource fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Resource.class);
  }

  /**
   * Convert an instance of Resource to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
