/*
 * Adyen Balance Control API
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.balancecontrol;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balancecontrol.BalanceTransferRequest;
import com.adyen.model.balancecontrol.BalanceTransferResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class BalanceControlApi extends Service {

  public static final String API_VERSION = "1";

  protected String baseURL;

  /**
   * BalanceControl constructor in {@link com.adyen.service.balancecontrol package}.
   *
   * @param client {@link Client } (required)
   */
  public BalanceControlApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://pal-test.adyen.com/pal/servlet/BalanceControl/v1");
  }

  /**
   * BalanceControl constructor in {@link com.adyen.service.balancecontrol package}. Please use this
   * constructor only if you would like to pass along your own url for routing or testing purposes.
   * The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public BalanceControlApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Start a balance transfer
   *
   * @param balanceTransferRequest {@link BalanceTransferRequest } (required)
   * @return {@link BalanceTransferResponse }
   * @throws ApiException if fails to make API call
   * @deprecated since Adyen Balance Control API v1
   */
  @Deprecated
  public BalanceTransferResponse balanceTransfer(BalanceTransferRequest balanceTransferRequest)
      throws ApiException, IOException {
    return balanceTransfer(balanceTransferRequest, null);
  }

  /**
   * Start a balance transfer
   *
   * @param balanceTransferRequest {@link BalanceTransferRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link BalanceTransferResponse }
   * @throws ApiException if fails to make API call
   * @deprecated since Adyen Balance Control API v1
   */
  @Deprecated
  public BalanceTransferResponse balanceTransfer(
      BalanceTransferRequest balanceTransferRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = balanceTransferRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/balanceTransfer", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return BalanceTransferResponse.fromJson(jsonResult);
  }
}
