/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.legalentitymanagement;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.legalentitymanagement.AcceptTermsOfServiceRequest;
import com.adyen.model.legalentitymanagement.AcceptTermsOfServiceResponse;
import com.adyen.model.legalentitymanagement.CalculateTermsOfServiceStatusResponse;
import com.adyen.model.legalentitymanagement.GetAcceptedTermsOfServiceDocumentResponse;
import com.adyen.model.legalentitymanagement.GetTermsOfServiceAcceptanceInfosResponse;
import com.adyen.model.legalentitymanagement.GetTermsOfServiceDocumentRequest;
import com.adyen.model.legalentitymanagement.GetTermsOfServiceDocumentResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TermsOfServiceApi extends Service {

  public static final String API_VERSION = "3";

  protected String baseURL;

  /**
   * Terms of Service constructor in {@link com.adyen.service.legalentitymanagement package}.
   *
   * @param client {@link Client } (required)
   */
  public TermsOfServiceApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://kyc-test.adyen.com/lem/v3");
  }

  /**
   * Terms of Service constructor in {@link com.adyen.service.legalentitymanagement package}. Please
   * use this constructor only if you would like to pass along your own url for routing or testing
   * purposes. The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public TermsOfServiceApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Accept Terms of Service
   *
   * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships,
   *     this is the individual legal entity ID of the owner. For organizations, this is the ID of
   *     the organization. For legal representatives of individuals, this is the ID of the
   *     individual. (required)
   * @param termsofservicedocumentid {@link String } The unique identifier of the Terms of Service
   *     document. (required)
   * @param acceptTermsOfServiceRequest {@link AcceptTermsOfServiceRequest } (required)
   * @return {@link AcceptTermsOfServiceResponse }
   * @throws ApiException if fails to make API call
   */
  public AcceptTermsOfServiceResponse acceptTermsOfService(
      String id,
      String termsofservicedocumentid,
      AcceptTermsOfServiceRequest acceptTermsOfServiceRequest)
      throws ApiException, IOException {
    return acceptTermsOfService(id, termsofservicedocumentid, acceptTermsOfServiceRequest, null);
  }

  /**
   * Accept Terms of Service
   *
   * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships,
   *     this is the individual legal entity ID of the owner. For organizations, this is the ID of
   *     the organization. For legal representatives of individuals, this is the ID of the
   *     individual. (required)
   * @param termsofservicedocumentid {@link String } The unique identifier of the Terms of Service
   *     document. (required)
   * @param acceptTermsOfServiceRequest {@link AcceptTermsOfServiceRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link AcceptTermsOfServiceResponse }
   * @throws ApiException if fails to make API call
   */
  public AcceptTermsOfServiceResponse acceptTermsOfService(
      String id,
      String termsofservicedocumentid,
      AcceptTermsOfServiceRequest acceptTermsOfServiceRequest,
      RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (id == null) {
      throw new IllegalArgumentException("Please provide the id path parameter");
    }
    pathParams.put("id", id);
    if (termsofservicedocumentid == null) {
      throw new IllegalArgumentException(
          "Please provide the termsofservicedocumentid path parameter");
    }
    pathParams.put("termsofservicedocumentid", termsofservicedocumentid);

    String requestBody = acceptTermsOfServiceRequest.toJson();
    Resource resource =
        new Resource(
            this,
            this.baseURL + "/legalEntities/{id}/termsOfService/{termsofservicedocumentid}",
            null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
    return AcceptTermsOfServiceResponse.fromJson(jsonResult);
  }

  /**
   * Get accepted Terms of Service document
   *
   * @param id {@link String } The unique identifier of the legal entity. For sole proprietorship,
   *     this is the individual legal entity ID of the owner. For organizations, this is the ID of
   *     the organization. (required)
   * @param termsofserviceacceptancereference {@link String } An Adyen-generated reference for the
   *     accepted Terms of Service. (required)
   * @return {@link GetAcceptedTermsOfServiceDocumentResponse }
   * @throws ApiException if fails to make API call
   */
  public GetAcceptedTermsOfServiceDocumentResponse getAcceptedTermsOfServiceDocument(
      String id, String termsofserviceacceptancereference) throws ApiException, IOException {
    return getAcceptedTermsOfServiceDocument(id, termsofserviceacceptancereference, null, null);
  }

  /**
   * Get accepted Terms of Service document
   *
   * @param id {@link String } The unique identifier of the legal entity. For sole proprietorship,
   *     this is the individual legal entity ID of the owner. For organizations, this is the ID of
   *     the organization. (required)
   * @param termsofserviceacceptancereference {@link String } An Adyen-generated reference for the
   *     accepted Terms of Service. (required)
   * @param termsOfServiceDocumentFormat {@link String } Query: The format of the Terms of Service
   *     document. Possible values: **JSON**, **PDF**, or **TXT** (optional)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link GetAcceptedTermsOfServiceDocumentResponse }
   * @throws ApiException if fails to make API call
   */
  public GetAcceptedTermsOfServiceDocumentResponse getAcceptedTermsOfServiceDocument(
      String id,
      String termsofserviceacceptancereference,
      String termsOfServiceDocumentFormat,
      RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (id == null) {
      throw new IllegalArgumentException("Please provide the id path parameter");
    }
    pathParams.put("id", id);
    if (termsofserviceacceptancereference == null) {
      throw new IllegalArgumentException(
          "Please provide the termsofserviceacceptancereference path parameter");
    }
    pathParams.put("termsofserviceacceptancereference", termsofserviceacceptancereference);

    // Add query params
    Map<String, String> queryParams = new HashMap<>();
    if (termsOfServiceDocumentFormat != null) {
      queryParams.put("termsOfServiceDocumentFormat", termsOfServiceDocumentFormat);
    }

    String requestBody = null;
    Resource resource =
        new Resource(
            this,
            this.baseURL
                + "/legalEntities/{id}/acceptedTermsOfServiceDocument/{termsofserviceacceptancereference}",
            null);
    String jsonResult =
        resource.request(
            requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
    return GetAcceptedTermsOfServiceDocumentResponse.fromJson(jsonResult);
  }

  /**
   * Get Terms of Service document
   *
   * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships,
   *     this is the individual legal entity ID of the owner. For organizations, this is the ID of
   *     the organization. (required)
   * @param getTermsOfServiceDocumentRequest {@link GetTermsOfServiceDocumentRequest } (required)
   * @return {@link GetTermsOfServiceDocumentResponse }
   * @throws ApiException if fails to make API call
   */
  public GetTermsOfServiceDocumentResponse getTermsOfServiceDocument(
      String id, GetTermsOfServiceDocumentRequest getTermsOfServiceDocumentRequest)
      throws ApiException, IOException {
    return getTermsOfServiceDocument(id, getTermsOfServiceDocumentRequest, null);
  }

  /**
   * Get Terms of Service document
   *
   * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships,
   *     this is the individual legal entity ID of the owner. For organizations, this is the ID of
   *     the organization. (required)
   * @param getTermsOfServiceDocumentRequest {@link GetTermsOfServiceDocumentRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link GetTermsOfServiceDocumentResponse }
   * @throws ApiException if fails to make API call
   */
  public GetTermsOfServiceDocumentResponse getTermsOfServiceDocument(
      String id,
      GetTermsOfServiceDocumentRequest getTermsOfServiceDocumentRequest,
      RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (id == null) {
      throw new IllegalArgumentException("Please provide the id path parameter");
    }
    pathParams.put("id", id);

    String requestBody = getTermsOfServiceDocumentRequest.toJson();
    Resource resource =
        new Resource(this, this.baseURL + "/legalEntities/{id}/termsOfService", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
    return GetTermsOfServiceDocumentResponse.fromJson(jsonResult);
  }

  /**
   * Get Terms of Service information for a legal entity
   *
   * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships,
   *     this is the individual legal entity ID of the owner. For organizations, this is the ID of
   *     the organization. (required)
   * @return {@link GetTermsOfServiceAcceptanceInfosResponse }
   * @throws ApiException if fails to make API call
   */
  public GetTermsOfServiceAcceptanceInfosResponse getTermsOfServiceInformationForLegalEntity(
      String id) throws ApiException, IOException {
    return getTermsOfServiceInformationForLegalEntity(id, null);
  }

  /**
   * Get Terms of Service information for a legal entity
   *
   * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships,
   *     this is the individual legal entity ID of the owner. For organizations, this is the ID of
   *     the organization. (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link GetTermsOfServiceAcceptanceInfosResponse }
   * @throws ApiException if fails to make API call
   */
  public GetTermsOfServiceAcceptanceInfosResponse getTermsOfServiceInformationForLegalEntity(
      String id, RequestOptions requestOptions) throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (id == null) {
      throw new IllegalArgumentException("Please provide the id path parameter");
    }
    pathParams.put("id", id);

    String requestBody = null;
    Resource resource =
        new Resource(
            this, this.baseURL + "/legalEntities/{id}/termsOfServiceAcceptanceInfos", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
    return GetTermsOfServiceAcceptanceInfosResponse.fromJson(jsonResult);
  }

  /**
   * Get Terms of Service status
   *
   * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships,
   *     this is the individual legal entity ID of the owner. For organizations, this is the ID of
   *     the organization. (required)
   * @return {@link CalculateTermsOfServiceStatusResponse }
   * @throws ApiException if fails to make API call
   */
  public CalculateTermsOfServiceStatusResponse getTermsOfServiceStatus(String id)
      throws ApiException, IOException {
    return getTermsOfServiceStatus(id, null);
  }

  /**
   * Get Terms of Service status
   *
   * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships,
   *     this is the individual legal entity ID of the owner. For organizations, this is the ID of
   *     the organization. (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link CalculateTermsOfServiceStatusResponse }
   * @throws ApiException if fails to make API call
   */
  public CalculateTermsOfServiceStatusResponse getTermsOfServiceStatus(
      String id, RequestOptions requestOptions) throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (id == null) {
      throw new IllegalArgumentException("Please provide the id path parameter");
    }
    pathParams.put("id", id);

    String requestBody = null;
    Resource resource =
        new Resource(this, this.baseURL + "/legalEntities/{id}/termsOfServiceStatus", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
    return CalculateTermsOfServiceStatusResponse.fromJson(jsonResult);
  }
}
