/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.PayoutSettings;
import com.adyen.model.management.PayoutSettingsRequest;
import com.adyen.model.management.PayoutSettingsResponse;
import com.adyen.model.management.UpdatePayoutSettingsRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PayoutSettingsMerchantLevelApi extends Service {

  public static final String API_VERSION = "3";

  protected String baseURL;

  /**
   * Payout settings - merchant level constructor in {@link com.adyen.service.management package}.
   *
   * @param client {@link Client } (required)
   */
  public PayoutSettingsMerchantLevelApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://management-test.adyen.com/v3");
  }

  /**
   * Payout settings - merchant level constructor in {@link com.adyen.service.management package}.
   * Please use this constructor only if you would like to pass along your own url for routing or
   * testing purposes. The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public PayoutSettingsMerchantLevelApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Add a payout setting
   *
   * @param merchantId {@link String } The unique identifier of the merchant account. (required)
   * @param payoutSettingsRequest {@link PayoutSettingsRequest } (required)
   * @return {@link PayoutSettings }
   * @throws ApiException if fails to make API call
   */
  public PayoutSettings addPayoutSetting(
      String merchantId, PayoutSettingsRequest payoutSettingsRequest)
      throws ApiException, IOException {
    return addPayoutSetting(merchantId, payoutSettingsRequest, null);
  }

  /**
   * Add a payout setting
   *
   * @param merchantId {@link String } The unique identifier of the merchant account. (required)
   * @param payoutSettingsRequest {@link PayoutSettingsRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link PayoutSettings }
   * @throws ApiException if fails to make API call
   */
  public PayoutSettings addPayoutSetting(
      String merchantId, PayoutSettingsRequest payoutSettingsRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (merchantId == null) {
      throw new IllegalArgumentException("Please provide the merchantId path parameter");
    }
    pathParams.put("merchantId", merchantId);

    String requestBody = payoutSettingsRequest.toJson();
    Resource resource =
        new Resource(this, this.baseURL + "/merchants/{merchantId}/payoutSettings", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
    return PayoutSettings.fromJson(jsonResult);
  }

  /**
   * Delete a payout setting
   *
   * @param merchantId {@link String } The unique identifier of the merchant account. (required)
   * @param payoutSettingsId {@link String } The unique identifier of the payout setting. (required)
   * @throws ApiException if fails to make API call
   */
  public void deletePayoutSetting(String merchantId, String payoutSettingsId)
      throws ApiException, IOException {
    deletePayoutSetting(merchantId, payoutSettingsId, null);
  }

  /**
   * Delete a payout setting
   *
   * @param merchantId {@link String } The unique identifier of the merchant account. (required)
   * @param payoutSettingsId {@link String } The unique identifier of the payout setting. (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @throws ApiException if fails to make API call
   */
  public void deletePayoutSetting(
      String merchantId, String payoutSettingsId, RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (merchantId == null) {
      throw new IllegalArgumentException("Please provide the merchantId path parameter");
    }
    pathParams.put("merchantId", merchantId);
    if (payoutSettingsId == null) {
      throw new IllegalArgumentException("Please provide the payoutSettingsId path parameter");
    }
    pathParams.put("payoutSettingsId", payoutSettingsId);

    String requestBody = null;
    Resource resource =
        new Resource(
            this, this.baseURL + "/merchants/{merchantId}/payoutSettings/{payoutSettingsId}", null);
    resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
  }

  /**
   * Get a payout setting
   *
   * @param merchantId {@link String } The unique identifier of the merchant account. (required)
   * @param payoutSettingsId {@link String } The unique identifier of the payout setting. (required)
   * @return {@link PayoutSettings }
   * @throws ApiException if fails to make API call
   */
  public PayoutSettings getPayoutSetting(String merchantId, String payoutSettingsId)
      throws ApiException, IOException {
    return getPayoutSetting(merchantId, payoutSettingsId, null);
  }

  /**
   * Get a payout setting
   *
   * @param merchantId {@link String } The unique identifier of the merchant account. (required)
   * @param payoutSettingsId {@link String } The unique identifier of the payout setting. (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link PayoutSettings }
   * @throws ApiException if fails to make API call
   */
  public PayoutSettings getPayoutSetting(
      String merchantId, String payoutSettingsId, RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (merchantId == null) {
      throw new IllegalArgumentException("Please provide the merchantId path parameter");
    }
    pathParams.put("merchantId", merchantId);
    if (payoutSettingsId == null) {
      throw new IllegalArgumentException("Please provide the payoutSettingsId path parameter");
    }
    pathParams.put("payoutSettingsId", payoutSettingsId);

    String requestBody = null;
    Resource resource =
        new Resource(
            this, this.baseURL + "/merchants/{merchantId}/payoutSettings/{payoutSettingsId}", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
    return PayoutSettings.fromJson(jsonResult);
  }

  /**
   * Get a list of payout settings
   *
   * @param merchantId {@link String } The unique identifier of the merchant account. (required)
   * @return {@link PayoutSettingsResponse }
   * @throws ApiException if fails to make API call
   */
  public PayoutSettingsResponse listPayoutSettings(String merchantId)
      throws ApiException, IOException {
    return listPayoutSettings(merchantId, null);
  }

  /**
   * Get a list of payout settings
   *
   * @param merchantId {@link String } The unique identifier of the merchant account. (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link PayoutSettingsResponse }
   * @throws ApiException if fails to make API call
   */
  public PayoutSettingsResponse listPayoutSettings(String merchantId, RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (merchantId == null) {
      throw new IllegalArgumentException("Please provide the merchantId path parameter");
    }
    pathParams.put("merchantId", merchantId);

    String requestBody = null;
    Resource resource =
        new Resource(this, this.baseURL + "/merchants/{merchantId}/payoutSettings", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
    return PayoutSettingsResponse.fromJson(jsonResult);
  }

  /**
   * Update a payout setting
   *
   * @param merchantId {@link String } The unique identifier of the merchant account. (required)
   * @param payoutSettingsId {@link String } The unique identifier of the payout setting. (required)
   * @param updatePayoutSettingsRequest {@link UpdatePayoutSettingsRequest } (required)
   * @return {@link PayoutSettings }
   * @throws ApiException if fails to make API call
   */
  public PayoutSettings updatePayoutSetting(
      String merchantId,
      String payoutSettingsId,
      UpdatePayoutSettingsRequest updatePayoutSettingsRequest)
      throws ApiException, IOException {
    return updatePayoutSetting(merchantId, payoutSettingsId, updatePayoutSettingsRequest, null);
  }

  /**
   * Update a payout setting
   *
   * @param merchantId {@link String } The unique identifier of the merchant account. (required)
   * @param payoutSettingsId {@link String } The unique identifier of the payout setting. (required)
   * @param updatePayoutSettingsRequest {@link UpdatePayoutSettingsRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link PayoutSettings }
   * @throws ApiException if fails to make API call
   */
  public PayoutSettings updatePayoutSetting(
      String merchantId,
      String payoutSettingsId,
      UpdatePayoutSettingsRequest updatePayoutSettingsRequest,
      RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (merchantId == null) {
      throw new IllegalArgumentException("Please provide the merchantId path parameter");
    }
    pathParams.put("merchantId", merchantId);
    if (payoutSettingsId == null) {
      throw new IllegalArgumentException("Please provide the payoutSettingsId path parameter");
    }
    pathParams.put("payoutSettingsId", payoutSettingsId);

    String requestBody = updatePayoutSettingsRequest.toJson();
    Resource resource =
        new Resource(
            this, this.baseURL + "/merchants/{merchantId}/payoutSettings/{payoutSettingsId}", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
    return PayoutSettings.fromJson(jsonResult);
  }
}
