/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.ScheduleTerminalActionsRequest;
import com.adyen.model.management.ScheduleTerminalActionsResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class TerminalActionsTerminalLevelApi extends Service {

  public static final String API_VERSION = "3";

  protected String baseURL;

  /**
   * Terminal actions - terminal level constructor in {@link com.adyen.service.management package}.
   *
   * @param client {@link Client } (required)
   */
  public TerminalActionsTerminalLevelApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://management-test.adyen.com/v3");
  }

  /**
   * Terminal actions - terminal level constructor in {@link com.adyen.service.management package}.
   * Please use this constructor only if you would like to pass along your own url for routing or
   * testing purposes. The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public TerminalActionsTerminalLevelApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Create a terminal action
   *
   * @param scheduleTerminalActionsRequest {@link ScheduleTerminalActionsRequest } (required)
   * @return {@link ScheduleTerminalActionsResponse }
   * @throws ApiException if fails to make API call
   */
  public ScheduleTerminalActionsResponse createTerminalAction(
      ScheduleTerminalActionsRequest scheduleTerminalActionsRequest)
      throws ApiException, IOException {
    return createTerminalAction(scheduleTerminalActionsRequest, null);
  }

  /**
   * Create a terminal action
   *
   * @param scheduleTerminalActionsRequest {@link ScheduleTerminalActionsRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link ScheduleTerminalActionsResponse }
   * @throws ApiException if fails to make API call
   */
  public ScheduleTerminalActionsResponse createTerminalAction(
      ScheduleTerminalActionsRequest scheduleTerminalActionsRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = scheduleTerminalActionsRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/terminals/scheduleActions", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return ScheduleTerminalActionsResponse.fromJson(jsonResult);
  }
}
