/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.payment;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.payment.AdjustAuthorisationRequest;
import com.adyen.model.payment.CancelOrRefundRequest;
import com.adyen.model.payment.CancelRequest;
import com.adyen.model.payment.CaptureRequest;
import com.adyen.model.payment.DonationRequest;
import com.adyen.model.payment.ModificationResult;
import com.adyen.model.payment.RefundRequest;
import com.adyen.model.payment.TechnicalCancelRequest;
import com.adyen.model.payment.VoidPendingRefundRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class ModificationsApi extends Service {

  public static final String API_VERSION = "68";

  protected String baseURL;

  /**
   * Modifications constructor in {@link com.adyen.service.payment package}.
   *
   * @param client {@link Client } (required)
   */
  public ModificationsApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://pal-test.adyen.com/pal/servlet/Payment/v68");
  }

  /**
   * Modifications constructor in {@link com.adyen.service.payment package}. Please use this
   * constructor only if you would like to pass along your own url for routing or testing purposes.
   * The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public ModificationsApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Change the authorised amount
   *
   * @param adjustAuthorisationRequest {@link AdjustAuthorisationRequest } (required)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult adjustAuthorisation(
      AdjustAuthorisationRequest adjustAuthorisationRequest) throws ApiException, IOException {
    return adjustAuthorisation(adjustAuthorisationRequest, null);
  }

  /**
   * Change the authorised amount
   *
   * @param adjustAuthorisationRequest {@link AdjustAuthorisationRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult adjustAuthorisation(
      AdjustAuthorisationRequest adjustAuthorisationRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = adjustAuthorisationRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/adjustAuthorisation", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return ModificationResult.fromJson(jsonResult);
  }

  /**
   * Cancel an authorisation
   *
   * @param cancelRequest {@link CancelRequest } (required)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult cancel(CancelRequest cancelRequest) throws ApiException, IOException {
    return cancel(cancelRequest, null);
  }

  /**
   * Cancel an authorisation
   *
   * @param cancelRequest {@link CancelRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult cancel(CancelRequest cancelRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = cancelRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/cancel", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return ModificationResult.fromJson(jsonResult);
  }

  /**
   * Cancel or refund a payment
   *
   * @param cancelOrRefundRequest {@link CancelOrRefundRequest } (required)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult cancelOrRefund(CancelOrRefundRequest cancelOrRefundRequest)
      throws ApiException, IOException {
    return cancelOrRefund(cancelOrRefundRequest, null);
  }

  /**
   * Cancel or refund a payment
   *
   * @param cancelOrRefundRequest {@link CancelOrRefundRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult cancelOrRefund(
      CancelOrRefundRequest cancelOrRefundRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = cancelOrRefundRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/cancelOrRefund", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return ModificationResult.fromJson(jsonResult);
  }

  /**
   * Capture an authorisation
   *
   * @param captureRequest {@link CaptureRequest } (required)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult capture(CaptureRequest captureRequest)
      throws ApiException, IOException {
    return capture(captureRequest, null);
  }

  /**
   * Capture an authorisation
   *
   * @param captureRequest {@link CaptureRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult capture(CaptureRequest captureRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = captureRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/capture", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return ModificationResult.fromJson(jsonResult);
  }

  /**
   * Create a donation
   *
   * @param donationRequest {@link DonationRequest } (required)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   * @deprecated
   */
  @Deprecated
  public ModificationResult donate(DonationRequest donationRequest)
      throws ApiException, IOException {
    return donate(donationRequest, null);
  }

  /**
   * Create a donation
   *
   * @param donationRequest {@link DonationRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   * @deprecated
   */
  @Deprecated
  public ModificationResult donate(DonationRequest donationRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = donationRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/donate", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return ModificationResult.fromJson(jsonResult);
  }

  /**
   * Refund a captured payment
   *
   * @param refundRequest {@link RefundRequest } (required)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult refund(RefundRequest refundRequest) throws ApiException, IOException {
    return refund(refundRequest, null);
  }

  /**
   * Refund a captured payment
   *
   * @param refundRequest {@link RefundRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult refund(RefundRequest refundRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = refundRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/refund", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return ModificationResult.fromJson(jsonResult);
  }

  /**
   * Cancel an authorisation using your reference
   *
   * @param technicalCancelRequest {@link TechnicalCancelRequest } (required)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult technicalCancel(TechnicalCancelRequest technicalCancelRequest)
      throws ApiException, IOException {
    return technicalCancel(technicalCancelRequest, null);
  }

  /**
   * Cancel an authorisation using your reference
   *
   * @param technicalCancelRequest {@link TechnicalCancelRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult technicalCancel(
      TechnicalCancelRequest technicalCancelRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = technicalCancelRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/technicalCancel", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return ModificationResult.fromJson(jsonResult);
  }

  /**
   * Cancel an in-person refund
   *
   * @param voidPendingRefundRequest {@link VoidPendingRefundRequest } (required)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult voidPendingRefund(VoidPendingRefundRequest voidPendingRefundRequest)
      throws ApiException, IOException {
    return voidPendingRefund(voidPendingRefundRequest, null);
  }

  /**
   * Cancel an in-person refund
   *
   * @param voidPendingRefundRequest {@link VoidPendingRefundRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link ModificationResult }
   * @throws ApiException if fails to make API call
   */
  public ModificationResult voidPendingRefund(
      VoidPendingRefundRequest voidPendingRefundRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = voidPendingRefundRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/voidPendingRefund", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return ModificationResult.fromJson(jsonResult);
  }
}
