/*
 * POS Mobile API
 *
 * The version of the OpenAPI document: 68
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.posmobile;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.posmobile.CreateSessionRequest;
import com.adyen.model.posmobile.CreateSessionResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class PosMobileApi extends Service {

  public static final String API_VERSION = "68";

  protected String baseURL;

  /**
   * PosMobile constructor in {@link com.adyen.service.posmobile package}.
   *
   * @param client {@link Client } (required)
   */
  public PosMobileApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://checkout-test.adyen.com/checkout/possdk/v68");
  }

  /**
   * PosMobile constructor in {@link com.adyen.service.posmobile package}. Please use this
   * constructor only if you would like to pass along your own url for routing or testing purposes.
   * The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public PosMobileApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Create a communication session
   *
   * @param createSessionRequest {@link CreateSessionRequest } (required)
   * @return {@link CreateSessionResponse }
   * @throws ApiException if fails to make API call
   */
  public CreateSessionResponse createCommunicationSession(CreateSessionRequest createSessionRequest)
      throws ApiException, IOException {
    return createCommunicationSession(createSessionRequest, null);
  }

  /**
   * Create a communication session
   *
   * @param createSessionRequest {@link CreateSessionRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link CreateSessionResponse }
   * @throws ApiException if fails to make API call
   */
  public CreateSessionResponse createCommunicationSession(
      CreateSessionRequest createSessionRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = createSessionRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/sessions", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return CreateSessionResponse.fromJson(jsonResult);
  }
}
