/*
 * Authentication webhooks
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.acswebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.Objects;

/** ChallengeInfo */
@JsonPropertyOrder({
  ChallengeInfo.JSON_PROPERTY_CHALLENGE_CANCEL,
  ChallengeInfo.JSON_PROPERTY_FLOW,
  ChallengeInfo.JSON_PROPERTY_LAST_INTERACTION,
  ChallengeInfo.JSON_PROPERTY_PHONE_NUMBER,
  ChallengeInfo.JSON_PROPERTY_RESENDS,
  ChallengeInfo.JSON_PROPERTY_RETRIES
})
public class ChallengeInfo {
  /**
   * Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the
   * authentication has been cancelled. Possible values: * **00**: Data element is absent or value
   * has been sent back with the key &#x60;challengeCancel&#x60;. * **01**: Cardholder selected
   * **Cancel**. * **02**: 3DS Requestor cancelled Authentication. * **03**: Transaction abandoned.
   * * **04**: Transaction timed out at ACS — other timeouts. * **05**: Transaction timed out at ACS
   * — first CReq not received by ACS. * **06**: Transaction error. * **07**: Unknown. * **08**:
   * Transaction time out at SDK.
   */
  public enum ChallengeCancelEnum {
    _00(String.valueOf("00")),

    _01(String.valueOf("01")),

    _02(String.valueOf("02")),

    _03(String.valueOf("03")),

    _04(String.valueOf("04")),

    _05(String.valueOf("05")),

    _06(String.valueOf("06")),

    _07(String.valueOf("07")),

    _08(String.valueOf("08"));

    private String value;

    ChallengeCancelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChallengeCancelEnum fromValue(String value) {
      for (ChallengeCancelEnum b : ChallengeCancelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHALLENGE_CANCEL = "challengeCancel";
  private ChallengeCancelEnum challengeCancel;

  /**
   * The flow used in the challenge. Possible values: * **PWD_OTP_PHONE_FL**: one-time password
   * (OTP) flow via SMS * **PWD_OTP_EMAIL_FL**: one-time password (OTP) flow via email *
   * **OOB_TRIGGER_FL**: out-of-band (OOB) flow
   */
  public enum FlowEnum {
    PWD_OTP_PHONE_FL(String.valueOf("PWD_OTP_PHONE_FL")),

    PWD_OTP_EMAIL_FL(String.valueOf("PWD_OTP_EMAIL_FL")),

    OOB_TRIGGER_FL(String.valueOf("OOB_TRIGGER_FL"));

    private String value;

    FlowEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FlowEnum fromValue(String value) {
      for (FlowEnum b : FlowEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FLOW = "flow";
  private FlowEnum flow;

  public static final String JSON_PROPERTY_LAST_INTERACTION = "lastInteraction";
  private OffsetDateTime lastInteraction;

  public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
  private String phoneNumber;

  public static final String JSON_PROPERTY_RESENDS = "resends";
  private Integer resends;

  public static final String JSON_PROPERTY_RETRIES = "retries";
  private Integer retries;

  public ChallengeInfo() {}

  /**
   * Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the
   * authentication has been cancelled. Possible values: * **00**: Data element is absent or value
   * has been sent back with the key &#x60;challengeCancel&#x60;. * **01**: Cardholder selected
   * **Cancel**. * **02**: 3DS Requestor cancelled Authentication. * **03**: Transaction abandoned.
   * * **04**: Transaction timed out at ACS — other timeouts. * **05**: Transaction timed out at ACS
   * — first CReq not received by ACS. * **06**: Transaction error. * **07**: Unknown. * **08**:
   * Transaction time out at SDK.
   *
   * @param challengeCancel Indicator informing the Access Control Server (ACS) and the Directory
   *     Server (DS) that the authentication has been cancelled. Possible values: * **00**: Data
   *     element is absent or value has been sent back with the key &#x60;challengeCancel&#x60;. *
   *     **01**: Cardholder selected **Cancel**. * **02**: 3DS Requestor cancelled Authentication. *
   *     **03**: Transaction abandoned. * **04**: Transaction timed out at ACS — other timeouts. *
   *     **05**: Transaction timed out at ACS — first CReq not received by ACS. * **06**:
   *     Transaction error. * **07**: Unknown. * **08**: Transaction time out at SDK.
   * @return the current {@code ChallengeInfo} instance, allowing for method chaining
   */
  public ChallengeInfo challengeCancel(ChallengeCancelEnum challengeCancel) {
    this.challengeCancel = challengeCancel;
    return this;
  }

  /**
   * Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the
   * authentication has been cancelled. Possible values: * **00**: Data element is absent or value
   * has been sent back with the key &#x60;challengeCancel&#x60;. * **01**: Cardholder selected
   * **Cancel**. * **02**: 3DS Requestor cancelled Authentication. * **03**: Transaction abandoned.
   * * **04**: Transaction timed out at ACS — other timeouts. * **05**: Transaction timed out at ACS
   * — first CReq not received by ACS. * **06**: Transaction error. * **07**: Unknown. * **08**:
   * Transaction time out at SDK.
   *
   * @return challengeCancel Indicator informing the Access Control Server (ACS) and the Directory
   *     Server (DS) that the authentication has been cancelled. Possible values: * **00**: Data
   *     element is absent or value has been sent back with the key &#x60;challengeCancel&#x60;. *
   *     **01**: Cardholder selected **Cancel**. * **02**: 3DS Requestor cancelled Authentication. *
   *     **03**: Transaction abandoned. * **04**: Transaction timed out at ACS — other timeouts. *
   *     **05**: Transaction timed out at ACS — first CReq not received by ACS. * **06**:
   *     Transaction error. * **07**: Unknown. * **08**: Transaction time out at SDK.
   */
  @JsonProperty(JSON_PROPERTY_CHALLENGE_CANCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ChallengeCancelEnum getChallengeCancel() {
    return challengeCancel;
  }

  /**
   * Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the
   * authentication has been cancelled. Possible values: * **00**: Data element is absent or value
   * has been sent back with the key &#x60;challengeCancel&#x60;. * **01**: Cardholder selected
   * **Cancel**. * **02**: 3DS Requestor cancelled Authentication. * **03**: Transaction abandoned.
   * * **04**: Transaction timed out at ACS — other timeouts. * **05**: Transaction timed out at ACS
   * — first CReq not received by ACS. * **06**: Transaction error. * **07**: Unknown. * **08**:
   * Transaction time out at SDK.
   *
   * @param challengeCancel Indicator informing the Access Control Server (ACS) and the Directory
   *     Server (DS) that the authentication has been cancelled. Possible values: * **00**: Data
   *     element is absent or value has been sent back with the key &#x60;challengeCancel&#x60;. *
   *     **01**: Cardholder selected **Cancel**. * **02**: 3DS Requestor cancelled Authentication. *
   *     **03**: Transaction abandoned. * **04**: Transaction timed out at ACS — other timeouts. *
   *     **05**: Transaction timed out at ACS — first CReq not received by ACS. * **06**:
   *     Transaction error. * **07**: Unknown. * **08**: Transaction time out at SDK.
   */
  @JsonProperty(JSON_PROPERTY_CHALLENGE_CANCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChallengeCancel(ChallengeCancelEnum challengeCancel) {
    this.challengeCancel = challengeCancel;
  }

  /**
   * The flow used in the challenge. Possible values: * **PWD_OTP_PHONE_FL**: one-time password
   * (OTP) flow via SMS * **PWD_OTP_EMAIL_FL**: one-time password (OTP) flow via email *
   * **OOB_TRIGGER_FL**: out-of-band (OOB) flow
   *
   * @param flow The flow used in the challenge. Possible values: * **PWD_OTP_PHONE_FL**: one-time
   *     password (OTP) flow via SMS * **PWD_OTP_EMAIL_FL**: one-time password (OTP) flow via email
   *     * **OOB_TRIGGER_FL**: out-of-band (OOB) flow
   * @return the current {@code ChallengeInfo} instance, allowing for method chaining
   */
  public ChallengeInfo flow(FlowEnum flow) {
    this.flow = flow;
    return this;
  }

  /**
   * The flow used in the challenge. Possible values: * **PWD_OTP_PHONE_FL**: one-time password
   * (OTP) flow via SMS * **PWD_OTP_EMAIL_FL**: one-time password (OTP) flow via email *
   * **OOB_TRIGGER_FL**: out-of-band (OOB) flow
   *
   * @return flow The flow used in the challenge. Possible values: * **PWD_OTP_PHONE_FL**: one-time
   *     password (OTP) flow via SMS * **PWD_OTP_EMAIL_FL**: one-time password (OTP) flow via email
   *     * **OOB_TRIGGER_FL**: out-of-band (OOB) flow
   */
  @JsonProperty(JSON_PROPERTY_FLOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FlowEnum getFlow() {
    return flow;
  }

  /**
   * The flow used in the challenge. Possible values: * **PWD_OTP_PHONE_FL**: one-time password
   * (OTP) flow via SMS * **PWD_OTP_EMAIL_FL**: one-time password (OTP) flow via email *
   * **OOB_TRIGGER_FL**: out-of-band (OOB) flow
   *
   * @param flow The flow used in the challenge. Possible values: * **PWD_OTP_PHONE_FL**: one-time
   *     password (OTP) flow via SMS * **PWD_OTP_EMAIL_FL**: one-time password (OTP) flow via email
   *     * **OOB_TRIGGER_FL**: out-of-band (OOB) flow
   */
  @JsonProperty(JSON_PROPERTY_FLOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlow(FlowEnum flow) {
    this.flow = flow;
  }

  /**
   * The last time of interaction with the challenge.
   *
   * @param lastInteraction The last time of interaction with the challenge.
   * @return the current {@code ChallengeInfo} instance, allowing for method chaining
   */
  public ChallengeInfo lastInteraction(OffsetDateTime lastInteraction) {
    this.lastInteraction = lastInteraction;
    return this;
  }

  /**
   * The last time of interaction with the challenge.
   *
   * @return lastInteraction The last time of interaction with the challenge.
   */
  @JsonProperty(JSON_PROPERTY_LAST_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getLastInteraction() {
    return lastInteraction;
  }

  /**
   * The last time of interaction with the challenge.
   *
   * @param lastInteraction The last time of interaction with the challenge.
   */
  @JsonProperty(JSON_PROPERTY_LAST_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastInteraction(OffsetDateTime lastInteraction) {
    this.lastInteraction = lastInteraction;
  }

  /**
   * The last four digits of the phone number used in the challenge.
   *
   * @param phoneNumber The last four digits of the phone number used in the challenge.
   * @return the current {@code ChallengeInfo} instance, allowing for method chaining
   */
  public ChallengeInfo phoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * The last four digits of the phone number used in the challenge.
   *
   * @return phoneNumber The last four digits of the phone number used in the challenge.
   */
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * The last four digits of the phone number used in the challenge.
   *
   * @param phoneNumber The last four digits of the phone number used in the challenge.
   */
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  /**
   * The number of times the one-time password (OTP) was resent during the challenge.
   *
   * @param resends The number of times the one-time password (OTP) was resent during the challenge.
   * @return the current {@code ChallengeInfo} instance, allowing for method chaining
   */
  public ChallengeInfo resends(Integer resends) {
    this.resends = resends;
    return this;
  }

  /**
   * The number of times the one-time password (OTP) was resent during the challenge.
   *
   * @return resends The number of times the one-time password (OTP) was resent during the
   *     challenge.
   */
  @JsonProperty(JSON_PROPERTY_RESENDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getResends() {
    return resends;
  }

  /**
   * The number of times the one-time password (OTP) was resent during the challenge.
   *
   * @param resends The number of times the one-time password (OTP) was resent during the challenge.
   */
  @JsonProperty(JSON_PROPERTY_RESENDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResends(Integer resends) {
    this.resends = resends;
  }

  /**
   * The number of retries used in the challenge.
   *
   * @param retries The number of retries used in the challenge.
   * @return the current {@code ChallengeInfo} instance, allowing for method chaining
   */
  public ChallengeInfo retries(Integer retries) {
    this.retries = retries;
    return this;
  }

  /**
   * The number of retries used in the challenge.
   *
   * @return retries The number of retries used in the challenge.
   */
  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getRetries() {
    return retries;
  }

  /**
   * The number of retries used in the challenge.
   *
   * @param retries The number of retries used in the challenge.
   */
  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetries(Integer retries) {
    this.retries = retries;
  }

  /** Return true if this ChallengeInfo object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChallengeInfo challengeInfo = (ChallengeInfo) o;
    return Objects.equals(this.challengeCancel, challengeInfo.challengeCancel)
        && Objects.equals(this.flow, challengeInfo.flow)
        && Objects.equals(this.lastInteraction, challengeInfo.lastInteraction)
        && Objects.equals(this.phoneNumber, challengeInfo.phoneNumber)
        && Objects.equals(this.resends, challengeInfo.resends)
        && Objects.equals(this.retries, challengeInfo.retries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(challengeCancel, flow, lastInteraction, phoneNumber, resends, retries);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChallengeInfo {\n");
    sb.append("    challengeCancel: ").append(toIndentedString(challengeCancel)).append("\n");
    sb.append("    flow: ").append(toIndentedString(flow)).append("\n");
    sb.append("    lastInteraction: ").append(toIndentedString(lastInteraction)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    resends: ").append(toIndentedString(resends)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ChallengeInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ChallengeInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to ChallengeInfo
   */
  public static ChallengeInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ChallengeInfo.class);
  }

  /**
   * Convert an instance of ChallengeInfo to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
