/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** BankAccountIdentificationTypeRequirement */
@JsonPropertyOrder({
  BankAccountIdentificationTypeRequirement.JSON_PROPERTY_BANK_ACCOUNT_IDENTIFICATION_TYPES,
  BankAccountIdentificationTypeRequirement.JSON_PROPERTY_DESCRIPTION,
  BankAccountIdentificationTypeRequirement.JSON_PROPERTY_TYPE
})
public class BankAccountIdentificationTypeRequirement {
  /** Gets or Sets bankAccountIdentificationTypes */
  public enum BankAccountIdentificationTypesEnum {
    AULOCAL(String.valueOf("auLocal")),

    BRLOCAL(String.valueOf("brLocal")),

    CALOCAL(String.valueOf("caLocal")),

    CZLOCAL(String.valueOf("czLocal")),

    DKLOCAL(String.valueOf("dkLocal")),

    HKLOCAL(String.valueOf("hkLocal")),

    HULOCAL(String.valueOf("huLocal")),

    IBAN(String.valueOf("iban")),

    LEGACY(String.valueOf("legacy")),

    NOLOCAL(String.valueOf("noLocal")),

    NUMBERANDBIC(String.valueOf("numberAndBic")),

    NZLOCAL(String.valueOf("nzLocal")),

    PLLOCAL(String.valueOf("plLocal")),

    SELOCAL(String.valueOf("seLocal")),

    SGLOCAL(String.valueOf("sgLocal")),

    UKLOCAL(String.valueOf("ukLocal")),

    USLOCAL(String.valueOf("usLocal"));

    private String value;

    BankAccountIdentificationTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BankAccountIdentificationTypesEnum fromValue(String value) {
      for (BankAccountIdentificationTypesEnum b : BankAccountIdentificationTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BANK_ACCOUNT_IDENTIFICATION_TYPES =
      "bankAccountIdentificationTypes";
  private List<BankAccountIdentificationTypesEnum> bankAccountIdentificationTypes;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  /** **bankAccountIdentificationTypeRequirement** */
  public enum TypeEnum {
    BANKACCOUNTIDENTIFICATIONTYPEREQUIREMENT(
        String.valueOf("bankAccountIdentificationTypeRequirement"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.BANKACCOUNTIDENTIFICATIONTYPEREQUIREMENT;

  public BankAccountIdentificationTypeRequirement() {}

  /**
   * List of bank account identification types: eg.; [iban , numberAndBic]
   *
   * @param bankAccountIdentificationTypes List of bank account identification types: eg.; [iban ,
   *     numberAndBic]
   * @return the current {@code BankAccountIdentificationTypeRequirement} instance, allowing for
   *     method chaining
   */
  public BankAccountIdentificationTypeRequirement bankAccountIdentificationTypes(
      List<BankAccountIdentificationTypesEnum> bankAccountIdentificationTypes) {
    this.bankAccountIdentificationTypes = bankAccountIdentificationTypes;
    return this;
  }

  public BankAccountIdentificationTypeRequirement addBankAccountIdentificationTypesItem(
      BankAccountIdentificationTypesEnum bankAccountIdentificationTypesItem) {
    if (this.bankAccountIdentificationTypes == null) {
      this.bankAccountIdentificationTypes = new ArrayList<>();
    }
    this.bankAccountIdentificationTypes.add(bankAccountIdentificationTypesItem);
    return this;
  }

  /**
   * List of bank account identification types: eg.; [iban , numberAndBic]
   *
   * @return bankAccountIdentificationTypes List of bank account identification types: eg.; [iban ,
   *     numberAndBic]
   */
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_IDENTIFICATION_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<BankAccountIdentificationTypesEnum> getBankAccountIdentificationTypes() {
    return bankAccountIdentificationTypes;
  }

  /**
   * List of bank account identification types: eg.; [iban , numberAndBic]
   *
   * @param bankAccountIdentificationTypes List of bank account identification types: eg.; [iban ,
   *     numberAndBic]
   */
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_IDENTIFICATION_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccountIdentificationTypes(
      List<BankAccountIdentificationTypesEnum> bankAccountIdentificationTypes) {
    this.bankAccountIdentificationTypes = bankAccountIdentificationTypes;
  }

  /**
   * Specifies the bank account details for a particular route per required field in this object
   * depending on the country of the bank account and the currency of the transfer.
   *
   * @param description Specifies the bank account details for a particular route per required field
   *     in this object depending on the country of the bank account and the currency of the
   *     transfer.
   * @return the current {@code BankAccountIdentificationTypeRequirement} instance, allowing for
   *     method chaining
   */
  public BankAccountIdentificationTypeRequirement description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Specifies the bank account details for a particular route per required field in this object
   * depending on the country of the bank account and the currency of the transfer.
   *
   * @return description Specifies the bank account details for a particular route per required
   *     field in this object depending on the country of the bank account and the currency of the
   *     transfer.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * Specifies the bank account details for a particular route per required field in this object
   * depending on the country of the bank account and the currency of the transfer.
   *
   * @param description Specifies the bank account details for a particular route per required field
   *     in this object depending on the country of the bank account and the currency of the
   *     transfer.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * **bankAccountIdentificationTypeRequirement**
   *
   * @param type **bankAccountIdentificationTypeRequirement**
   * @return the current {@code BankAccountIdentificationTypeRequirement} instance, allowing for
   *     method chaining
   */
  public BankAccountIdentificationTypeRequirement type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **bankAccountIdentificationTypeRequirement**
   *
   * @return type **bankAccountIdentificationTypeRequirement**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **bankAccountIdentificationTypeRequirement**
   *
   * @param type **bankAccountIdentificationTypeRequirement**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this BankAccountIdentificationTypeRequirement object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankAccountIdentificationTypeRequirement bankAccountIdentificationTypeRequirement =
        (BankAccountIdentificationTypeRequirement) o;
    return Objects.equals(
            this.bankAccountIdentificationTypes,
            bankAccountIdentificationTypeRequirement.bankAccountIdentificationTypes)
        && Objects.equals(this.description, bankAccountIdentificationTypeRequirement.description)
        && Objects.equals(this.type, bankAccountIdentificationTypeRequirement.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bankAccountIdentificationTypes, description, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankAccountIdentificationTypeRequirement {\n");
    sb.append("    bankAccountIdentificationTypes: ")
        .append(toIndentedString(bankAccountIdentificationTypes))
        .append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of BankAccountIdentificationTypeRequirement given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BankAccountIdentificationTypeRequirement
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     BankAccountIdentificationTypeRequirement
   */
  public static BankAccountIdentificationTypeRequirement fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BankAccountIdentificationTypeRequirement.class);
  }

  /**
   * Convert an instance of BankAccountIdentificationTypeRequirement to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
