/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** PaginatedGetCardOrderItemResponse */
@JsonPropertyOrder({
  PaginatedGetCardOrderItemResponse.JSON_PROPERTY_DATA,
  PaginatedGetCardOrderItemResponse.JSON_PROPERTY_HAS_NEXT,
  PaginatedGetCardOrderItemResponse.JSON_PROPERTY_HAS_PREVIOUS
})
public class PaginatedGetCardOrderItemResponse {
  public static final String JSON_PROPERTY_DATA = "data";
  private List<CardOrderItem> data;

  public static final String JSON_PROPERTY_HAS_NEXT = "hasNext";
  private Boolean hasNext;

  public static final String JSON_PROPERTY_HAS_PREVIOUS = "hasPrevious";
  private Boolean hasPrevious;

  public PaginatedGetCardOrderItemResponse() {}

  /**
   * List of card order items in the card order batch.
   *
   * @param data List of card order items in the card order batch.
   * @return the current {@code PaginatedGetCardOrderItemResponse} instance, allowing for method
   *     chaining
   */
  public PaginatedGetCardOrderItemResponse data(List<CardOrderItem> data) {
    this.data = data;
    return this;
  }

  public PaginatedGetCardOrderItemResponse addDataItem(CardOrderItem dataItem) {
    if (this.data == null) {
      this.data = new ArrayList<>();
    }
    this.data.add(dataItem);
    return this;
  }

  /**
   * List of card order items in the card order batch.
   *
   * @return data List of card order items in the card order batch.
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<CardOrderItem> getData() {
    return data;
  }

  /**
   * List of card order items in the card order batch.
   *
   * @param data List of card order items in the card order batch.
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(List<CardOrderItem> data) {
    this.data = data;
  }

  /**
   * Indicates whether there are more items on the next page.
   *
   * @param hasNext Indicates whether there are more items on the next page.
   * @return the current {@code PaginatedGetCardOrderItemResponse} instance, allowing for method
   *     chaining
   */
  public PaginatedGetCardOrderItemResponse hasNext(Boolean hasNext) {
    this.hasNext = hasNext;
    return this;
  }

  /**
   * Indicates whether there are more items on the next page.
   *
   * @return hasNext Indicates whether there are more items on the next page.
   */
  @JsonProperty(JSON_PROPERTY_HAS_NEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHasNext() {
    return hasNext;
  }

  /**
   * Indicates whether there are more items on the next page.
   *
   * @param hasNext Indicates whether there are more items on the next page.
   */
  @JsonProperty(JSON_PROPERTY_HAS_NEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasNext(Boolean hasNext) {
    this.hasNext = hasNext;
  }

  /**
   * Indicates whether there are more items on the previous page.
   *
   * @param hasPrevious Indicates whether there are more items on the previous page.
   * @return the current {@code PaginatedGetCardOrderItemResponse} instance, allowing for method
   *     chaining
   */
  public PaginatedGetCardOrderItemResponse hasPrevious(Boolean hasPrevious) {
    this.hasPrevious = hasPrevious;
    return this;
  }

  /**
   * Indicates whether there are more items on the previous page.
   *
   * @return hasPrevious Indicates whether there are more items on the previous page.
   */
  @JsonProperty(JSON_PROPERTY_HAS_PREVIOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHasPrevious() {
    return hasPrevious;
  }

  /**
   * Indicates whether there are more items on the previous page.
   *
   * @param hasPrevious Indicates whether there are more items on the previous page.
   */
  @JsonProperty(JSON_PROPERTY_HAS_PREVIOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPrevious(Boolean hasPrevious) {
    this.hasPrevious = hasPrevious;
  }

  /** Return true if this PaginatedGetCardOrderItemResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaginatedGetCardOrderItemResponse paginatedGetCardOrderItemResponse =
        (PaginatedGetCardOrderItemResponse) o;
    return Objects.equals(this.data, paginatedGetCardOrderItemResponse.data)
        && Objects.equals(this.hasNext, paginatedGetCardOrderItemResponse.hasNext)
        && Objects.equals(this.hasPrevious, paginatedGetCardOrderItemResponse.hasPrevious);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data, hasNext, hasPrevious);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaginatedGetCardOrderItemResponse {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    hasNext: ").append(toIndentedString(hasNext)).append("\n");
    sb.append("    hasPrevious: ").append(toIndentedString(hasPrevious)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PaginatedGetCardOrderItemResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaginatedGetCardOrderItemResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PaginatedGetCardOrderItemResponse
   */
  public static PaginatedGetCardOrderItemResponse fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaginatedGetCardOrderItemResponse.class);
  }

  /**
   * Convert an instance of PaginatedGetCardOrderItemResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
