/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** PaginatedGetCardOrderResponse */
@JsonPropertyOrder({
  PaginatedGetCardOrderResponse.JSON_PROPERTY_CARD_ORDERS,
  PaginatedGetCardOrderResponse.JSON_PROPERTY_HAS_NEXT,
  PaginatedGetCardOrderResponse.JSON_PROPERTY_HAS_PREVIOUS
})
public class PaginatedGetCardOrderResponse {
  public static final String JSON_PROPERTY_CARD_ORDERS = "cardOrders";
  private List<CardOrder> cardOrders;

  public static final String JSON_PROPERTY_HAS_NEXT = "hasNext";
  private Boolean hasNext;

  public static final String JSON_PROPERTY_HAS_PREVIOUS = "hasPrevious";
  private Boolean hasPrevious;

  public PaginatedGetCardOrderResponse() {}

  /**
   * Contains objects with information about card orders.
   *
   * @param cardOrders Contains objects with information about card orders.
   * @return the current {@code PaginatedGetCardOrderResponse} instance, allowing for method
   *     chaining
   */
  public PaginatedGetCardOrderResponse cardOrders(List<CardOrder> cardOrders) {
    this.cardOrders = cardOrders;
    return this;
  }

  public PaginatedGetCardOrderResponse addCardOrdersItem(CardOrder cardOrdersItem) {
    if (this.cardOrders == null) {
      this.cardOrders = new ArrayList<>();
    }
    this.cardOrders.add(cardOrdersItem);
    return this;
  }

  /**
   * Contains objects with information about card orders.
   *
   * @return cardOrders Contains objects with information about card orders.
   */
  @JsonProperty(JSON_PROPERTY_CARD_ORDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<CardOrder> getCardOrders() {
    return cardOrders;
  }

  /**
   * Contains objects with information about card orders.
   *
   * @param cardOrders Contains objects with information about card orders.
   */
  @JsonProperty(JSON_PROPERTY_CARD_ORDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCardOrders(List<CardOrder> cardOrders) {
    this.cardOrders = cardOrders;
  }

  /**
   * Indicates whether there are more items on the next page.
   *
   * @param hasNext Indicates whether there are more items on the next page.
   * @return the current {@code PaginatedGetCardOrderResponse} instance, allowing for method
   *     chaining
   */
  public PaginatedGetCardOrderResponse hasNext(Boolean hasNext) {
    this.hasNext = hasNext;
    return this;
  }

  /**
   * Indicates whether there are more items on the next page.
   *
   * @return hasNext Indicates whether there are more items on the next page.
   */
  @JsonProperty(JSON_PROPERTY_HAS_NEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHasNext() {
    return hasNext;
  }

  /**
   * Indicates whether there are more items on the next page.
   *
   * @param hasNext Indicates whether there are more items on the next page.
   */
  @JsonProperty(JSON_PROPERTY_HAS_NEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasNext(Boolean hasNext) {
    this.hasNext = hasNext;
  }

  /**
   * Indicates whether there are more items on the previous page.
   *
   * @param hasPrevious Indicates whether there are more items on the previous page.
   * @return the current {@code PaginatedGetCardOrderResponse} instance, allowing for method
   *     chaining
   */
  public PaginatedGetCardOrderResponse hasPrevious(Boolean hasPrevious) {
    this.hasPrevious = hasPrevious;
    return this;
  }

  /**
   * Indicates whether there are more items on the previous page.
   *
   * @return hasPrevious Indicates whether there are more items on the previous page.
   */
  @JsonProperty(JSON_PROPERTY_HAS_PREVIOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHasPrevious() {
    return hasPrevious;
  }

  /**
   * Indicates whether there are more items on the previous page.
   *
   * @param hasPrevious Indicates whether there are more items on the previous page.
   */
  @JsonProperty(JSON_PROPERTY_HAS_PREVIOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPrevious(Boolean hasPrevious) {
    this.hasPrevious = hasPrevious;
  }

  /** Return true if this PaginatedGetCardOrderResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaginatedGetCardOrderResponse paginatedGetCardOrderResponse = (PaginatedGetCardOrderResponse) o;
    return Objects.equals(this.cardOrders, paginatedGetCardOrderResponse.cardOrders)
        && Objects.equals(this.hasNext, paginatedGetCardOrderResponse.hasNext)
        && Objects.equals(this.hasPrevious, paginatedGetCardOrderResponse.hasPrevious);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardOrders, hasNext, hasPrevious);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaginatedGetCardOrderResponse {\n");
    sb.append("    cardOrders: ").append(toIndentedString(cardOrders)).append("\n");
    sb.append("    hasNext: ").append(toIndentedString(hasNext)).append("\n");
    sb.append("    hasPrevious: ").append(toIndentedString(hasPrevious)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PaginatedGetCardOrderResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaginatedGetCardOrderResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PaginatedGetCardOrderResponse
   */
  public static PaginatedGetCardOrderResponse fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaginatedGetCardOrderResponse.class);
  }

  /**
   * Convert an instance of PaginatedGetCardOrderResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
