/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** RemediatingAction */
@JsonPropertyOrder({RemediatingAction.JSON_PROPERTY_CODE, RemediatingAction.JSON_PROPERTY_MESSAGE})
public class RemediatingAction {
  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public RemediatingAction() {}

  /**
   * The remediating action code.
   *
   * @param code The remediating action code.
   * @return the current {@code RemediatingAction} instance, allowing for method chaining
   */
  public RemediatingAction code(String code) {
    this.code = code;
    return this;
  }

  /**
   * The remediating action code.
   *
   * @return code The remediating action code.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCode() {
    return code;
  }

  /**
   * The remediating action code.
   *
   * @param code The remediating action code.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }

  /**
   * A description of how you can resolve the verification error.
   *
   * @param message A description of how you can resolve the verification error.
   * @return the current {@code RemediatingAction} instance, allowing for method chaining
   */
  public RemediatingAction message(String message) {
    this.message = message;
    return this;
  }

  /**
   * A description of how you can resolve the verification error.
   *
   * @return message A description of how you can resolve the verification error.
   */
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMessage() {
    return message;
  }

  /**
   * A description of how you can resolve the verification error.
   *
   * @param message A description of how you can resolve the verification error.
   */
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }

  /** Return true if this RemediatingAction object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RemediatingAction remediatingAction = (RemediatingAction) o;
    return Objects.equals(this.code, remediatingAction.code)
        && Objects.equals(this.message, remediatingAction.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RemediatingAction {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of RemediatingAction given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of RemediatingAction
   * @throws JsonProcessingException if the JSON string is invalid with respect to RemediatingAction
   */
  public static RemediatingAction fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, RemediatingAction.class);
  }

  /**
   * Convert an instance of RemediatingAction to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
