/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** Agency */
@JsonPropertyOrder({Agency.JSON_PROPERTY_INVOICE_NUMBER, Agency.JSON_PROPERTY_PLAN_NAME})
public class Agency {
  public static final String JSON_PROPERTY_INVOICE_NUMBER = "invoiceNumber";
  private String invoiceNumber;

  public static final String JSON_PROPERTY_PLAN_NAME = "planName";
  private String planName;

  public Agency() {}

  /**
   * The reference number for the invoice, issued by the agency. * Encoding: ASCII * minLength: 1
   * character * maxLength: 6 characters
   *
   * @param invoiceNumber The reference number for the invoice, issued by the agency. * Encoding:
   *     ASCII * minLength: 1 character * maxLength: 6 characters
   * @return the current {@code Agency} instance, allowing for method chaining
   */
  public Agency invoiceNumber(String invoiceNumber) {
    this.invoiceNumber = invoiceNumber;
    return this;
  }

  /**
   * The reference number for the invoice, issued by the agency. * Encoding: ASCII * minLength: 1
   * character * maxLength: 6 characters
   *
   * @return invoiceNumber The reference number for the invoice, issued by the agency. * Encoding:
   *     ASCII * minLength: 1 character * maxLength: 6 characters
   */
  @JsonProperty(JSON_PROPERTY_INVOICE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getInvoiceNumber() {
    return invoiceNumber;
  }

  /**
   * The reference number for the invoice, issued by the agency. * Encoding: ASCII * minLength: 1
   * character * maxLength: 6 characters
   *
   * @param invoiceNumber The reference number for the invoice, issued by the agency. * Encoding:
   *     ASCII * minLength: 1 character * maxLength: 6 characters
   */
  @JsonProperty(JSON_PROPERTY_INVOICE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvoiceNumber(String invoiceNumber) {
    this.invoiceNumber = invoiceNumber;
  }

  /**
   * The two-letter agency plan identifier. * Encoding: ASCII * minLength: 2 characters * maxLength:
   * 2 characters
   *
   * @param planName The two-letter agency plan identifier. * Encoding: ASCII * minLength: 2
   *     characters * maxLength: 2 characters
   * @return the current {@code Agency} instance, allowing for method chaining
   */
  public Agency planName(String planName) {
    this.planName = planName;
    return this;
  }

  /**
   * The two-letter agency plan identifier. * Encoding: ASCII * minLength: 2 characters * maxLength:
   * 2 characters
   *
   * @return planName The two-letter agency plan identifier. * Encoding: ASCII * minLength: 2
   *     characters * maxLength: 2 characters
   */
  @JsonProperty(JSON_PROPERTY_PLAN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPlanName() {
    return planName;
  }

  /**
   * The two-letter agency plan identifier. * Encoding: ASCII * minLength: 2 characters * maxLength:
   * 2 characters
   *
   * @param planName The two-letter agency plan identifier. * Encoding: ASCII * minLength: 2
   *     characters * maxLength: 2 characters
   */
  @JsonProperty(JSON_PROPERTY_PLAN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlanName(String planName) {
    this.planName = planName;
  }

  /** Return true if this Agency object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Agency agency = (Agency) o;
    return Objects.equals(this.invoiceNumber, agency.invoiceNumber)
        && Objects.equals(this.planName, agency.planName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceNumber, planName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Agency {\n");
    sb.append("    invoiceNumber: ").append(toIndentedString(invoiceNumber)).append("\n");
    sb.append("    planName: ").append(toIndentedString(planName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Agency given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Agency
   * @throws JsonProcessingException if the JSON string is invalid with respect to Agency
   */
  public static Agency fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Agency.class);
  }

  /**
   * Convert an instance of Agency to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
