/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Airline */
@JsonPropertyOrder({
  Airline.JSON_PROPERTY_AGENCY,
  Airline.JSON_PROPERTY_BOARDING_FEE,
  Airline.JSON_PROPERTY_CODE,
  Airline.JSON_PROPERTY_COMPUTERIZED_RESERVATION_SYSTEM,
  Airline.JSON_PROPERTY_CUSTOMER_REFERENCE_NUMBER,
  Airline.JSON_PROPERTY_DESIGNATOR_CODE,
  Airline.JSON_PROPERTY_DOCUMENT_TYPE,
  Airline.JSON_PROPERTY_FLIGHT_DATE,
  Airline.JSON_PROPERTY_LEGS,
  Airline.JSON_PROPERTY_PASSENGER_NAME,
  Airline.JSON_PROPERTY_PASSENGERS,
  Airline.JSON_PROPERTY_TICKET,
  Airline.JSON_PROPERTY_TRAVEL_AGENCY
})
public class Airline {
  public static final String JSON_PROPERTY_AGENCY = "agency";
  private Agency agency;

  public static final String JSON_PROPERTY_BOARDING_FEE = "boardingFee";
  private Long boardingFee;

  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_COMPUTERIZED_RESERVATION_SYSTEM =
      "computerizedReservationSystem";
  private String computerizedReservationSystem;

  public static final String JSON_PROPERTY_CUSTOMER_REFERENCE_NUMBER = "customerReferenceNumber";
  private String customerReferenceNumber;

  public static final String JSON_PROPERTY_DESIGNATOR_CODE = "designatorCode";
  private String designatorCode;

  public static final String JSON_PROPERTY_DOCUMENT_TYPE = "documentType";
  private String documentType;

  public static final String JSON_PROPERTY_FLIGHT_DATE = "flightDate";
  private OffsetDateTime flightDate;

  public static final String JSON_PROPERTY_LEGS = "legs";
  private List<Leg> legs;

  public static final String JSON_PROPERTY_PASSENGER_NAME = "passengerName";
  private String passengerName;

  public static final String JSON_PROPERTY_PASSENGERS = "passengers";
  private List<Passenger> passengers;

  public static final String JSON_PROPERTY_TICKET = "ticket";
  private Ticket ticket;

  public static final String JSON_PROPERTY_TRAVEL_AGENCY = "travelAgency";
  private TravelAgency travelAgency;

  public Airline() {}

  /**
   * agency
   *
   * @param agency
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline agency(Agency agency) {
    this.agency = agency;
    return this;
  }

  /**
   * Get agency
   *
   * @return agency
   */
  @JsonProperty(JSON_PROPERTY_AGENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Agency getAgency() {
    return agency;
  }

  /**
   * agency
   *
   * @param agency
   */
  @JsonProperty(JSON_PROPERTY_AGENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgency(Agency agency) {
    this.agency = agency;
  }

  /**
   * The amount charged for boarding the plane, in [minor
   * units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric *
   * minLength: 1 character * maxLength: 11 characters
   *
   * @param boardingFee The amount charged for boarding the plane, in [minor
   *     units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric *
   *     minLength: 1 character * maxLength: 11 characters
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline boardingFee(Long boardingFee) {
    this.boardingFee = boardingFee;
    return this;
  }

  /**
   * The amount charged for boarding the plane, in [minor
   * units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric *
   * minLength: 1 character * maxLength: 11 characters
   *
   * @return boardingFee The amount charged for boarding the plane, in [minor
   *     units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric *
   *     minLength: 1 character * maxLength: 11 characters
   */
  @JsonProperty(JSON_PROPERTY_BOARDING_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getBoardingFee() {
    return boardingFee;
  }

  /**
   * The amount charged for boarding the plane, in [minor
   * units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric *
   * minLength: 1 character * maxLength: 11 characters
   *
   * @param boardingFee The amount charged for boarding the plane, in [minor
   *     units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric *
   *     minLength: 1 character * maxLength: 11 characters
   */
  @JsonProperty(JSON_PROPERTY_BOARDING_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBoardingFee(Long boardingFee) {
    this.boardingFee = boardingFee;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-digit accounting code (PAX) that
   * identifies the carrier. * Format: IATA 3-digit accounting code (PAX) * Example: KLM &#x3D; 074
   * * minLength: 3 characters * maxLength: 3 characters * Must not start with a space or be all
   * spaces. * Must not be all zeros.
   *
   * @param code The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-digit accounting code
   *     (PAX) that identifies the carrier. * Format: IATA 3-digit accounting code (PAX) * Example:
   *     KLM &#x3D; 074 * minLength: 3 characters * maxLength: 3 characters * Must not start with a
   *     space or be all spaces. * Must not be all zeros.
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline code(String code) {
    this.code = code;
    return this;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-digit accounting code (PAX) that
   * identifies the carrier. * Format: IATA 3-digit accounting code (PAX) * Example: KLM &#x3D; 074
   * * minLength: 3 characters * maxLength: 3 characters * Must not start with a space or be all
   * spaces. * Must not be all zeros.
   *
   * @return code The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-digit accounting code
   *     (PAX) that identifies the carrier. * Format: IATA 3-digit accounting code (PAX) * Example:
   *     KLM &#x3D; 074 * minLength: 3 characters * maxLength: 3 characters * Must not start with a
   *     space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCode() {
    return code;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-digit accounting code (PAX) that
   * identifies the carrier. * Format: IATA 3-digit accounting code (PAX) * Example: KLM &#x3D; 074
   * * minLength: 3 characters * maxLength: 3 characters * Must not start with a space or be all
   * spaces. * Must not be all zeros.
   *
   * @param code The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-digit accounting code
   *     (PAX) that identifies the carrier. * Format: IATA 3-digit accounting code (PAX) * Example:
   *     KLM &#x3D; 074 * minLength: 3 characters * maxLength: 3 characters * Must not start with a
   *     space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }

  /**
   * The [CRS](https://en.wikipedia.org/wiki/Computer_reservation_system) used to make the
   * reservation and purchase the ticket. * Encoding: ASCII * minLength: 4 characters * maxLength: 4
   * characters
   *
   * @param computerizedReservationSystem The
   *     [CRS](https://en.wikipedia.org/wiki/Computer_reservation_system) used to make the
   *     reservation and purchase the ticket. * Encoding: ASCII * minLength: 4 characters *
   *     maxLength: 4 characters
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline computerizedReservationSystem(String computerizedReservationSystem) {
    this.computerizedReservationSystem = computerizedReservationSystem;
    return this;
  }

  /**
   * The [CRS](https://en.wikipedia.org/wiki/Computer_reservation_system) used to make the
   * reservation and purchase the ticket. * Encoding: ASCII * minLength: 4 characters * maxLength: 4
   * characters
   *
   * @return computerizedReservationSystem The
   *     [CRS](https://en.wikipedia.org/wiki/Computer_reservation_system) used to make the
   *     reservation and purchase the ticket. * Encoding: ASCII * minLength: 4 characters *
   *     maxLength: 4 characters
   */
  @JsonProperty(JSON_PROPERTY_COMPUTERIZED_RESERVATION_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getComputerizedReservationSystem() {
    return computerizedReservationSystem;
  }

  /**
   * The [CRS](https://en.wikipedia.org/wiki/Computer_reservation_system) used to make the
   * reservation and purchase the ticket. * Encoding: ASCII * minLength: 4 characters * maxLength: 4
   * characters
   *
   * @param computerizedReservationSystem The
   *     [CRS](https://en.wikipedia.org/wiki/Computer_reservation_system) used to make the
   *     reservation and purchase the ticket. * Encoding: ASCII * minLength: 4 characters *
   *     maxLength: 4 characters
   */
  @JsonProperty(JSON_PROPERTY_COMPUTERIZED_RESERVATION_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComputerizedReservationSystem(String computerizedReservationSystem) {
    this.computerizedReservationSystem = computerizedReservationSystem;
  }

  /**
   * The alphanumeric customer reference number. * Encoding: ASCII * maxLength: 20 characters * If
   * you send more than 20 characters, the customer reference number is truncated * Must not start
   * with a space or be all spaces.
   *
   * @param customerReferenceNumber The alphanumeric customer reference number. * Encoding: ASCII *
   *     maxLength: 20 characters * If you send more than 20 characters, the customer reference
   *     number is truncated * Must not start with a space or be all spaces.
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline customerReferenceNumber(String customerReferenceNumber) {
    this.customerReferenceNumber = customerReferenceNumber;
    return this;
  }

  /**
   * The alphanumeric customer reference number. * Encoding: ASCII * maxLength: 20 characters * If
   * you send more than 20 characters, the customer reference number is truncated * Must not start
   * with a space or be all spaces.
   *
   * @return customerReferenceNumber The alphanumeric customer reference number. * Encoding: ASCII *
   *     maxLength: 20 characters * If you send more than 20 characters, the customer reference
   *     number is truncated * Must not start with a space or be all spaces.
   */
  @JsonProperty(JSON_PROPERTY_CUSTOMER_REFERENCE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCustomerReferenceNumber() {
    return customerReferenceNumber;
  }

  /**
   * The alphanumeric customer reference number. * Encoding: ASCII * maxLength: 20 characters * If
   * you send more than 20 characters, the customer reference number is truncated * Must not start
   * with a space or be all spaces.
   *
   * @param customerReferenceNumber The alphanumeric customer reference number. * Encoding: ASCII *
   *     maxLength: 20 characters * If you send more than 20 characters, the customer reference
   *     number is truncated * Must not start with a space or be all spaces.
   */
  @JsonProperty(JSON_PROPERTY_CUSTOMER_REFERENCE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerReferenceNumber(String customerReferenceNumber) {
    this.customerReferenceNumber = customerReferenceNumber;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter accounting code (PAX) that
   * identifies the carrier. * Encoding: ASCII * Example: KLM &#x3D; KL * minLength: 2 characters *
   * maxLength: 2 characters * Must not start with a space or be all spaces.
   *
   * @param designatorCode The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter
   *     accounting code (PAX) that identifies the carrier. * Encoding: ASCII * Example: KLM &#x3D;
   *     KL * minLength: 2 characters * maxLength: 2 characters * Must not start with a space or be
   *     all spaces.
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline designatorCode(String designatorCode) {
    this.designatorCode = designatorCode;
    return this;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter accounting code (PAX) that
   * identifies the carrier. * Encoding: ASCII * Example: KLM &#x3D; KL * minLength: 2 characters *
   * maxLength: 2 characters * Must not start with a space or be all spaces.
   *
   * @return designatorCode The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter
   *     accounting code (PAX) that identifies the carrier. * Encoding: ASCII * Example: KLM &#x3D;
   *     KL * minLength: 2 characters * maxLength: 2 characters * Must not start with a space or be
   *     all spaces.
   */
  @JsonProperty(JSON_PROPERTY_DESIGNATOR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDesignatorCode() {
    return designatorCode;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter accounting code (PAX) that
   * identifies the carrier. * Encoding: ASCII * Example: KLM &#x3D; KL * minLength: 2 characters *
   * maxLength: 2 characters * Must not start with a space or be all spaces.
   *
   * @param designatorCode The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter
   *     accounting code (PAX) that identifies the carrier. * Encoding: ASCII * Example: KLM &#x3D;
   *     KL * minLength: 2 characters * maxLength: 2 characters * Must not start with a space or be
   *     all spaces.
   */
  @JsonProperty(JSON_PROPERTY_DESIGNATOR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDesignatorCode(String designatorCode) {
    this.designatorCode = designatorCode;
  }

  /**
   * A code that identifies the type of item bought. The description of the code can appear on
   * credit card statements. * Encoding: ASCII * Example: Passenger ticket &#x3D; 01 * minLength: 2
   * characters * maxLength: 2 characters
   *
   * @param documentType A code that identifies the type of item bought. The description of the code
   *     can appear on credit card statements. * Encoding: ASCII * Example: Passenger ticket &#x3D;
   *     01 * minLength: 2 characters * maxLength: 2 characters
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline documentType(String documentType) {
    this.documentType = documentType;
    return this;
  }

  /**
   * A code that identifies the type of item bought. The description of the code can appear on
   * credit card statements. * Encoding: ASCII * Example: Passenger ticket &#x3D; 01 * minLength: 2
   * characters * maxLength: 2 characters
   *
   * @return documentType A code that identifies the type of item bought. The description of the
   *     code can appear on credit card statements. * Encoding: ASCII * Example: Passenger ticket
   *     &#x3D; 01 * minLength: 2 characters * maxLength: 2 characters
   */
  @JsonProperty(JSON_PROPERTY_DOCUMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDocumentType() {
    return documentType;
  }

  /**
   * A code that identifies the type of item bought. The description of the code can appear on
   * credit card statements. * Encoding: ASCII * Example: Passenger ticket &#x3D; 01 * minLength: 2
   * characters * maxLength: 2 characters
   *
   * @param documentType A code that identifies the type of item bought. The description of the code
   *     can appear on credit card statements. * Encoding: ASCII * Example: Passenger ticket &#x3D;
   *     01 * minLength: 2 characters * maxLength: 2 characters
   */
  @JsonProperty(JSON_PROPERTY_DOCUMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDocumentType(String documentType) {
    this.documentType = documentType;
  }

  /**
   * The flight departure date. Time is optional. * Format for date only: &#x60;yyyy-MM-dd&#x60; *
   * Format for date and time: &#x60;yyyy-MM-ddTHH:mm&#x60; * Use local time of departure airport. *
   * minLength: 10 characters * maxLength: 16 characters
   *
   * @param flightDate The flight departure date. Time is optional. * Format for date only:
   *     &#x60;yyyy-MM-dd&#x60; * Format for date and time: &#x60;yyyy-MM-ddTHH:mm&#x60; * Use local
   *     time of departure airport. * minLength: 10 characters * maxLength: 16 characters
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline flightDate(OffsetDateTime flightDate) {
    this.flightDate = flightDate;
    return this;
  }

  /**
   * The flight departure date. Time is optional. * Format for date only: &#x60;yyyy-MM-dd&#x60; *
   * Format for date and time: &#x60;yyyy-MM-ddTHH:mm&#x60; * Use local time of departure airport. *
   * minLength: 10 characters * maxLength: 16 characters
   *
   * @return flightDate The flight departure date. Time is optional. * Format for date only:
   *     &#x60;yyyy-MM-dd&#x60; * Format for date and time: &#x60;yyyy-MM-ddTHH:mm&#x60; * Use local
   *     time of departure airport. * minLength: 10 characters * maxLength: 16 characters
   */
  @JsonProperty(JSON_PROPERTY_FLIGHT_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getFlightDate() {
    return flightDate;
  }

  /**
   * The flight departure date. Time is optional. * Format for date only: &#x60;yyyy-MM-dd&#x60; *
   * Format for date and time: &#x60;yyyy-MM-ddTHH:mm&#x60; * Use local time of departure airport. *
   * minLength: 10 characters * maxLength: 16 characters
   *
   * @param flightDate The flight departure date. Time is optional. * Format for date only:
   *     &#x60;yyyy-MM-dd&#x60; * Format for date and time: &#x60;yyyy-MM-ddTHH:mm&#x60; * Use local
   *     time of departure airport. * minLength: 10 characters * maxLength: 16 characters
   */
  @JsonProperty(JSON_PROPERTY_FLIGHT_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlightDate(OffsetDateTime flightDate) {
    this.flightDate = flightDate;
  }

  /**
   * legs
   *
   * @param legs
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline legs(List<Leg> legs) {
    this.legs = legs;
    return this;
  }

  public Airline addLegsItem(Leg legsItem) {
    if (this.legs == null) {
      this.legs = new ArrayList<>();
    }
    this.legs.add(legsItem);
    return this;
  }

  /**
   * Get legs
   *
   * @return legs
   */
  @JsonProperty(JSON_PROPERTY_LEGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Leg> getLegs() {
    return legs;
  }

  /**
   * legs
   *
   * @param legs
   */
  @JsonProperty(JSON_PROPERTY_LEGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegs(List<Leg> legs) {
    this.legs = legs;
  }

  /**
   * The passenger&#39;s name, initials, and title. * Format: last name + first name or initials +
   * title * Example: *FLYER / MARY MS* * minLength: 1 character * maxLength: 20 characters * If you
   * send more than 20 characters, the name is truncated * Must not start with a space or be all
   * spaces. * Must not be all zeros.
   *
   * @param passengerName The passenger&#39;s name, initials, and title. * Format: last name + first
   *     name or initials + title * Example: *FLYER / MARY MS* * minLength: 1 character * maxLength:
   *     20 characters * If you send more than 20 characters, the name is truncated * Must not start
   *     with a space or be all spaces. * Must not be all zeros.
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline passengerName(String passengerName) {
    this.passengerName = passengerName;
    return this;
  }

  /**
   * The passenger&#39;s name, initials, and title. * Format: last name + first name or initials +
   * title * Example: *FLYER / MARY MS* * minLength: 1 character * maxLength: 20 characters * If you
   * send more than 20 characters, the name is truncated * Must not start with a space or be all
   * spaces. * Must not be all zeros.
   *
   * @return passengerName The passenger&#39;s name, initials, and title. * Format: last name +
   *     first name or initials + title * Example: *FLYER / MARY MS* * minLength: 1 character *
   *     maxLength: 20 characters * If you send more than 20 characters, the name is truncated *
   *     Must not start with a space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_PASSENGER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPassengerName() {
    return passengerName;
  }

  /**
   * The passenger&#39;s name, initials, and title. * Format: last name + first name or initials +
   * title * Example: *FLYER / MARY MS* * minLength: 1 character * maxLength: 20 characters * If you
   * send more than 20 characters, the name is truncated * Must not start with a space or be all
   * spaces. * Must not be all zeros.
   *
   * @param passengerName The passenger&#39;s name, initials, and title. * Format: last name + first
   *     name or initials + title * Example: *FLYER / MARY MS* * minLength: 1 character * maxLength:
   *     20 characters * If you send more than 20 characters, the name is truncated * Must not start
   *     with a space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_PASSENGER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengerName(String passengerName) {
    this.passengerName = passengerName;
  }

  /**
   * passengers
   *
   * @param passengers
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline passengers(List<Passenger> passengers) {
    this.passengers = passengers;
    return this;
  }

  public Airline addPassengersItem(Passenger passengersItem) {
    if (this.passengers == null) {
      this.passengers = new ArrayList<>();
    }
    this.passengers.add(passengersItem);
    return this;
  }

  /**
   * Get passengers
   *
   * @return passengers
   */
  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Passenger> getPassengers() {
    return passengers;
  }

  /**
   * passengers
   *
   * @param passengers
   */
  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengers(List<Passenger> passengers) {
    this.passengers = passengers;
  }

  /**
   * ticket
   *
   * @param ticket
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline ticket(Ticket ticket) {
    this.ticket = ticket;
    return this;
  }

  /**
   * Get ticket
   *
   * @return ticket
   */
  @JsonProperty(JSON_PROPERTY_TICKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Ticket getTicket() {
    return ticket;
  }

  /**
   * ticket
   *
   * @param ticket
   */
  @JsonProperty(JSON_PROPERTY_TICKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTicket(Ticket ticket) {
    this.ticket = ticket;
  }

  /**
   * travelAgency
   *
   * @param travelAgency
   * @return the current {@code Airline} instance, allowing for method chaining
   */
  public Airline travelAgency(TravelAgency travelAgency) {
    this.travelAgency = travelAgency;
    return this;
  }

  /**
   * Get travelAgency
   *
   * @return travelAgency
   */
  @JsonProperty(JSON_PROPERTY_TRAVEL_AGENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TravelAgency getTravelAgency() {
    return travelAgency;
  }

  /**
   * travelAgency
   *
   * @param travelAgency
   */
  @JsonProperty(JSON_PROPERTY_TRAVEL_AGENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTravelAgency(TravelAgency travelAgency) {
    this.travelAgency = travelAgency;
  }

  /** Return true if this Airline object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Airline airline = (Airline) o;
    return Objects.equals(this.agency, airline.agency)
        && Objects.equals(this.boardingFee, airline.boardingFee)
        && Objects.equals(this.code, airline.code)
        && Objects.equals(this.computerizedReservationSystem, airline.computerizedReservationSystem)
        && Objects.equals(this.customerReferenceNumber, airline.customerReferenceNumber)
        && Objects.equals(this.designatorCode, airline.designatorCode)
        && Objects.equals(this.documentType, airline.documentType)
        && Objects.equals(this.flightDate, airline.flightDate)
        && Objects.equals(this.legs, airline.legs)
        && Objects.equals(this.passengerName, airline.passengerName)
        && Objects.equals(this.passengers, airline.passengers)
        && Objects.equals(this.ticket, airline.ticket)
        && Objects.equals(this.travelAgency, airline.travelAgency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        agency,
        boardingFee,
        code,
        computerizedReservationSystem,
        customerReferenceNumber,
        designatorCode,
        documentType,
        flightDate,
        legs,
        passengerName,
        passengers,
        ticket,
        travelAgency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Airline {\n");
    sb.append("    agency: ").append(toIndentedString(agency)).append("\n");
    sb.append("    boardingFee: ").append(toIndentedString(boardingFee)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    computerizedReservationSystem: ")
        .append(toIndentedString(computerizedReservationSystem))
        .append("\n");
    sb.append("    customerReferenceNumber: ")
        .append(toIndentedString(customerReferenceNumber))
        .append("\n");
    sb.append("    designatorCode: ").append(toIndentedString(designatorCode)).append("\n");
    sb.append("    documentType: ").append(toIndentedString(documentType)).append("\n");
    sb.append("    flightDate: ").append(toIndentedString(flightDate)).append("\n");
    sb.append("    legs: ").append(toIndentedString(legs)).append("\n");
    sb.append("    passengerName: ").append(toIndentedString(passengerName)).append("\n");
    sb.append("    passengers: ").append(toIndentedString(passengers)).append("\n");
    sb.append("    ticket: ").append(toIndentedString(ticket)).append("\n");
    sb.append("    travelAgency: ").append(toIndentedString(travelAgency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Airline given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Airline
   * @throws JsonProcessingException if the JSON string is invalid with respect to Airline
   */
  public static Airline fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Airline.class);
  }

  /**
   * Convert an instance of Airline to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
