/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** CheckoutDelegatedAuthenticationAction */
@JsonPropertyOrder({
  CheckoutDelegatedAuthenticationAction.JSON_PROPERTY_AUTHORISATION_TOKEN,
  CheckoutDelegatedAuthenticationAction.JSON_PROPERTY_PAYMENT_DATA,
  CheckoutDelegatedAuthenticationAction.JSON_PROPERTY_PAYMENT_METHOD_TYPE,
  CheckoutDelegatedAuthenticationAction.JSON_PROPERTY_TOKEN,
  CheckoutDelegatedAuthenticationAction.JSON_PROPERTY_TYPE,
  CheckoutDelegatedAuthenticationAction.JSON_PROPERTY_URL
})
public class CheckoutDelegatedAuthenticationAction {
  public static final String JSON_PROPERTY_AUTHORISATION_TOKEN = "authorisationToken";
  private String authorisationToken;

  public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
  private String paymentData;

  public static final String JSON_PROPERTY_PAYMENT_METHOD_TYPE = "paymentMethodType";
  private String paymentMethodType;

  public static final String JSON_PROPERTY_TOKEN = "token";
  private String token;

  /** **delegatedAuthentication** */
  public enum TypeEnum {
    DELEGATEDAUTHENTICATION(String.valueOf("delegatedAuthentication"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public CheckoutDelegatedAuthenticationAction() {}

  /**
   * A token needed to authorise a payment.
   *
   * @param authorisationToken A token needed to authorise a payment.
   * @return the current {@code CheckoutDelegatedAuthenticationAction} instance, allowing for method
   *     chaining
   */
  public CheckoutDelegatedAuthenticationAction authorisationToken(String authorisationToken) {
    this.authorisationToken = authorisationToken;
    return this;
  }

  /**
   * A token needed to authorise a payment.
   *
   * @return authorisationToken A token needed to authorise a payment.
   */
  @JsonProperty(JSON_PROPERTY_AUTHORISATION_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAuthorisationToken() {
    return authorisationToken;
  }

  /**
   * A token needed to authorise a payment.
   *
   * @param authorisationToken A token needed to authorise a payment.
   */
  @JsonProperty(JSON_PROPERTY_AUTHORISATION_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthorisationToken(String authorisationToken) {
    this.authorisationToken = authorisationToken;
  }

  /**
   * Encoded payment data.
   *
   * @param paymentData Encoded payment data.
   * @return the current {@code CheckoutDelegatedAuthenticationAction} instance, allowing for method
   *     chaining
   */
  public CheckoutDelegatedAuthenticationAction paymentData(String paymentData) {
    this.paymentData = paymentData;
    return this;
  }

  /**
   * Encoded payment data.
   *
   * @return paymentData Encoded payment data.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentData() {
    return paymentData;
  }

  /**
   * Encoded payment data.
   *
   * @param paymentData Encoded payment data.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentData(String paymentData) {
    this.paymentData = paymentData;
  }

  /**
   * Specifies the payment method.
   *
   * @param paymentMethodType Specifies the payment method.
   * @return the current {@code CheckoutDelegatedAuthenticationAction} instance, allowing for method
   *     chaining
   */
  public CheckoutDelegatedAuthenticationAction paymentMethodType(String paymentMethodType) {
    this.paymentMethodType = paymentMethodType;
    return this;
  }

  /**
   * Specifies the payment method.
   *
   * @return paymentMethodType Specifies the payment method.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentMethodType() {
    return paymentMethodType;
  }

  /**
   * Specifies the payment method.
   *
   * @param paymentMethodType Specifies the payment method.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethodType(String paymentMethodType) {
    this.paymentMethodType = paymentMethodType;
  }

  /**
   * A token to pass to the delegatedAuthentication component.
   *
   * @param token A token to pass to the delegatedAuthentication component.
   * @return the current {@code CheckoutDelegatedAuthenticationAction} instance, allowing for method
   *     chaining
   */
  public CheckoutDelegatedAuthenticationAction token(String token) {
    this.token = token;
    return this;
  }

  /**
   * A token to pass to the delegatedAuthentication component.
   *
   * @return token A token to pass to the delegatedAuthentication component.
   */
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getToken() {
    return token;
  }

  /**
   * A token to pass to the delegatedAuthentication component.
   *
   * @param token A token to pass to the delegatedAuthentication component.
   */
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToken(String token) {
    this.token = token;
  }

  /**
   * **delegatedAuthentication**
   *
   * @param type **delegatedAuthentication**
   * @return the current {@code CheckoutDelegatedAuthenticationAction} instance, allowing for method
   *     chaining
   */
  public CheckoutDelegatedAuthenticationAction type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **delegatedAuthentication**
   *
   * @return type **delegatedAuthentication**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **delegatedAuthentication**
   *
   * @param type **delegatedAuthentication**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Specifies the URL to redirect to.
   *
   * @param url Specifies the URL to redirect to.
   * @return the current {@code CheckoutDelegatedAuthenticationAction} instance, allowing for method
   *     chaining
   */
  public CheckoutDelegatedAuthenticationAction url(String url) {
    this.url = url;
    return this;
  }

  /**
   * Specifies the URL to redirect to.
   *
   * @return url Specifies the URL to redirect to.
   */
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUrl() {
    return url;
  }

  /**
   * Specifies the URL to redirect to.
   *
   * @param url Specifies the URL to redirect to.
   */
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrl(String url) {
    this.url = url;
  }

  /** Return true if this CheckoutDelegatedAuthenticationAction object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CheckoutDelegatedAuthenticationAction checkoutDelegatedAuthenticationAction =
        (CheckoutDelegatedAuthenticationAction) o;
    return Objects.equals(
            this.authorisationToken, checkoutDelegatedAuthenticationAction.authorisationToken)
        && Objects.equals(this.paymentData, checkoutDelegatedAuthenticationAction.paymentData)
        && Objects.equals(
            this.paymentMethodType, checkoutDelegatedAuthenticationAction.paymentMethodType)
        && Objects.equals(this.token, checkoutDelegatedAuthenticationAction.token)
        && Objects.equals(this.type, checkoutDelegatedAuthenticationAction.type)
        && Objects.equals(this.url, checkoutDelegatedAuthenticationAction.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authorisationToken, paymentData, paymentMethodType, token, type, url);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CheckoutDelegatedAuthenticationAction {\n");
    sb.append("    authorisationToken: ").append(toIndentedString(authorisationToken)).append("\n");
    sb.append("    paymentData: ").append(toIndentedString(paymentData)).append("\n");
    sb.append("    paymentMethodType: ").append(toIndentedString(paymentMethodType)).append("\n");
    sb.append("    token: ").append(toIndentedString(token)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of CheckoutDelegatedAuthenticationAction given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CheckoutDelegatedAuthenticationAction
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     CheckoutDelegatedAuthenticationAction
   */
  public static CheckoutDelegatedAuthenticationAction fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CheckoutDelegatedAuthenticationAction.class);
  }

  /**
   * Convert an instance of CheckoutDelegatedAuthenticationAction to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
