/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Donation */
@JsonPropertyOrder({
  Donation.JSON_PROPERTY_CURRENCY,
  Donation.JSON_PROPERTY_DONATION_TYPE,
  Donation.JSON_PROPERTY_MAX_ROUNDUP_AMOUNT,
  Donation.JSON_PROPERTY_TYPE,
  Donation.JSON_PROPERTY_VALUES
})
public class Donation {
  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_DONATION_TYPE = "donationType";
  private String donationType;

  public static final String JSON_PROPERTY_MAX_ROUNDUP_AMOUNT = "maxRoundupAmount";
  private Long maxRoundupAmount;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_VALUES = "values";
  private List<Long> values;

  public Donation() {}

  /**
   * The three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes/).
   *
   * @param currency The three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes/).
   * @return the current {@code Donation} instance, allowing for method chaining
   */
  public Donation currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * The three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes/).
   *
   * @return currency The three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes/).
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCurrency() {
    return currency;
  }

  /**
   * The three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes/).
   *
   * @param currency The three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes/).
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }

  /**
   * The [type of donation](https://docs.adyen.com/online-payments/donations/#donation-types).
   * Possible values: * **roundup**: a donation where the original transaction amount is rounded up
   * as a donation. * **fixedAmounts**: a donation where you show fixed donations amounts that the
   * shopper can select from.
   *
   * @param donationType The [type of
   *     donation](https://docs.adyen.com/online-payments/donations/#donation-types). Possible
   *     values: * **roundup**: a donation where the original transaction amount is rounded up as a
   *     donation. * **fixedAmounts**: a donation where you show fixed donations amounts that the
   *     shopper can select from.
   * @return the current {@code Donation} instance, allowing for method chaining
   */
  public Donation donationType(String donationType) {
    this.donationType = donationType;
    return this;
  }

  /**
   * The [type of donation](https://docs.adyen.com/online-payments/donations/#donation-types).
   * Possible values: * **roundup**: a donation where the original transaction amount is rounded up
   * as a donation. * **fixedAmounts**: a donation where you show fixed donations amounts that the
   * shopper can select from.
   *
   * @return donationType The [type of
   *     donation](https://docs.adyen.com/online-payments/donations/#donation-types). Possible
   *     values: * **roundup**: a donation where the original transaction amount is rounded up as a
   *     donation. * **fixedAmounts**: a donation where you show fixed donations amounts that the
   *     shopper can select from.
   */
  @JsonProperty(JSON_PROPERTY_DONATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDonationType() {
    return donationType;
  }

  /**
   * The [type of donation](https://docs.adyen.com/online-payments/donations/#donation-types).
   * Possible values: * **roundup**: a donation where the original transaction amount is rounded up
   * as a donation. * **fixedAmounts**: a donation where you show fixed donations amounts that the
   * shopper can select from.
   *
   * @param donationType The [type of
   *     donation](https://docs.adyen.com/online-payments/donations/#donation-types). Possible
   *     values: * **roundup**: a donation where the original transaction amount is rounded up as a
   *     donation. * **fixedAmounts**: a donation where you show fixed donations amounts that the
   *     shopper can select from.
   */
  @JsonProperty(JSON_PROPERTY_DONATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDonationType(String donationType) {
    this.donationType = donationType;
  }

  /**
   * The maximum amount a transaction can be rounded up to make a donation. This field is only
   * present when &#x60;donationType&#x60; is **roundup**.
   *
   * @param maxRoundupAmount The maximum amount a transaction can be rounded up to make a donation.
   *     This field is only present when &#x60;donationType&#x60; is **roundup**.
   * @return the current {@code Donation} instance, allowing for method chaining
   */
  public Donation maxRoundupAmount(Long maxRoundupAmount) {
    this.maxRoundupAmount = maxRoundupAmount;
    return this;
  }

  /**
   * The maximum amount a transaction can be rounded up to make a donation. This field is only
   * present when &#x60;donationType&#x60; is **roundup**.
   *
   * @return maxRoundupAmount The maximum amount a transaction can be rounded up to make a donation.
   *     This field is only present when &#x60;donationType&#x60; is **roundup**.
   */
  @JsonProperty(JSON_PROPERTY_MAX_ROUNDUP_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getMaxRoundupAmount() {
    return maxRoundupAmount;
  }

  /**
   * The maximum amount a transaction can be rounded up to make a donation. This field is only
   * present when &#x60;donationType&#x60; is **roundup**.
   *
   * @param maxRoundupAmount The maximum amount a transaction can be rounded up to make a donation.
   *     This field is only present when &#x60;donationType&#x60; is **roundup**.
   */
  @JsonProperty(JSON_PROPERTY_MAX_ROUNDUP_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRoundupAmount(Long maxRoundupAmount) {
    this.maxRoundupAmount = maxRoundupAmount;
  }

  /**
   * The [type of donation](https://docs.adyen.com/online-payments/donations/#donation-types).
   * Possible values: * **roundup**: a donation where the original transaction amount is rounded up
   * as a donation. * **fixedAmounts**: a donation where you show fixed donation amounts that the
   * shopper can select from.
   *
   * @param type The [type of
   *     donation](https://docs.adyen.com/online-payments/donations/#donation-types). Possible
   *     values: * **roundup**: a donation where the original transaction amount is rounded up as a
   *     donation. * **fixedAmounts**: a donation where you show fixed donation amounts that the
   *     shopper can select from.
   * @return the current {@code Donation} instance, allowing for method chaining
   */
  public Donation type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The [type of donation](https://docs.adyen.com/online-payments/donations/#donation-types).
   * Possible values: * **roundup**: a donation where the original transaction amount is rounded up
   * as a donation. * **fixedAmounts**: a donation where you show fixed donation amounts that the
   * shopper can select from.
   *
   * @return type The [type of
   *     donation](https://docs.adyen.com/online-payments/donations/#donation-types). Possible
   *     values: * **roundup**: a donation where the original transaction amount is rounded up as a
   *     donation. * **fixedAmounts**: a donation where you show fixed donation amounts that the
   *     shopper can select from.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * The [type of donation](https://docs.adyen.com/online-payments/donations/#donation-types).
   * Possible values: * **roundup**: a donation where the original transaction amount is rounded up
   * as a donation. * **fixedAmounts**: a donation where you show fixed donation amounts that the
   * shopper can select from.
   *
   * @param type The [type of
   *     donation](https://docs.adyen.com/online-payments/donations/#donation-types). Possible
   *     values: * **roundup**: a donation where the original transaction amount is rounded up as a
   *     donation. * **fixedAmounts**: a donation where you show fixed donation amounts that the
   *     shopper can select from.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  /**
   * The fixed donation amounts in [minor
   * units](https://docs.adyen.com/development-resources/currency-codes//#minor-units). This field
   * is only present when &#x60;donationType&#x60; is **fixedAmounts**.
   *
   * @param values The fixed donation amounts in [minor
   *     units](https://docs.adyen.com/development-resources/currency-codes//#minor-units). This
   *     field is only present when &#x60;donationType&#x60; is **fixedAmounts**.
   * @return the current {@code Donation} instance, allowing for method chaining
   */
  public Donation values(List<Long> values) {
    this.values = values;
    return this;
  }

  public Donation addValuesItem(Long valuesItem) {
    if (this.values == null) {
      this.values = new ArrayList<>();
    }
    this.values.add(valuesItem);
    return this;
  }

  /**
   * The fixed donation amounts in [minor
   * units](https://docs.adyen.com/development-resources/currency-codes//#minor-units). This field
   * is only present when &#x60;donationType&#x60; is **fixedAmounts**.
   *
   * @return values The fixed donation amounts in [minor
   *     units](https://docs.adyen.com/development-resources/currency-codes//#minor-units). This
   *     field is only present when &#x60;donationType&#x60; is **fixedAmounts**.
   */
  @JsonProperty(JSON_PROPERTY_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Long> getValues() {
    return values;
  }

  /**
   * The fixed donation amounts in [minor
   * units](https://docs.adyen.com/development-resources/currency-codes//#minor-units). This field
   * is only present when &#x60;donationType&#x60; is **fixedAmounts**.
   *
   * @param values The fixed donation amounts in [minor
   *     units](https://docs.adyen.com/development-resources/currency-codes//#minor-units). This
   *     field is only present when &#x60;donationType&#x60; is **fixedAmounts**.
   */
  @JsonProperty(JSON_PROPERTY_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValues(List<Long> values) {
    this.values = values;
  }

  /** Return true if this Donation object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Donation donation = (Donation) o;
    return Objects.equals(this.currency, donation.currency)
        && Objects.equals(this.donationType, donation.donationType)
        && Objects.equals(this.maxRoundupAmount, donation.maxRoundupAmount)
        && Objects.equals(this.type, donation.type)
        && Objects.equals(this.values, donation.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currency, donationType, maxRoundupAmount, type, values);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Donation {\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    donationType: ").append(toIndentedString(donationType)).append("\n");
    sb.append("    maxRoundupAmount: ").append(toIndentedString(maxRoundupAmount)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Donation given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Donation
   * @throws JsonProcessingException if the JSON string is invalid with respect to Donation
   */
  public static Donation fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Donation.class);
  }

  /**
   * Convert an instance of Donation to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
