/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** IdealDonations */
@JsonPropertyOrder({
  IdealDonations.JSON_PROPERTY_CHECKOUT_ATTEMPT_ID,
  IdealDonations.JSON_PROPERTY_ISSUER,
  IdealDonations.JSON_PROPERTY_RECURRING_DETAIL_REFERENCE,
  IdealDonations.JSON_PROPERTY_STORED_PAYMENT_METHOD_ID,
  IdealDonations.JSON_PROPERTY_TYPE
})
public class IdealDonations {
  public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
  private String checkoutAttemptId;

  public static final String JSON_PROPERTY_ISSUER = "issuer";
  private String issuer;

  public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
  @Deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
  private String recurringDetailReference;

  public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
  private String storedPaymentMethodId;

  /** **ideal** */
  public enum TypeEnum {
    IDEAL(String.valueOf("ideal"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.IDEAL;

  public IdealDonations() {}

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId The checkout attempt identifier.
   * @return the current {@code IdealDonations} instance, allowing for method chaining
   */
  public IdealDonations checkoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
    return this;
  }

  /**
   * The checkout attempt identifier.
   *
   * @return checkoutAttemptId The checkout attempt identifier.
   */
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCheckoutAttemptId() {
    return checkoutAttemptId;
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId The checkout attempt identifier.
   */
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
  }

  /**
   * The iDEAL issuer value of the shopper&#39;s selected bank. Set this to an **id** of an iDEAL
   * issuer to preselect it.
   *
   * @param issuer The iDEAL issuer value of the shopper&#39;s selected bank. Set this to an **id**
   *     of an iDEAL issuer to preselect it.
   * @return the current {@code IdealDonations} instance, allowing for method chaining
   */
  public IdealDonations issuer(String issuer) {
    this.issuer = issuer;
    return this;
  }

  /**
   * The iDEAL issuer value of the shopper&#39;s selected bank. Set this to an **id** of an iDEAL
   * issuer to preselect it.
   *
   * @return issuer The iDEAL issuer value of the shopper&#39;s selected bank. Set this to an **id**
   *     of an iDEAL issuer to preselect it.
   */
  @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIssuer() {
    return issuer;
  }

  /**
   * The iDEAL issuer value of the shopper&#39;s selected bank. Set this to an **id** of an iDEAL
   * issuer to preselect it.
   *
   * @param issuer The iDEAL issuer value of the shopper&#39;s selected bank. Set this to an **id**
   *     of an iDEAL issuer to preselect it.
   */
  @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuer(String issuer) {
    this.issuer = issuer;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @param recurringDetailReference This is the &#x60;recurringDetailReference&#x60; returned in
   *     the response when you created the token.
   * @return the current {@code IdealDonations} instance, allowing for method chaining
   * @deprecated since Adyen Checkout API v49 Use &#x60;storedPaymentMethodId&#x60; instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
  public IdealDonations recurringDetailReference(String recurringDetailReference) {
    this.recurringDetailReference = recurringDetailReference;
    return this;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @return recurringDetailReference This is the &#x60;recurringDetailReference&#x60; returned in
   *     the response when you created the token.
   * @deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
  @JsonProperty(JSON_PROPERTY_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringDetailReference() {
    return recurringDetailReference;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @param recurringDetailReference This is the &#x60;recurringDetailReference&#x60; returned in
   *     the response when you created the token.
   * @deprecated since Adyen Checkout API v49 Use &#x60;storedPaymentMethodId&#x60; instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
  @JsonProperty(JSON_PROPERTY_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringDetailReference(String recurringDetailReference) {
    this.recurringDetailReference = recurringDetailReference;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @param storedPaymentMethodId This is the &#x60;recurringDetailReference&#x60; returned in the
   *     response when you created the token.
   * @return the current {@code IdealDonations} instance, allowing for method chaining
   */
  public IdealDonations storedPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
    return this;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @return storedPaymentMethodId This is the &#x60;recurringDetailReference&#x60; returned in the
   *     response when you created the token.
   */
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStoredPaymentMethodId() {
    return storedPaymentMethodId;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the
   * token.
   *
   * @param storedPaymentMethodId This is the &#x60;recurringDetailReference&#x60; returned in the
   *     response when you created the token.
   */
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoredPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
  }

  /**
   * **ideal**
   *
   * @param type **ideal**
   * @return the current {@code IdealDonations} instance, allowing for method chaining
   */
  public IdealDonations type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **ideal**
   *
   * @return type **ideal**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **ideal**
   *
   * @param type **ideal**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this IdealDonations object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IdealDonations idealDonations = (IdealDonations) o;
    return Objects.equals(this.checkoutAttemptId, idealDonations.checkoutAttemptId)
        && Objects.equals(this.issuer, idealDonations.issuer)
        && Objects.equals(this.recurringDetailReference, idealDonations.recurringDetailReference)
        && Objects.equals(this.storedPaymentMethodId, idealDonations.storedPaymentMethodId)
        && Objects.equals(this.type, idealDonations.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        checkoutAttemptId, issuer, recurringDetailReference, storedPaymentMethodId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IdealDonations {\n");
    sb.append("    checkoutAttemptId: ").append(toIndentedString(checkoutAttemptId)).append("\n");
    sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
    sb.append("    recurringDetailReference: ")
        .append(toIndentedString(recurringDetailReference))
        .append("\n");
    sb.append("    storedPaymentMethodId: ")
        .append(toIndentedString(storedPaymentMethodId))
        .append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of IdealDonations given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of IdealDonations
   * @throws JsonProcessingException if the JSON string is invalid with respect to IdealDonations
   */
  public static IdealDonations fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, IdealDonations.class);
  }

  /**
   * Convert an instance of IdealDonations to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
