/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** Payment */
@JsonPropertyOrder({
  Payment.JSON_PROPERTY_AMOUNT,
  Payment.JSON_PROPERTY_PAYMENT_METHOD,
  Payment.JSON_PROPERTY_PSP_REFERENCE,
  Payment.JSON_PROPERTY_RESULT_CODE
})
public class Payment {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
  private ResponsePaymentMethod paymentMethod;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **Authorised** – The payment was successfully authorised. This state serves as an indicator to
   * proceed with the delivery of goods and services. This is a final state.
   */
  public enum ResultCodeEnum {
    AUTHORISED(String.valueOf("Authorised"));

    private String value;

    ResultCodeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ResultCodeEnum fromValue(String value) {
      for (ResultCodeEnum b : ResultCodeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
  private ResultCodeEnum resultCode;

  public Payment() {}

  /**
   * amount
   *
   * @param amount
   * @return the current {@code Payment} instance, allowing for method chaining
   */
  public Payment amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   *
   * @return amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  /**
   * amount
   *
   * @param amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  /**
   * paymentMethod
   *
   * @param paymentMethod
   * @return the current {@code Payment} instance, allowing for method chaining
   */
  public Payment paymentMethod(ResponsePaymentMethod paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

  /**
   * Get paymentMethod
   *
   * @return paymentMethod
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResponsePaymentMethod getPaymentMethod() {
    return paymentMethod;
  }

  /**
   * paymentMethod
   *
   * @param paymentMethod
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethod(ResponsePaymentMethod paymentMethod) {
    this.paymentMethod = paymentMethod;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is
   * globally unique. Use this reference when you communicate with us about this request.
   *
   * @param pspReference Adyen&#39;s 16-character reference associated with the transaction/request.
   *     This value is globally unique. Use this reference when you communicate with us about this
   *     request.
   * @return the current {@code Payment} instance, allowing for method chaining
   */
  public Payment pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is
   * globally unique. Use this reference when you communicate with us about this request.
   *
   * @return pspReference Adyen&#39;s 16-character reference associated with the
   *     transaction/request. This value is globally unique. Use this reference when you communicate
   *     with us about this request.
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPspReference() {
    return pspReference;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is
   * globally unique. Use this reference when you communicate with us about this request.
   *
   * @param pspReference Adyen&#39;s 16-character reference associated with the transaction/request.
   *     This value is globally unique. Use this reference when you communicate with us about this
   *     request.
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **Authorised** – The payment was successfully authorised. This state serves as an indicator to
   * proceed with the delivery of goods and services. This is a final state.
   *
   * @param resultCode The result of the payment. For more information, see [Result
   *     codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   *     **Authorised** – The payment was successfully authorised. This state serves as an indicator
   *     to proceed with the delivery of goods and services. This is a final state.
   * @return the current {@code Payment} instance, allowing for method chaining
   */
  public Payment resultCode(ResultCodeEnum resultCode) {
    this.resultCode = resultCode;
    return this;
  }

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **Authorised** – The payment was successfully authorised. This state serves as an indicator to
   * proceed with the delivery of goods and services. This is a final state.
   *
   * @return resultCode The result of the payment. For more information, see [Result
   *     codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   *     **Authorised** – The payment was successfully authorised. This state serves as an indicator
   *     to proceed with the delivery of goods and services. This is a final state.
   */
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResultCodeEnum getResultCode() {
    return resultCode;
  }

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **Authorised** – The payment was successfully authorised. This state serves as an indicator to
   * proceed with the delivery of goods and services. This is a final state.
   *
   * @param resultCode The result of the payment. For more information, see [Result
   *     codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   *     **Authorised** – The payment was successfully authorised. This state serves as an indicator
   *     to proceed with the delivery of goods and services. This is a final state.
   */
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResultCode(ResultCodeEnum resultCode) {
    this.resultCode = resultCode;
  }

  /** Return true if this Payment object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payment payment = (Payment) o;
    return Objects.equals(this.amount, payment.amount)
        && Objects.equals(this.paymentMethod, payment.paymentMethod)
        && Objects.equals(this.pspReference, payment.pspReference)
        && Objects.equals(this.resultCode, payment.resultCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, paymentMethod, pspReference, resultCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payment {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Payment given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Payment
   * @throws JsonProcessingException if the JSON string is invalid with respect to Payment
   */
  public static Payment fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Payment.class);
  }

  /**
   * Convert an instance of Payment to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
