/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** PaymentDetails */
@JsonPropertyOrder({
  PaymentDetails.JSON_PROPERTY_CHECKOUT_ATTEMPT_ID,
  PaymentDetails.JSON_PROPERTY_TYPE
})
public class PaymentDetails {
  public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
  private String checkoutAttemptId;

  /** The payment method type. */
  public enum TypeEnum {
    ALIPAY(String.valueOf("alipay")),

    MULTIBANCO(String.valueOf("multibanco")),

    BANKTRANSFER_IBAN(String.valueOf("bankTransfer_IBAN")),

    PAYBRIGHT(String.valueOf("paybright")),

    PAYNOW(String.valueOf("paynow")),

    AFFIRM_POS(String.valueOf("affirm_pos")),

    TRUSTLY(String.valueOf("trustly")),

    TRUSTLYVECTOR(String.valueOf("trustlyvector")),

    ONEY(String.valueOf("oney")),

    FACILYPAY(String.valueOf("facilypay")),

    FACILYPAY_3X(String.valueOf("facilypay_3x")),

    FACILYPAY_4X(String.valueOf("facilypay_4x")),

    FACILYPAY_6X(String.valueOf("facilypay_6x")),

    FACILYPAY_10X(String.valueOf("facilypay_10x")),

    FACILYPAY_12X(String.valueOf("facilypay_12x")),

    UNIONPAY(String.valueOf("unionpay")),

    KCP_BANKTRANSFER(String.valueOf("kcp_banktransfer")),

    KCP_PAYCO(String.valueOf("kcp_payco")),

    KCP_CREDITCARD(String.valueOf("kcp_creditcard")),

    WECHATPAYSDK(String.valueOf("wechatpaySDK")),

    WECHATPAYQR(String.valueOf("wechatpayQR")),

    WECHATPAYWEB(String.valueOf("wechatpayWeb")),

    MOLPAY_BOOST(String.valueOf("molpay_boost")),

    WALLET_IN(String.valueOf("wallet_IN")),

    PAYU_IN_CASHCARD(String.valueOf("payu_IN_cashcard")),

    PAYU_IN_NB(String.valueOf("payu_IN_nb")),

    UPI_QR(String.valueOf("upi_qr")),

    PAYTM(String.valueOf("paytm")),

    MOLPAY_EBANKING_VN(String.valueOf("molpay_ebanking_VN")),

    MOLPAY_EBANKING_MY(String.valueOf("molpay_ebanking_MY")),

    MOLPAY_EBANKING_DIRECT_MY(String.valueOf("molpay_ebanking_direct_MY")),

    SWISH(String.valueOf("swish")),

    BIZUM(String.valueOf("bizum")),

    WALLEY(String.valueOf("walley")),

    WALLEY_B2B(String.valueOf("walley_b2b")),

    ALMA(String.valueOf("alma")),

    PAYPO(String.valueOf("paypo")),

    SCALAPAY(String.valueOf("scalapay")),

    SCALAPAY_3X(String.valueOf("scalapay_3x")),

    SCALAPAY_4X(String.valueOf("scalapay_4x")),

    MOLPAY_FPX(String.valueOf("molpay_fpx")),

    KONBINI(String.valueOf("konbini")),

    DIRECTEBANKING(String.valueOf("directEbanking")),

    BOLETOBANCARIO(String.valueOf("boletobancario")),

    NETELLER(String.valueOf("neteller")),

    CASHTICKET(String.valueOf("cashticket")),

    IKANO(String.valueOf("ikano")),

    KARENMILLEN(String.valueOf("karenmillen")),

    OASIS(String.valueOf("oasis")),

    WAREHOUSE(String.valueOf("warehouse")),

    PRIMEIROPAY_BOLETO(String.valueOf("primeiropay_boleto")),

    MADA(String.valueOf("mada")),

    BENEFIT(String.valueOf("benefit")),

    KNET(String.valueOf("knet")),

    OMANNET(String.valueOf("omannet")),

    GOPAY_WALLET(String.valueOf("gopay_wallet")),

    KCP_NAVERPAY(String.valueOf("kcp_naverpay")),

    ONLINEBANKING_IN(String.valueOf("onlinebanking_IN")),

    FAWRY(String.valueOf("fawry")),

    ATOME(String.valueOf("atome")),

    MONEYBOOKERS(String.valueOf("moneybookers")),

    NAPS(String.valueOf("naps")),

    NORDEA(String.valueOf("nordea")),

    BOLETOBANCARIO_BRADESCO(String.valueOf("boletobancario_bradesco")),

    BOLETOBANCARIO_ITAU(String.valueOf("boletobancario_itau")),

    BOLETOBANCARIO_SANTANDER(String.valueOf("boletobancario_santander")),

    BOLETOBANCARIO_BANCODOBRASIL(String.valueOf("boletobancario_bancodobrasil")),

    BOLETOBANCARIO_HSBC(String.valueOf("boletobancario_hsbc")),

    MOLPAY_MAYBANK2U(String.valueOf("molpay_maybank2u")),

    MOLPAY_CIMB(String.valueOf("molpay_cimb")),

    MOLPAY_RHB(String.valueOf("molpay_rhb")),

    MOLPAY_AMB(String.valueOf("molpay_amb")),

    MOLPAY_HLB(String.valueOf("molpay_hlb")),

    MOLPAY_AFFIN_EPG(String.valueOf("molpay_affin_epg")),

    MOLPAY_BANKISLAM(String.valueOf("molpay_bankislam")),

    MOLPAY_PUBLICBANK(String.valueOf("molpay_publicbank")),

    FPX_AGROBANK(String.valueOf("fpx_agrobank")),

    TOUCHNGO(String.valueOf("touchngo")),

    MAYBANK2U_MAE(String.valueOf("maybank2u_mae")),

    DUITNOW(String.valueOf("duitnow")),

    PROMPTPAY(String.valueOf("promptpay")),

    TWINT_POS(String.valueOf("twint_pos")),

    ALIPAY_HK(String.valueOf("alipay_hk")),

    ALIPAY_HK_WEB(String.valueOf("alipay_hk_web")),

    ALIPAY_HK_WAP(String.valueOf("alipay_hk_wap")),

    ALIPAY_WAP(String.valueOf("alipay_wap")),

    BALANCEPLATFORM(String.valueOf("balanceplatform"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public PaymentDetails() {}

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId The checkout attempt identifier.
   * @return the current {@code PaymentDetails} instance, allowing for method chaining
   */
  public PaymentDetails checkoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
    return this;
  }

  /**
   * The checkout attempt identifier.
   *
   * @return checkoutAttemptId The checkout attempt identifier.
   */
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCheckoutAttemptId() {
    return checkoutAttemptId;
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId The checkout attempt identifier.
   */
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
  }

  /**
   * The payment method type.
   *
   * @param type The payment method type.
   * @return the current {@code PaymentDetails} instance, allowing for method chaining
   */
  public PaymentDetails type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The payment method type.
   *
   * @return type The payment method type.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The payment method type.
   *
   * @param type The payment method type.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this PaymentDetails object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentDetails paymentDetails = (PaymentDetails) o;
    return Objects.equals(this.checkoutAttemptId, paymentDetails.checkoutAttemptId)
        && Objects.equals(this.type, paymentDetails.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkoutAttemptId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentDetails {\n");
    sb.append("    checkoutAttemptId: ").append(toIndentedString(checkoutAttemptId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PaymentDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentDetails
   */
  public static PaymentDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentDetails.class);
  }

  /**
   * Convert an instance of PaymentDetails to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
