/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** BankAccountInfo */
@JsonPropertyOrder({
  BankAccountInfo.JSON_PROPERTY_ACCOUNT_IDENTIFICATION,
  BankAccountInfo.JSON_PROPERTY_ACCOUNT_TYPE,
  BankAccountInfo.JSON_PROPERTY_BANK_NAME,
  BankAccountInfo.JSON_PROPERTY_COUNTRY_CODE,
  BankAccountInfo.JSON_PROPERTY_TRUSTED_SOURCE
})
public class BankAccountInfo {
  public static final String JSON_PROPERTY_ACCOUNT_IDENTIFICATION = "accountIdentification";
  private BankAccountInfoAccountIdentification accountIdentification;

  public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
  @Deprecated // deprecated since Legal Entity Management API v2
  private String accountType;

  public static final String JSON_PROPERTY_BANK_NAME = "bankName";
  private String bankName;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_TRUSTED_SOURCE = "trustedSource";
  private Boolean trustedSource;

  public BankAccountInfo() {}

  @JsonCreator
  public BankAccountInfo(@JsonProperty(JSON_PROPERTY_TRUSTED_SOURCE) Boolean trustedSource) {
    this();
    this.trustedSource = trustedSource;
  }

  /**
   * accountIdentification
   *
   * @param accountIdentification
   * @return the current {@code BankAccountInfo} instance, allowing for method chaining
   */
  public BankAccountInfo accountIdentification(
      BankAccountInfoAccountIdentification accountIdentification) {
    this.accountIdentification = accountIdentification;
    return this;
  }

  /**
   * Get accountIdentification
   *
   * @return accountIdentification
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BankAccountInfoAccountIdentification getAccountIdentification() {
    return accountIdentification;
  }

  /**
   * accountIdentification
   *
   * @param accountIdentification
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountIdentification(BankAccountInfoAccountIdentification accountIdentification) {
    this.accountIdentification = accountIdentification;
  }

  /**
   * The type of bank account.
   *
   * @param accountType The type of bank account.
   * @return the current {@code BankAccountInfo} instance, allowing for method chaining
   * @deprecated since Legal Entity Management API v2
   */
  @Deprecated // deprecated since Legal Entity Management API v2
  public BankAccountInfo accountType(String accountType) {
    this.accountType = accountType;
    return this;
  }

  /**
   * The type of bank account.
   *
   * @return accountType The type of bank account.
   * @deprecated // deprecated since Legal Entity Management API v2
   */
  @Deprecated // deprecated since Legal Entity Management API v2
  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountType() {
    return accountType;
  }

  /**
   * The type of bank account.
   *
   * @param accountType The type of bank account.
   * @deprecated since Legal Entity Management API v2
   */
  @Deprecated // deprecated since Legal Entity Management API v2
  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }

  /**
   * The name of the banking institution where the bank account is held.
   *
   * @param bankName The name of the banking institution where the bank account is held.
   * @return the current {@code BankAccountInfo} instance, allowing for method chaining
   */
  public BankAccountInfo bankName(String bankName) {
    this.bankName = bankName;
    return this;
  }

  /**
   * The name of the banking institution where the bank account is held.
   *
   * @return bankName The name of the banking institution where the bank account is held.
   */
  @JsonProperty(JSON_PROPERTY_BANK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBankName() {
    return bankName;
  }

  /**
   * The name of the banking institution where the bank account is held.
   *
   * @param bankName The name of the banking institution where the bank account is held.
   */
  @JsonProperty(JSON_PROPERTY_BANK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)
   * country code where the bank account is registered. For example, **NL**.
   *
   * @param countryCode The two-character [ISO 3166-1
   *     alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the bank
   *     account is registered. For example, **NL**.
   * @return the current {@code BankAccountInfo} instance, allowing for method chaining
   */
  public BankAccountInfo countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)
   * country code where the bank account is registered. For example, **NL**.
   *
   * @return countryCode The two-character [ISO 3166-1
   *     alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the bank
   *     account is registered. For example, **NL**.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCountryCode() {
    return countryCode;
  }

  /**
   * The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)
   * country code where the bank account is registered. For example, **NL**.
   *
   * @param countryCode The two-character [ISO 3166-1
   *     alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the bank
   *     account is registered. For example, **NL**.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }

  /**
   * Identifies if the bank account was created through [instant bank
   * verification](https://docs.adyen.com/release-notes/platforms-and-financial-products#releaseNote&#x3D;2023-05-08-hosted-onboarding).
   *
   * @return trustedSource Identifies if the bank account was created through [instant bank
   *     verification](https://docs.adyen.com/release-notes/platforms-and-financial-products#releaseNote&#x3D;2023-05-08-hosted-onboarding).
   */
  @JsonProperty(JSON_PROPERTY_TRUSTED_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getTrustedSource() {
    return trustedSource;
  }

  /** Return true if this BankAccountInfo object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankAccountInfo bankAccountInfo = (BankAccountInfo) o;
    return Objects.equals(this.accountIdentification, bankAccountInfo.accountIdentification)
        && Objects.equals(this.accountType, bankAccountInfo.accountType)
        && Objects.equals(this.bankName, bankAccountInfo.bankName)
        && Objects.equals(this.countryCode, bankAccountInfo.countryCode)
        && Objects.equals(this.trustedSource, bankAccountInfo.trustedSource);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountIdentification, accountType, bankName, countryCode, trustedSource);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankAccountInfo {\n");
    sb.append("    accountIdentification: ")
        .append(toIndentedString(accountIdentification))
        .append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    trustedSource: ").append(toIndentedString(trustedSource)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of BankAccountInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BankAccountInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to BankAccountInfo
   */
  public static BankAccountInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BankAccountInfo.class);
  }

  /**
   * Convert an instance of BankAccountInfo to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
