/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Objects;

/** GetAcceptedTermsOfServiceDocumentResponse */
@JsonPropertyOrder({
  GetAcceptedTermsOfServiceDocumentResponse.JSON_PROPERTY_DOCUMENT,
  GetAcceptedTermsOfServiceDocumentResponse.JSON_PROPERTY_ID,
  GetAcceptedTermsOfServiceDocumentResponse.JSON_PROPERTY_TERMS_OF_SERVICE_ACCEPTANCE_REFERENCE,
  GetAcceptedTermsOfServiceDocumentResponse.JSON_PROPERTY_TERMS_OF_SERVICE_DOCUMENT_FORMAT
})
public class GetAcceptedTermsOfServiceDocumentResponse {
  public static final String JSON_PROPERTY_DOCUMENT = "document";
  private byte[] document;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_TERMS_OF_SERVICE_ACCEPTANCE_REFERENCE =
      "termsOfServiceAcceptanceReference";
  private String termsOfServiceAcceptanceReference;

  /** The format of the Terms of Service document. */
  public enum TermsOfServiceDocumentFormatEnum {
    JSON(String.valueOf("JSON")),

    PDF(String.valueOf("PDF")),

    TXT(String.valueOf("TXT"));

    private String value;

    TermsOfServiceDocumentFormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TermsOfServiceDocumentFormatEnum fromValue(String value) {
      for (TermsOfServiceDocumentFormatEnum b : TermsOfServiceDocumentFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TERMS_OF_SERVICE_DOCUMENT_FORMAT =
      "termsOfServiceDocumentFormat";
  private TermsOfServiceDocumentFormatEnum termsOfServiceDocumentFormat;

  public GetAcceptedTermsOfServiceDocumentResponse() {}

  /**
   * The accepted Terms of Service document in the requested format represented as a Base64-encoded
   * bytes array.
   *
   * @param document The accepted Terms of Service document in the requested format represented as a
   *     Base64-encoded bytes array.
   * @return the current {@code GetAcceptedTermsOfServiceDocumentResponse} instance, allowing for
   *     method chaining
   */
  public GetAcceptedTermsOfServiceDocumentResponse document(byte[] document) {
    this.document = document;
    return this;
  }

  /**
   * The accepted Terms of Service document in the requested format represented as a Base64-encoded
   * bytes array.
   *
   * @return document The accepted Terms of Service document in the requested format represented as
   *     a Base64-encoded bytes array.
   */
  @JsonProperty(JSON_PROPERTY_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public byte[] getDocument() {
    return document;
  }

  /**
   * The accepted Terms of Service document in the requested format represented as a Base64-encoded
   * bytes array.
   *
   * @param document The accepted Terms of Service document in the requested format represented as a
   *     Base64-encoded bytes array.
   */
  @JsonProperty(JSON_PROPERTY_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDocument(byte[] document) {
    this.document = document;
  }

  /**
   * The unique identifier of the legal entity.
   *
   * @param id The unique identifier of the legal entity.
   * @return the current {@code GetAcceptedTermsOfServiceDocumentResponse} instance, allowing for
   *     method chaining
   */
  public GetAcceptedTermsOfServiceDocumentResponse id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the legal entity.
   *
   * @return id The unique identifier of the legal entity.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the legal entity.
   *
   * @param id The unique identifier of the legal entity.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * An Adyen-generated reference for the accepted Terms of Service.
   *
   * @param termsOfServiceAcceptanceReference An Adyen-generated reference for the accepted Terms of
   *     Service.
   * @return the current {@code GetAcceptedTermsOfServiceDocumentResponse} instance, allowing for
   *     method chaining
   */
  public GetAcceptedTermsOfServiceDocumentResponse termsOfServiceAcceptanceReference(
      String termsOfServiceAcceptanceReference) {
    this.termsOfServiceAcceptanceReference = termsOfServiceAcceptanceReference;
    return this;
  }

  /**
   * An Adyen-generated reference for the accepted Terms of Service.
   *
   * @return termsOfServiceAcceptanceReference An Adyen-generated reference for the accepted Terms
   *     of Service.
   */
  @JsonProperty(JSON_PROPERTY_TERMS_OF_SERVICE_ACCEPTANCE_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTermsOfServiceAcceptanceReference() {
    return termsOfServiceAcceptanceReference;
  }

  /**
   * An Adyen-generated reference for the accepted Terms of Service.
   *
   * @param termsOfServiceAcceptanceReference An Adyen-generated reference for the accepted Terms of
   *     Service.
   */
  @JsonProperty(JSON_PROPERTY_TERMS_OF_SERVICE_ACCEPTANCE_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTermsOfServiceAcceptanceReference(String termsOfServiceAcceptanceReference) {
    this.termsOfServiceAcceptanceReference = termsOfServiceAcceptanceReference;
  }

  /**
   * The format of the Terms of Service document.
   *
   * @param termsOfServiceDocumentFormat The format of the Terms of Service document.
   * @return the current {@code GetAcceptedTermsOfServiceDocumentResponse} instance, allowing for
   *     method chaining
   */
  public GetAcceptedTermsOfServiceDocumentResponse termsOfServiceDocumentFormat(
      TermsOfServiceDocumentFormatEnum termsOfServiceDocumentFormat) {
    this.termsOfServiceDocumentFormat = termsOfServiceDocumentFormat;
    return this;
  }

  /**
   * The format of the Terms of Service document.
   *
   * @return termsOfServiceDocumentFormat The format of the Terms of Service document.
   */
  @JsonProperty(JSON_PROPERTY_TERMS_OF_SERVICE_DOCUMENT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TermsOfServiceDocumentFormatEnum getTermsOfServiceDocumentFormat() {
    return termsOfServiceDocumentFormat;
  }

  /**
   * The format of the Terms of Service document.
   *
   * @param termsOfServiceDocumentFormat The format of the Terms of Service document.
   */
  @JsonProperty(JSON_PROPERTY_TERMS_OF_SERVICE_DOCUMENT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTermsOfServiceDocumentFormat(
      TermsOfServiceDocumentFormatEnum termsOfServiceDocumentFormat) {
    this.termsOfServiceDocumentFormat = termsOfServiceDocumentFormat;
  }

  /** Return true if this GetAcceptedTermsOfServiceDocumentResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetAcceptedTermsOfServiceDocumentResponse getAcceptedTermsOfServiceDocumentResponse =
        (GetAcceptedTermsOfServiceDocumentResponse) o;
    return Arrays.equals(this.document, getAcceptedTermsOfServiceDocumentResponse.document)
        && Objects.equals(this.id, getAcceptedTermsOfServiceDocumentResponse.id)
        && Objects.equals(
            this.termsOfServiceAcceptanceReference,
            getAcceptedTermsOfServiceDocumentResponse.termsOfServiceAcceptanceReference)
        && Objects.equals(
            this.termsOfServiceDocumentFormat,
            getAcceptedTermsOfServiceDocumentResponse.termsOfServiceDocumentFormat);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        Arrays.hashCode(document),
        id,
        termsOfServiceAcceptanceReference,
        termsOfServiceDocumentFormat);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetAcceptedTermsOfServiceDocumentResponse {\n");
    sb.append("    document: ").append(toIndentedString(document)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    termsOfServiceAcceptanceReference: ")
        .append(toIndentedString(termsOfServiceAcceptanceReference))
        .append("\n");
    sb.append("    termsOfServiceDocumentFormat: ")
        .append(toIndentedString(termsOfServiceDocumentFormat))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of GetAcceptedTermsOfServiceDocumentResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of GetAcceptedTermsOfServiceDocumentResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     GetAcceptedTermsOfServiceDocumentResponse
   */
  public static GetAcceptedTermsOfServiceDocumentResponse fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, GetAcceptedTermsOfServiceDocumentResponse.class);
  }

  /**
   * Convert an instance of GetAcceptedTermsOfServiceDocumentResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
