/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** PciSigningResponse */
@JsonPropertyOrder({
  PciSigningResponse.JSON_PROPERTY_PCI_QUESTIONNAIRE_IDS,
  PciSigningResponse.JSON_PROPERTY_SIGNED_BY
})
public class PciSigningResponse {
  public static final String JSON_PROPERTY_PCI_QUESTIONNAIRE_IDS = "pciQuestionnaireIds";
  private List<String> pciQuestionnaireIds;

  public static final String JSON_PROPERTY_SIGNED_BY = "signedBy";
  private String signedBy;

  public PciSigningResponse() {}

  /**
   * The unique identifiers of the signed PCI documents.
   *
   * @param pciQuestionnaireIds The unique identifiers of the signed PCI documents.
   * @return the current {@code PciSigningResponse} instance, allowing for method chaining
   */
  public PciSigningResponse pciQuestionnaireIds(List<String> pciQuestionnaireIds) {
    this.pciQuestionnaireIds = pciQuestionnaireIds;
    return this;
  }

  public PciSigningResponse addPciQuestionnaireIdsItem(String pciQuestionnaireIdsItem) {
    if (this.pciQuestionnaireIds == null) {
      this.pciQuestionnaireIds = new ArrayList<>();
    }
    this.pciQuestionnaireIds.add(pciQuestionnaireIdsItem);
    return this;
  }

  /**
   * The unique identifiers of the signed PCI documents.
   *
   * @return pciQuestionnaireIds The unique identifiers of the signed PCI documents.
   */
  @JsonProperty(JSON_PROPERTY_PCI_QUESTIONNAIRE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getPciQuestionnaireIds() {
    return pciQuestionnaireIds;
  }

  /**
   * The unique identifiers of the signed PCI documents.
   *
   * @param pciQuestionnaireIds The unique identifiers of the signed PCI documents.
   */
  @JsonProperty(JSON_PROPERTY_PCI_QUESTIONNAIRE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPciQuestionnaireIds(List<String> pciQuestionnaireIds) {
    this.pciQuestionnaireIds = pciQuestionnaireIds;
  }

  /**
   * The [legal entity
   * ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id)
   * of the individual who signed the PCI questionnaire.
   *
   * @param signedBy The [legal entity
   *     ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id)
   *     of the individual who signed the PCI questionnaire.
   * @return the current {@code PciSigningResponse} instance, allowing for method chaining
   */
  public PciSigningResponse signedBy(String signedBy) {
    this.signedBy = signedBy;
    return this;
  }

  /**
   * The [legal entity
   * ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id)
   * of the individual who signed the PCI questionnaire.
   *
   * @return signedBy The [legal entity
   *     ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id)
   *     of the individual who signed the PCI questionnaire.
   */
  @JsonProperty(JSON_PROPERTY_SIGNED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSignedBy() {
    return signedBy;
  }

  /**
   * The [legal entity
   * ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id)
   * of the individual who signed the PCI questionnaire.
   *
   * @param signedBy The [legal entity
   *     ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id)
   *     of the individual who signed the PCI questionnaire.
   */
  @JsonProperty(JSON_PROPERTY_SIGNED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignedBy(String signedBy) {
    this.signedBy = signedBy;
  }

  /** Return true if this PciSigningResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PciSigningResponse pciSigningResponse = (PciSigningResponse) o;
    return Objects.equals(this.pciQuestionnaireIds, pciSigningResponse.pciQuestionnaireIds)
        && Objects.equals(this.signedBy, pciSigningResponse.signedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pciQuestionnaireIds, signedBy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PciSigningResponse {\n");
    sb.append("    pciQuestionnaireIds: ")
        .append(toIndentedString(pciQuestionnaireIds))
        .append("\n");
    sb.append("    signedBy: ").append(toIndentedString(signedBy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PciSigningResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PciSigningResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PciSigningResponse
   */
  public static PciSigningResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PciSigningResponse.class);
  }

  /**
   * Convert an instance of PciSigningResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
