/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** StockData */
@JsonPropertyOrder({
  StockData.JSON_PROPERTY_MARKET_IDENTIFIER,
  StockData.JSON_PROPERTY_STOCK_NUMBER,
  StockData.JSON_PROPERTY_TICKER_SYMBOL
})
public class StockData {
  public static final String JSON_PROPERTY_MARKET_IDENTIFIER = "marketIdentifier";
  private String marketIdentifier;

  public static final String JSON_PROPERTY_STOCK_NUMBER = "stockNumber";
  private String stockNumber;

  public static final String JSON_PROPERTY_TICKER_SYMBOL = "tickerSymbol";
  private String tickerSymbol;

  public StockData() {}

  /**
   * The four-digit [Market Identifier Code](https://en.wikipedia.org/wiki/Market_Identifier_Code)
   * of the stock market where the organization&#39;s stocks are traded.
   *
   * @param marketIdentifier The four-digit [Market Identifier
   *     Code](https://en.wikipedia.org/wiki/Market_Identifier_Code) of the stock market where the
   *     organization&#39;s stocks are traded.
   * @return the current {@code StockData} instance, allowing for method chaining
   */
  public StockData marketIdentifier(String marketIdentifier) {
    this.marketIdentifier = marketIdentifier;
    return this;
  }

  /**
   * The four-digit [Market Identifier Code](https://en.wikipedia.org/wiki/Market_Identifier_Code)
   * of the stock market where the organization&#39;s stocks are traded.
   *
   * @return marketIdentifier The four-digit [Market Identifier
   *     Code](https://en.wikipedia.org/wiki/Market_Identifier_Code) of the stock market where the
   *     organization&#39;s stocks are traded.
   */
  @JsonProperty(JSON_PROPERTY_MARKET_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMarketIdentifier() {
    return marketIdentifier;
  }

  /**
   * The four-digit [Market Identifier Code](https://en.wikipedia.org/wiki/Market_Identifier_Code)
   * of the stock market where the organization&#39;s stocks are traded.
   *
   * @param marketIdentifier The four-digit [Market Identifier
   *     Code](https://en.wikipedia.org/wiki/Market_Identifier_Code) of the stock market where the
   *     organization&#39;s stocks are traded.
   */
  @JsonProperty(JSON_PROPERTY_MARKET_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarketIdentifier(String marketIdentifier) {
    this.marketIdentifier = marketIdentifier;
  }

  /**
   * The 12-digit International Securities Identification Number (ISIN) of the company, without
   * dashes (-).
   *
   * @param stockNumber The 12-digit International Securities Identification Number (ISIN) of the
   *     company, without dashes (-).
   * @return the current {@code StockData} instance, allowing for method chaining
   */
  public StockData stockNumber(String stockNumber) {
    this.stockNumber = stockNumber;
    return this;
  }

  /**
   * The 12-digit International Securities Identification Number (ISIN) of the company, without
   * dashes (-).
   *
   * @return stockNumber The 12-digit International Securities Identification Number (ISIN) of the
   *     company, without dashes (-).
   */
  @JsonProperty(JSON_PROPERTY_STOCK_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStockNumber() {
    return stockNumber;
  }

  /**
   * The 12-digit International Securities Identification Number (ISIN) of the company, without
   * dashes (-).
   *
   * @param stockNumber The 12-digit International Securities Identification Number (ISIN) of the
   *     company, without dashes (-).
   */
  @JsonProperty(JSON_PROPERTY_STOCK_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStockNumber(String stockNumber) {
    this.stockNumber = stockNumber;
  }

  /**
   * The stock ticker symbol.
   *
   * @param tickerSymbol The stock ticker symbol.
   * @return the current {@code StockData} instance, allowing for method chaining
   */
  public StockData tickerSymbol(String tickerSymbol) {
    this.tickerSymbol = tickerSymbol;
    return this;
  }

  /**
   * The stock ticker symbol.
   *
   * @return tickerSymbol The stock ticker symbol.
   */
  @JsonProperty(JSON_PROPERTY_TICKER_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTickerSymbol() {
    return tickerSymbol;
  }

  /**
   * The stock ticker symbol.
   *
   * @param tickerSymbol The stock ticker symbol.
   */
  @JsonProperty(JSON_PROPERTY_TICKER_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTickerSymbol(String tickerSymbol) {
    this.tickerSymbol = tickerSymbol;
  }

  /** Return true if this StockData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StockData stockData = (StockData) o;
    return Objects.equals(this.marketIdentifier, stockData.marketIdentifier)
        && Objects.equals(this.stockNumber, stockData.stockNumber)
        && Objects.equals(this.tickerSymbol, stockData.tickerSymbol);
  }

  @Override
  public int hashCode() {
    return Objects.hash(marketIdentifier, stockNumber, tickerSymbol);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StockData {\n");
    sb.append("    marketIdentifier: ").append(toIndentedString(marketIdentifier)).append("\n");
    sb.append("    stockNumber: ").append(toIndentedString(stockNumber)).append("\n");
    sb.append("    tickerSymbol: ").append(toIndentedString(tickerSymbol)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of StockData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of StockData
   * @throws JsonProcessingException if the JSON string is invalid with respect to StockData
   */
  public static StockData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, StockData.class);
  }

  /**
   * Convert an instance of StockData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
