/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** TransferInstrumentInfo */
@JsonPropertyOrder({
  TransferInstrumentInfo.JSON_PROPERTY_BANK_ACCOUNT,
  TransferInstrumentInfo.JSON_PROPERTY_LEGAL_ENTITY_ID,
  TransferInstrumentInfo.JSON_PROPERTY_TYPE
})
public class TransferInstrumentInfo {
  public static final String JSON_PROPERTY_BANK_ACCOUNT = "bankAccount";
  private BankAccountInfo bankAccount;

  public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
  private String legalEntityId;

  /** The type of transfer instrument. Possible value: **bankAccount**. */
  public enum TypeEnum {
    BANKACCOUNT(String.valueOf("bankAccount")),

    RECURRINGDETAIL(String.valueOf("recurringDetail"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public TransferInstrumentInfo() {}

  /**
   * bankAccount
   *
   * @param bankAccount
   * @return the current {@code TransferInstrumentInfo} instance, allowing for method chaining
   */
  public TransferInstrumentInfo bankAccount(BankAccountInfo bankAccount) {
    this.bankAccount = bankAccount;
    return this;
  }

  /**
   * Get bankAccount
   *
   * @return bankAccount
   */
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BankAccountInfo getBankAccount() {
    return bankAccount;
  }

  /**
   * bankAccount
   *
   * @param bankAccount
   */
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccount(BankAccountInfo bankAccount) {
    this.bankAccount = bankAccount;
  }

  /**
   * The unique identifier of the [legal
   * entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id)
   * that owns the transfer instrument.
   *
   * @param legalEntityId The unique identifier of the [legal
   *     entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id)
   *     that owns the transfer instrument.
   * @return the current {@code TransferInstrumentInfo} instance, allowing for method chaining
   */
  public TransferInstrumentInfo legalEntityId(String legalEntityId) {
    this.legalEntityId = legalEntityId;
    return this;
  }

  /**
   * The unique identifier of the [legal
   * entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id)
   * that owns the transfer instrument.
   *
   * @return legalEntityId The unique identifier of the [legal
   *     entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id)
   *     that owns the transfer instrument.
   */
  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalEntityId() {
    return legalEntityId;
  }

  /**
   * The unique identifier of the [legal
   * entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id)
   * that owns the transfer instrument.
   *
   * @param legalEntityId The unique identifier of the [legal
   *     entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id)
   *     that owns the transfer instrument.
   */
  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalEntityId(String legalEntityId) {
    this.legalEntityId = legalEntityId;
  }

  /**
   * The type of transfer instrument. Possible value: **bankAccount**.
   *
   * @param type The type of transfer instrument. Possible value: **bankAccount**.
   * @return the current {@code TransferInstrumentInfo} instance, allowing for method chaining
   */
  public TransferInstrumentInfo type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of transfer instrument. Possible value: **bankAccount**.
   *
   * @return type The type of transfer instrument. Possible value: **bankAccount**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of transfer instrument. Possible value: **bankAccount**.
   *
   * @param type The type of transfer instrument. Possible value: **bankAccount**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this TransferInstrumentInfo object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferInstrumentInfo transferInstrumentInfo = (TransferInstrumentInfo) o;
    return Objects.equals(this.bankAccount, transferInstrumentInfo.bankAccount)
        && Objects.equals(this.legalEntityId, transferInstrumentInfo.legalEntityId)
        && Objects.equals(this.type, transferInstrumentInfo.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bankAccount, legalEntityId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferInstrumentInfo {\n");
    sb.append("    bankAccount: ").append(toIndentedString(bankAccount)).append("\n");
    sb.append("    legalEntityId: ").append(toIndentedString(legalEntityId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of TransferInstrumentInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransferInstrumentInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     TransferInstrumentInfo
   */
  public static TransferInstrumentInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TransferInstrumentInfo.class);
  }

  /**
   * Convert an instance of TransferInstrumentInfo to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
