/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** ApiCredential */
@JsonPropertyOrder({
  ApiCredential.JSON_PROPERTY_LINKS,
  ApiCredential.JSON_PROPERTY_ACTIVE,
  ApiCredential.JSON_PROPERTY_ALLOWED_IP_ADDRESSES,
  ApiCredential.JSON_PROPERTY_ALLOWED_ORIGINS,
  ApiCredential.JSON_PROPERTY_CLIENT_KEY,
  ApiCredential.JSON_PROPERTY_DESCRIPTION,
  ApiCredential.JSON_PROPERTY_ID,
  ApiCredential.JSON_PROPERTY_ROLES,
  ApiCredential.JSON_PROPERTY_USERNAME
})
public class ApiCredential {
  public static final String JSON_PROPERTY_LINKS = "_links";
  private ApiCredentialLinks links;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_ALLOWED_IP_ADDRESSES = "allowedIpAddresses";
  private List<String> allowedIpAddresses;

  public static final String JSON_PROPERTY_ALLOWED_ORIGINS = "allowedOrigins";
  private List<AllowedOrigin> allowedOrigins;

  public static final String JSON_PROPERTY_CLIENT_KEY = "clientKey";
  private String clientKey;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ROLES = "roles";
  private List<String> roles;

  public static final String JSON_PROPERTY_USERNAME = "username";
  private String username;

  public ApiCredential() {}

  /**
   * links
   *
   * @param links
   * @return the current {@code ApiCredential} instance, allowing for method chaining
   */
  public ApiCredential links(ApiCredentialLinks links) {
    this.links = links;
    return this;
  }

  /**
   * Get links
   *
   * @return links
   */
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ApiCredentialLinks getLinks() {
    return links;
  }

  /**
   * links
   *
   * @param links
   */
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(ApiCredentialLinks links) {
    this.links = links;
  }

  /**
   * Indicates if the API credential is enabled. Must be set to **true** to use the credential in
   * your integration.
   *
   * @param active Indicates if the API credential is enabled. Must be set to **true** to use the
   *     credential in your integration.
   * @return the current {@code ApiCredential} instance, allowing for method chaining
   */
  public ApiCredential active(Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Indicates if the API credential is enabled. Must be set to **true** to use the credential in
   * your integration.
   *
   * @return active Indicates if the API credential is enabled. Must be set to **true** to use the
   *     credential in your integration.
   */
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getActive() {
    return active;
  }

  /**
   * Indicates if the API credential is enabled. Must be set to **true** to use the credential in
   * your integration.
   *
   * @param active Indicates if the API credential is enabled. Must be set to **true** to use the
   *     credential in your integration.
   */
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }

  /**
   * List of IP addresses from which your client can make requests. If the list is empty, we allow
   * requests from any IP. If the list is not empty and we get a request from an IP which is not on
   * the list, you get a security error.
   *
   * @param allowedIpAddresses List of IP addresses from which your client can make requests. If the
   *     list is empty, we allow requests from any IP. If the list is not empty and we get a request
   *     from an IP which is not on the list, you get a security error.
   * @return the current {@code ApiCredential} instance, allowing for method chaining
   */
  public ApiCredential allowedIpAddresses(List<String> allowedIpAddresses) {
    this.allowedIpAddresses = allowedIpAddresses;
    return this;
  }

  public ApiCredential addAllowedIpAddressesItem(String allowedIpAddressesItem) {
    if (this.allowedIpAddresses == null) {
      this.allowedIpAddresses = new ArrayList<>();
    }
    this.allowedIpAddresses.add(allowedIpAddressesItem);
    return this;
  }

  /**
   * List of IP addresses from which your client can make requests. If the list is empty, we allow
   * requests from any IP. If the list is not empty and we get a request from an IP which is not on
   * the list, you get a security error.
   *
   * @return allowedIpAddresses List of IP addresses from which your client can make requests. If
   *     the list is empty, we allow requests from any IP. If the list is not empty and we get a
   *     request from an IP which is not on the list, you get a security error.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_IP_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getAllowedIpAddresses() {
    return allowedIpAddresses;
  }

  /**
   * List of IP addresses from which your client can make requests. If the list is empty, we allow
   * requests from any IP. If the list is not empty and we get a request from an IP which is not on
   * the list, you get a security error.
   *
   * @param allowedIpAddresses List of IP addresses from which your client can make requests. If the
   *     list is empty, we allow requests from any IP. If the list is not empty and we get a request
   *     from an IP which is not on the list, you get a security error.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_IP_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedIpAddresses(List<String> allowedIpAddresses) {
    this.allowedIpAddresses = allowedIpAddresses;
  }

  /**
   * List containing the [allowed
   * origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   * linked to the API credential.
   *
   * @param allowedOrigins List containing the [allowed
   *     origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   *     linked to the API credential.
   * @return the current {@code ApiCredential} instance, allowing for method chaining
   */
  public ApiCredential allowedOrigins(List<AllowedOrigin> allowedOrigins) {
    this.allowedOrigins = allowedOrigins;
    return this;
  }

  public ApiCredential addAllowedOriginsItem(AllowedOrigin allowedOriginsItem) {
    if (this.allowedOrigins == null) {
      this.allowedOrigins = new ArrayList<>();
    }
    this.allowedOrigins.add(allowedOriginsItem);
    return this;
  }

  /**
   * List containing the [allowed
   * origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   * linked to the API credential.
   *
   * @return allowedOrigins List containing the [allowed
   *     origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   *     linked to the API credential.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_ORIGINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<AllowedOrigin> getAllowedOrigins() {
    return allowedOrigins;
  }

  /**
   * List containing the [allowed
   * origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   * linked to the API credential.
   *
   * @param allowedOrigins List containing the [allowed
   *     origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   *     linked to the API credential.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_ORIGINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedOrigins(List<AllowedOrigin> allowedOrigins) {
    this.allowedOrigins = allowedOrigins;
  }

  /**
   * Public key used for [client-side
   * authentication](https://docs.adyen.com/development-resources/client-side-authentication). The
   * client key is required for Drop-in and Components integrations.
   *
   * @param clientKey Public key used for [client-side
   *     authentication](https://docs.adyen.com/development-resources/client-side-authentication).
   *     The client key is required for Drop-in and Components integrations.
   * @return the current {@code ApiCredential} instance, allowing for method chaining
   */
  public ApiCredential clientKey(String clientKey) {
    this.clientKey = clientKey;
    return this;
  }

  /**
   * Public key used for [client-side
   * authentication](https://docs.adyen.com/development-resources/client-side-authentication). The
   * client key is required for Drop-in and Components integrations.
   *
   * @return clientKey Public key used for [client-side
   *     authentication](https://docs.adyen.com/development-resources/client-side-authentication).
   *     The client key is required for Drop-in and Components integrations.
   */
  @JsonProperty(JSON_PROPERTY_CLIENT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getClientKey() {
    return clientKey;
  }

  /**
   * Public key used for [client-side
   * authentication](https://docs.adyen.com/development-resources/client-side-authentication). The
   * client key is required for Drop-in and Components integrations.
   *
   * @param clientKey Public key used for [client-side
   *     authentication](https://docs.adyen.com/development-resources/client-side-authentication).
   *     The client key is required for Drop-in and Components integrations.
   */
  @JsonProperty(JSON_PROPERTY_CLIENT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientKey(String clientKey) {
    this.clientKey = clientKey;
  }

  /**
   * Description of the API credential.
   *
   * @param description Description of the API credential.
   * @return the current {@code ApiCredential} instance, allowing for method chaining
   */
  public ApiCredential description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description of the API credential.
   *
   * @return description Description of the API credential.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * Description of the API credential.
   *
   * @param description Description of the API credential.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Unique identifier of the API credential.
   *
   * @param id Unique identifier of the API credential.
   * @return the current {@code ApiCredential} instance, allowing for method chaining
   */
  public ApiCredential id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of the API credential.
   *
   * @return id Unique identifier of the API credential.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * Unique identifier of the API credential.
   *
   * @param id Unique identifier of the API credential.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the
   * API credential.
   *
   * @param roles List of
   *     [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API
   *     credential.
   * @return the current {@code ApiCredential} instance, allowing for method chaining
   */
  public ApiCredential roles(List<String> roles) {
    this.roles = roles;
    return this;
  }

  public ApiCredential addRolesItem(String rolesItem) {
    if (this.roles == null) {
      this.roles = new ArrayList<>();
    }
    this.roles.add(rolesItem);
    return this;
  }

  /**
   * List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the
   * API credential.
   *
   * @return roles List of
   *     [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API
   *     credential.
   */
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getRoles() {
    return roles;
  }

  /**
   * List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the
   * API credential.
   *
   * @param roles List of
   *     [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API
   *     credential.
   */
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoles(List<String> roles) {
    this.roles = roles;
  }

  /**
   * The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials),
   * for example **ws@Company.TestCompany**.
   *
   * @param username The name of the [API
   *     credential](https://docs.adyen.com/development-resources/api-credentials), for example
   *     **ws@Company.TestCompany**.
   * @return the current {@code ApiCredential} instance, allowing for method chaining
   */
  public ApiCredential username(String username) {
    this.username = username;
    return this;
  }

  /**
   * The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials),
   * for example **ws@Company.TestCompany**.
   *
   * @return username The name of the [API
   *     credential](https://docs.adyen.com/development-resources/api-credentials), for example
   *     **ws@Company.TestCompany**.
   */
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUsername() {
    return username;
  }

  /**
   * The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials),
   * for example **ws@Company.TestCompany**.
   *
   * @param username The name of the [API
   *     credential](https://docs.adyen.com/development-resources/api-credentials), for example
   *     **ws@Company.TestCompany**.
   */
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsername(String username) {
    this.username = username;
  }

  /** Return true if this ApiCredential object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiCredential apiCredential = (ApiCredential) o;
    return Objects.equals(this.links, apiCredential.links)
        && Objects.equals(this.active, apiCredential.active)
        && Objects.equals(this.allowedIpAddresses, apiCredential.allowedIpAddresses)
        && Objects.equals(this.allowedOrigins, apiCredential.allowedOrigins)
        && Objects.equals(this.clientKey, apiCredential.clientKey)
        && Objects.equals(this.description, apiCredential.description)
        && Objects.equals(this.id, apiCredential.id)
        && Objects.equals(this.roles, apiCredential.roles)
        && Objects.equals(this.username, apiCredential.username);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        links,
        active,
        allowedIpAddresses,
        allowedOrigins,
        clientKey,
        description,
        id,
        roles,
        username);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiCredential {\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    allowedIpAddresses: ").append(toIndentedString(allowedIpAddresses)).append("\n");
    sb.append("    allowedOrigins: ").append(toIndentedString(allowedOrigins)).append("\n");
    sb.append("    clientKey: ").append(toIndentedString(clientKey)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ApiCredential given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ApiCredential
   * @throws JsonProcessingException if the JSON string is invalid with respect to ApiCredential
   */
  public static ApiCredential fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ApiCredential.class);
  }

  /**
   * Convert an instance of ApiCredential to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
