/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** JCBInfo */
@JsonPropertyOrder({
  JCBInfo.JSON_PROPERTY_MID_NUMBER,
  JCBInfo.JSON_PROPERTY_REUSE_MID_NUMBER,
  JCBInfo.JSON_PROPERTY_SERVICE_LEVEL,
  JCBInfo.JSON_PROPERTY_TRANSACTION_DESCRIPTION
})
public class JCBInfo {
  public static final String JSON_PROPERTY_MID_NUMBER = "midNumber";
  private String midNumber;

  public static final String JSON_PROPERTY_REUSE_MID_NUMBER = "reuseMidNumber";
  private Boolean reuseMidNumber = false;

  /**
   * Specifies the service level (settlement type) of this payment method. Required for merchants
   * operating in Japan. Possible values: * **noContract**: Adyen holds the contract with JCB for
   * merchants operating in Japan or American Express for merchants operating in Canada, Australia
   * and New Zealand. * **gatewayContract**: JCB or American Express receives the settlement and
   * handles disputes, then pays out to you or your sub-merchant directly. *
   * **paymentDesignatorContract**: Available only for merchants operating in Canada, Australia and
   * New Zealand. Adyen receives the settlement, and handles disputes and payouts.
   */
  public enum ServiceLevelEnum {
    NOCONTRACT(String.valueOf("noContract")),

    GATEWAYCONTRACT(String.valueOf("gatewayContract")),

    PAYMENTDESIGNATORCONTRACT(String.valueOf("paymentDesignatorContract"));

    private String value;

    ServiceLevelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ServiceLevelEnum fromValue(String value) {
      for (ServiceLevelEnum b : ServiceLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SERVICE_LEVEL = "serviceLevel";
  private ServiceLevelEnum serviceLevel;

  public static final String JSON_PROPERTY_TRANSACTION_DESCRIPTION = "transactionDescription";
  private TransactionDescriptionInfo transactionDescription;

  public JCBInfo() {}

  /**
   * MID (Merchant ID) number. Required for merchants operating in Japan or merchants operating in
   * Canada, Australia and New Zealand when requesting &#x60;gatewayContract&#x60; or
   * &#x60;paymentDesignatorContract&#x60; service levels.Format: 14 numeric characters for Japan,
   * 10 numeric characters for Canada, Australia and New Zealand.
   *
   * @param midNumber MID (Merchant ID) number. Required for merchants operating in Japan or
   *     merchants operating in Canada, Australia and New Zealand when requesting
   *     &#x60;gatewayContract&#x60; or &#x60;paymentDesignatorContract&#x60; service levels.Format:
   *     14 numeric characters for Japan, 10 numeric characters for Canada, Australia and New
   *     Zealand.
   * @return the current {@code JCBInfo} instance, allowing for method chaining
   */
  public JCBInfo midNumber(String midNumber) {
    this.midNumber = midNumber;
    return this;
  }

  /**
   * MID (Merchant ID) number. Required for merchants operating in Japan or merchants operating in
   * Canada, Australia and New Zealand when requesting &#x60;gatewayContract&#x60; or
   * &#x60;paymentDesignatorContract&#x60; service levels.Format: 14 numeric characters for Japan,
   * 10 numeric characters for Canada, Australia and New Zealand.
   *
   * @return midNumber MID (Merchant ID) number. Required for merchants operating in Japan or
   *     merchants operating in Canada, Australia and New Zealand when requesting
   *     &#x60;gatewayContract&#x60; or &#x60;paymentDesignatorContract&#x60; service levels.Format:
   *     14 numeric characters for Japan, 10 numeric characters for Canada, Australia and New
   *     Zealand.
   */
  @JsonProperty(JSON_PROPERTY_MID_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMidNumber() {
    return midNumber;
  }

  /**
   * MID (Merchant ID) number. Required for merchants operating in Japan or merchants operating in
   * Canada, Australia and New Zealand when requesting &#x60;gatewayContract&#x60; or
   * &#x60;paymentDesignatorContract&#x60; service levels.Format: 14 numeric characters for Japan,
   * 10 numeric characters for Canada, Australia and New Zealand.
   *
   * @param midNumber MID (Merchant ID) number. Required for merchants operating in Japan or
   *     merchants operating in Canada, Australia and New Zealand when requesting
   *     &#x60;gatewayContract&#x60; or &#x60;paymentDesignatorContract&#x60; service levels.Format:
   *     14 numeric characters for Japan, 10 numeric characters for Canada, Australia and New
   *     Zealand.
   */
  @JsonProperty(JSON_PROPERTY_MID_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMidNumber(String midNumber) {
    this.midNumber = midNumber;
  }

  /**
   * Indicates whether the JCB Merchant ID is reused from a previously setup JCB payment method. The
   * default value is **false**.For merchants operating in Japan, this field is required and must be
   * set to **true**.
   *
   * @param reuseMidNumber Indicates whether the JCB Merchant ID is reused from a previously setup
   *     JCB payment method. The default value is **false**.For merchants operating in Japan, this
   *     field is required and must be set to **true**.
   * @return the current {@code JCBInfo} instance, allowing for method chaining
   */
  public JCBInfo reuseMidNumber(Boolean reuseMidNumber) {
    this.reuseMidNumber = reuseMidNumber;
    return this;
  }

  /**
   * Indicates whether the JCB Merchant ID is reused from a previously setup JCB payment method. The
   * default value is **false**.For merchants operating in Japan, this field is required and must be
   * set to **true**.
   *
   * @return reuseMidNumber Indicates whether the JCB Merchant ID is reused from a previously setup
   *     JCB payment method. The default value is **false**.For merchants operating in Japan, this
   *     field is required and must be set to **true**.
   */
  @JsonProperty(JSON_PROPERTY_REUSE_MID_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getReuseMidNumber() {
    return reuseMidNumber;
  }

  /**
   * Indicates whether the JCB Merchant ID is reused from a previously setup JCB payment method. The
   * default value is **false**.For merchants operating in Japan, this field is required and must be
   * set to **true**.
   *
   * @param reuseMidNumber Indicates whether the JCB Merchant ID is reused from a previously setup
   *     JCB payment method. The default value is **false**.For merchants operating in Japan, this
   *     field is required and must be set to **true**.
   */
  @JsonProperty(JSON_PROPERTY_REUSE_MID_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReuseMidNumber(Boolean reuseMidNumber) {
    this.reuseMidNumber = reuseMidNumber;
  }

  /**
   * Specifies the service level (settlement type) of this payment method. Required for merchants
   * operating in Japan. Possible values: * **noContract**: Adyen holds the contract with JCB for
   * merchants operating in Japan or American Express for merchants operating in Canada, Australia
   * and New Zealand. * **gatewayContract**: JCB or American Express receives the settlement and
   * handles disputes, then pays out to you or your sub-merchant directly. *
   * **paymentDesignatorContract**: Available only for merchants operating in Canada, Australia and
   * New Zealand. Adyen receives the settlement, and handles disputes and payouts.
   *
   * @param serviceLevel Specifies the service level (settlement type) of this payment method.
   *     Required for merchants operating in Japan. Possible values: * **noContract**: Adyen holds
   *     the contract with JCB for merchants operating in Japan or American Express for merchants
   *     operating in Canada, Australia and New Zealand. * **gatewayContract**: JCB or American
   *     Express receives the settlement and handles disputes, then pays out to you or your
   *     sub-merchant directly. * **paymentDesignatorContract**: Available only for merchants
   *     operating in Canada, Australia and New Zealand. Adyen receives the settlement, and handles
   *     disputes and payouts.
   * @return the current {@code JCBInfo} instance, allowing for method chaining
   */
  public JCBInfo serviceLevel(ServiceLevelEnum serviceLevel) {
    this.serviceLevel = serviceLevel;
    return this;
  }

  /**
   * Specifies the service level (settlement type) of this payment method. Required for merchants
   * operating in Japan. Possible values: * **noContract**: Adyen holds the contract with JCB for
   * merchants operating in Japan or American Express for merchants operating in Canada, Australia
   * and New Zealand. * **gatewayContract**: JCB or American Express receives the settlement and
   * handles disputes, then pays out to you or your sub-merchant directly. *
   * **paymentDesignatorContract**: Available only for merchants operating in Canada, Australia and
   * New Zealand. Adyen receives the settlement, and handles disputes and payouts.
   *
   * @return serviceLevel Specifies the service level (settlement type) of this payment method.
   *     Required for merchants operating in Japan. Possible values: * **noContract**: Adyen holds
   *     the contract with JCB for merchants operating in Japan or American Express for merchants
   *     operating in Canada, Australia and New Zealand. * **gatewayContract**: JCB or American
   *     Express receives the settlement and handles disputes, then pays out to you or your
   *     sub-merchant directly. * **paymentDesignatorContract**: Available only for merchants
   *     operating in Canada, Australia and New Zealand. Adyen receives the settlement, and handles
   *     disputes and payouts.
   */
  @JsonProperty(JSON_PROPERTY_SERVICE_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ServiceLevelEnum getServiceLevel() {
    return serviceLevel;
  }

  /**
   * Specifies the service level (settlement type) of this payment method. Required for merchants
   * operating in Japan. Possible values: * **noContract**: Adyen holds the contract with JCB for
   * merchants operating in Japan or American Express for merchants operating in Canada, Australia
   * and New Zealand. * **gatewayContract**: JCB or American Express receives the settlement and
   * handles disputes, then pays out to you or your sub-merchant directly. *
   * **paymentDesignatorContract**: Available only for merchants operating in Canada, Australia and
   * New Zealand. Adyen receives the settlement, and handles disputes and payouts.
   *
   * @param serviceLevel Specifies the service level (settlement type) of this payment method.
   *     Required for merchants operating in Japan. Possible values: * **noContract**: Adyen holds
   *     the contract with JCB for merchants operating in Japan or American Express for merchants
   *     operating in Canada, Australia and New Zealand. * **gatewayContract**: JCB or American
   *     Express receives the settlement and handles disputes, then pays out to you or your
   *     sub-merchant directly. * **paymentDesignatorContract**: Available only for merchants
   *     operating in Canada, Australia and New Zealand. Adyen receives the settlement, and handles
   *     disputes and payouts.
   */
  @JsonProperty(JSON_PROPERTY_SERVICE_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServiceLevel(ServiceLevelEnum serviceLevel) {
    this.serviceLevel = serviceLevel;
  }

  /**
   * transactionDescription
   *
   * @param transactionDescription
   * @return the current {@code JCBInfo} instance, allowing for method chaining
   */
  public JCBInfo transactionDescription(TransactionDescriptionInfo transactionDescription) {
    this.transactionDescription = transactionDescription;
    return this;
  }

  /**
   * Get transactionDescription
   *
   * @return transactionDescription
   */
  @JsonProperty(JSON_PROPERTY_TRANSACTION_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TransactionDescriptionInfo getTransactionDescription() {
    return transactionDescription;
  }

  /**
   * transactionDescription
   *
   * @param transactionDescription
   */
  @JsonProperty(JSON_PROPERTY_TRANSACTION_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionDescription(TransactionDescriptionInfo transactionDescription) {
    this.transactionDescription = transactionDescription;
  }

  /** Return true if this JCBInfo object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JCBInfo jcBInfo = (JCBInfo) o;
    return Objects.equals(this.midNumber, jcBInfo.midNumber)
        && Objects.equals(this.reuseMidNumber, jcBInfo.reuseMidNumber)
        && Objects.equals(this.serviceLevel, jcBInfo.serviceLevel)
        && Objects.equals(this.transactionDescription, jcBInfo.transactionDescription);
  }

  @Override
  public int hashCode() {
    return Objects.hash(midNumber, reuseMidNumber, serviceLevel, transactionDescription);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JCBInfo {\n");
    sb.append("    midNumber: ").append(toIndentedString(midNumber)).append("\n");
    sb.append("    reuseMidNumber: ").append(toIndentedString(reuseMidNumber)).append("\n");
    sb.append("    serviceLevel: ").append(toIndentedString(serviceLevel)).append("\n");
    sb.append("    transactionDescription: ")
        .append(toIndentedString(transactionDescription))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of JCBInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of JCBInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to JCBInfo
   */
  public static JCBInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, JCBInfo.class);
  }

  /**
   * Convert an instance of JCBInfo to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
