/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** WeChatPayInfo */
@JsonPropertyOrder({
  WeChatPayInfo.JSON_PROPERTY_CONTACT_PERSON_NAME,
  WeChatPayInfo.JSON_PROPERTY_EMAIL
})
public class WeChatPayInfo {
  public static final String JSON_PROPERTY_CONTACT_PERSON_NAME = "contactPersonName";
  private String contactPersonName;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public WeChatPayInfo() {}

  /**
   * The name of the contact person from merchant support.
   *
   * @param contactPersonName The name of the contact person from merchant support.
   * @return the current {@code WeChatPayInfo} instance, allowing for method chaining
   */
  public WeChatPayInfo contactPersonName(String contactPersonName) {
    this.contactPersonName = contactPersonName;
    return this;
  }

  /**
   * The name of the contact person from merchant support.
   *
   * @return contactPersonName The name of the contact person from merchant support.
   */
  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getContactPersonName() {
    return contactPersonName;
  }

  /**
   * The name of the contact person from merchant support.
   *
   * @param contactPersonName The name of the contact person from merchant support.
   */
  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactPersonName(String contactPersonName) {
    this.contactPersonName = contactPersonName;
  }

  /**
   * The email address of merchant support.
   *
   * @param email The email address of merchant support.
   * @return the current {@code WeChatPayInfo} instance, allowing for method chaining
   */
  public WeChatPayInfo email(String email) {
    this.email = email;
    return this;
  }

  /**
   * The email address of merchant support.
   *
   * @return email The email address of merchant support.
   */
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmail() {
    return email;
  }

  /**
   * The email address of merchant support.
   *
   * @param email The email address of merchant support.
   */
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }

  /** Return true if this WeChatPayInfo object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WeChatPayInfo weChatPayInfo = (WeChatPayInfo) o;
    return Objects.equals(this.contactPersonName, weChatPayInfo.contactPersonName)
        && Objects.equals(this.email, weChatPayInfo.email);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contactPersonName, email);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WeChatPayInfo {\n");
    sb.append("    contactPersonName: ").append(toIndentedString(contactPersonName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of WeChatPayInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of WeChatPayInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to WeChatPayInfo
   */
  public static WeChatPayInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, WeChatPayInfo.class);
  }

  /**
   * Convert an instance of WeChatPayInfo to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
