/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** PerformVerificationRequest */
@JsonPropertyOrder({
  PerformVerificationRequest.JSON_PROPERTY_ACCOUNT_HOLDER_CODE,
  PerformVerificationRequest.JSON_PROPERTY_ACCOUNT_STATE_TYPE,
  PerformVerificationRequest.JSON_PROPERTY_TIER
})
public class PerformVerificationRequest {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
  private String accountHolderCode;

  /**
   * The state required for the account holder. &gt; Permitted values: &#x60;Processing&#x60;,
   * &#x60;Payout&#x60;.
   */
  public enum AccountStateTypeEnum {
    LIMITEDPAYOUT("LimitedPayout"),

    LIMITEDPROCESSING("LimitedProcessing"),

    LIMITLESSPAYOUT("LimitlessPayout"),

    LIMITLESSPROCESSING("LimitlessProcessing"),

    PAYOUT("Payout"),

    PROCESSING("Processing");

    private String value;

    AccountStateTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AccountStateTypeEnum fromValue(String value) {
      for (AccountStateTypeEnum b : AccountStateTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ACCOUNT_STATE_TYPE = "accountStateType";
  private AccountStateTypeEnum accountStateType;

  public static final String JSON_PROPERTY_TIER = "tier";
  private Integer tier;

  public PerformVerificationRequest() {}

  public PerformVerificationRequest accountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
    return this;
  }

  /**
   * The code of the account holder to verify.
   *
   * @return accountHolderCode
   */
  @ApiModelProperty(required = true, value = "The code of the account holder to verify.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountHolderCode() {
    return accountHolderCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
  }

  public PerformVerificationRequest accountStateType(AccountStateTypeEnum accountStateType) {
    this.accountStateType = accountStateType;
    return this;
  }

  /**
   * The state required for the account holder. &gt; Permitted values: &#x60;Processing&#x60;,
   * &#x60;Payout&#x60;.
   *
   * @return accountStateType
   */
  @ApiModelProperty(
      required = true,
      value =
          "The state required for the account holder. > Permitted values: `Processing`, `Payout`.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_STATE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AccountStateTypeEnum getAccountStateType() {
    return accountStateType;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_STATE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountStateType(AccountStateTypeEnum accountStateType) {
    this.accountStateType = accountStateType;
  }

  public PerformVerificationRequest tier(Integer tier) {
    this.tier = tier;
    return this;
  }

  /**
   * The tier required for the account holder.
   *
   * @return tier
   */
  @ApiModelProperty(required = true, value = "The tier required for the account holder.")
  @JsonProperty(JSON_PROPERTY_TIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getTier() {
    return tier;
  }

  @JsonProperty(JSON_PROPERTY_TIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTier(Integer tier) {
    this.tier = tier;
  }

  /** Return true if this PerformVerificationRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PerformVerificationRequest performVerificationRequest = (PerformVerificationRequest) o;
    return Objects.equals(this.accountHolderCode, performVerificationRequest.accountHolderCode)
        && Objects.equals(this.accountStateType, performVerificationRequest.accountStateType)
        && Objects.equals(this.tier, performVerificationRequest.tier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolderCode, accountStateType, tier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PerformVerificationRequest {\n");
    sb.append("    accountHolderCode: ").append(toIndentedString(accountHolderCode)).append("\n");
    sb.append("    accountStateType: ").append(toIndentedString(accountStateType)).append("\n");
    sb.append("    tier: ").append(toIndentedString(tier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PerformVerificationRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PerformVerificationRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PerformVerificationRequest
   */
  public static PerformVerificationRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PerformVerificationRequest.class);
  }

  /**
   * Convert an instance of PerformVerificationRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
