/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** UpdateAccountHolderStateRequest */
@JsonPropertyOrder({
  UpdateAccountHolderStateRequest.JSON_PROPERTY_ACCOUNT_HOLDER_CODE,
  UpdateAccountHolderStateRequest.JSON_PROPERTY_DISABLE,
  UpdateAccountHolderStateRequest.JSON_PROPERTY_REASON,
  UpdateAccountHolderStateRequest.JSON_PROPERTY_STATE_TYPE
})
public class UpdateAccountHolderStateRequest {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
  private String accountHolderCode;

  public static final String JSON_PROPERTY_DISABLE = "disable";
  private Boolean disable;

  public static final String JSON_PROPERTY_REASON = "reason";
  private String reason;

  /**
   * The state to be updated. &gt;Permitted values are: &#x60;Processing&#x60;, &#x60;Payout&#x60;
   */
  public enum StateTypeEnum {
    LIMITEDPAYOUT("LimitedPayout"),

    LIMITEDPROCESSING("LimitedProcessing"),

    LIMITLESSPAYOUT("LimitlessPayout"),

    LIMITLESSPROCESSING("LimitlessProcessing"),

    PAYOUT("Payout"),

    PROCESSING("Processing");

    private String value;

    StateTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateTypeEnum fromValue(String value) {
      for (StateTypeEnum b : StateTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATE_TYPE = "stateType";
  private StateTypeEnum stateType;

  public UpdateAccountHolderStateRequest() {}

  public UpdateAccountHolderStateRequest accountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
    return this;
  }

  /**
   * The code of the Account Holder on which to update the state.
   *
   * @return accountHolderCode
   */
  @ApiModelProperty(
      required = true,
      value = "The code of the Account Holder on which to update the state.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountHolderCode() {
    return accountHolderCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
  }

  public UpdateAccountHolderStateRequest disable(Boolean disable) {
    this.disable = disable;
    return this;
  }

  /**
   * If true, disable the requested state. If false, enable the requested state.
   *
   * @return disable
   */
  @ApiModelProperty(
      required = true,
      value = "If true, disable the requested state.  If false, enable the requested state.")
  @JsonProperty(JSON_PROPERTY_DISABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getDisable() {
    return disable;
  }

  @JsonProperty(JSON_PROPERTY_DISABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisable(Boolean disable) {
    this.disable = disable;
  }

  public UpdateAccountHolderStateRequest reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The reason that the state is being updated. &gt;Required if the state is being disabled.
   *
   * @return reason
   */
  @ApiModelProperty(
      value =
          "The reason that the state is being updated. >Required if the state is being disabled.")
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReason() {
    return reason;
  }

  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReason(String reason) {
    this.reason = reason;
  }

  public UpdateAccountHolderStateRequest stateType(StateTypeEnum stateType) {
    this.stateType = stateType;
    return this;
  }

  /**
   * The state to be updated. &gt;Permitted values are: &#x60;Processing&#x60;, &#x60;Payout&#x60;
   *
   * @return stateType
   */
  @ApiModelProperty(
      required = true,
      value = "The state to be updated. >Permitted values are: `Processing`, `Payout`")
  @JsonProperty(JSON_PROPERTY_STATE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StateTypeEnum getStateType() {
    return stateType;
  }

  @JsonProperty(JSON_PROPERTY_STATE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStateType(StateTypeEnum stateType) {
    this.stateType = stateType;
  }

  /** Return true if this UpdateAccountHolderStateRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateAccountHolderStateRequest updateAccountHolderStateRequest =
        (UpdateAccountHolderStateRequest) o;
    return Objects.equals(this.accountHolderCode, updateAccountHolderStateRequest.accountHolderCode)
        && Objects.equals(this.disable, updateAccountHolderStateRequest.disable)
        && Objects.equals(this.reason, updateAccountHolderStateRequest.reason)
        && Objects.equals(this.stateType, updateAccountHolderStateRequest.stateType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolderCode, disable, reason, stateType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateAccountHolderStateRequest {\n");
    sb.append("    accountHolderCode: ").append(toIndentedString(accountHolderCode)).append("\n");
    sb.append("    disable: ").append(toIndentedString(disable)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    stateType: ").append(toIndentedString(stateType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of UpdateAccountHolderStateRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of UpdateAccountHolderStateRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     UpdateAccountHolderStateRequest
   */
  public static UpdateAccountHolderStateRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, UpdateAccountHolderStateRequest.class);
  }

  /**
   * Convert an instance of UpdateAccountHolderStateRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
