/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** ViasName */
@JsonPropertyOrder({
  ViasName.JSON_PROPERTY_FIRST_NAME,
  ViasName.JSON_PROPERTY_GENDER,
  ViasName.JSON_PROPERTY_INFIX,
  ViasName.JSON_PROPERTY_LAST_NAME
})
public class ViasName {
  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  /**
   * The gender. &gt;The following values are permitted: &#x60;MALE&#x60;, &#x60;FEMALE&#x60;,
   * &#x60;UNKNOWN&#x60;.
   */
  public enum GenderEnum {
    MALE("MALE"),

    FEMALE("FEMALE"),

    UNKNOWN("UNKNOWN");

    private String value;

    GenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GenderEnum fromValue(String value) {
      for (GenderEnum b : GenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GENDER = "gender";
  private GenderEnum gender;

  public static final String JSON_PROPERTY_INFIX = "infix";
  private String infix;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public ViasName() {}

  public ViasName firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

  /**
   * The first name.
   *
   * @return firstName
   */
  @ApiModelProperty(value = "The first name.")
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFirstName() {
    return firstName;
  }

  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public ViasName gender(GenderEnum gender) {
    this.gender = gender;
    return this;
  }

  /**
   * The gender. &gt;The following values are permitted: &#x60;MALE&#x60;, &#x60;FEMALE&#x60;,
   * &#x60;UNKNOWN&#x60;.
   *
   * @return gender
   */
  @ApiModelProperty(
      value = "The gender. >The following values are permitted: `MALE`, `FEMALE`, `UNKNOWN`.")
  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenderEnum getGender() {
    return gender;
  }

  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGender(GenderEnum gender) {
    this.gender = gender;
  }

  public ViasName infix(String infix) {
    this.infix = infix;
    return this;
  }

  /**
   * The name&#39;s infix, if applicable. &gt;A maximum length of twenty (20) characters is imposed.
   *
   * @return infix
   */
  @ApiModelProperty(
      value =
          "The name's infix, if applicable. >A maximum length of twenty (20) characters is imposed.")
  @JsonProperty(JSON_PROPERTY_INFIX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getInfix() {
    return infix;
  }

  @JsonProperty(JSON_PROPERTY_INFIX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInfix(String infix) {
    this.infix = infix;
  }

  public ViasName lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

  /**
   * The last name.
   *
   * @return lastName
   */
  @ApiModelProperty(value = "The last name.")
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLastName() {
    return lastName;
  }

  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  /** Return true if this ViasName object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ViasName viasName = (ViasName) o;
    return Objects.equals(this.firstName, viasName.firstName)
        && Objects.equals(this.gender, viasName.gender)
        && Objects.equals(this.infix, viasName.infix)
        && Objects.equals(this.lastName, viasName.lastName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(firstName, gender, infix, lastName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ViasName {\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    infix: ").append(toIndentedString(infix)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ViasName given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ViasName
   * @throws JsonProcessingException if the JSON string is invalid with respect to ViasName
   */
  public static ViasName fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ViasName.class);
  }

  /**
   * Convert an instance of ViasName to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
