/*
 * Fund API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Fund API provides endpoints for managing the funds in the accounts on your platform. These management operations include, for example, the transfer of funds from one account to another, the payout of funds to an account holder, and the retrieval of balances in an account.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Fund API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Fund/v6/accountHolderBalance ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayfund;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** PayoutAccountHolderRequest */
@JsonPropertyOrder({
  PayoutAccountHolderRequest.JSON_PROPERTY_ACCOUNT_CODE,
  PayoutAccountHolderRequest.JSON_PROPERTY_ACCOUNT_HOLDER_CODE,
  PayoutAccountHolderRequest.JSON_PROPERTY_AMOUNT,
  PayoutAccountHolderRequest.JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D,
  PayoutAccountHolderRequest.JSON_PROPERTY_DESCRIPTION,
  PayoutAccountHolderRequest.JSON_PROPERTY_MERCHANT_REFERENCE,
  PayoutAccountHolderRequest.JSON_PROPERTY_PAYOUT_METHOD_CODE,
  PayoutAccountHolderRequest.JSON_PROPERTY_PAYOUT_SPEED
})
public class PayoutAccountHolderRequest {
  public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
  private String accountCode;

  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
  private String accountHolderCode;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
  private String bankAccountUUID;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
  private String merchantReference;

  public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
  private String payoutMethodCode;

  /**
   * Speed with which payouts for this account are processed. Permitted values:
   * &#x60;STANDARD&#x60;, &#x60;SAME_DAY&#x60;.
   */
  public enum PayoutSpeedEnum {
    INSTANT("INSTANT"),

    SAME_DAY("SAME_DAY"),

    STANDARD("STANDARD");

    private String value;

    PayoutSpeedEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayoutSpeedEnum fromValue(String value) {
      for (PayoutSpeedEnum b : PayoutSpeedEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYOUT_SPEED = "payoutSpeed";
  private PayoutSpeedEnum payoutSpeed = PayoutSpeedEnum.STANDARD;

  public PayoutAccountHolderRequest() {}

  public PayoutAccountHolderRequest accountCode(String accountCode) {
    this.accountCode = accountCode;
    return this;
  }

  /**
   * The code of the account from which the payout is to be made.
   *
   * @return accountCode
   */
  @ApiModelProperty(
      required = true,
      value = "The code of the account from which the payout is to be made.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountCode() {
    return accountCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountCode(String accountCode) {
    this.accountCode = accountCode;
  }

  public PayoutAccountHolderRequest accountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
    return this;
  }

  /**
   * The code of the Account Holder who owns the account from which the payout is to be made. The
   * Account Holder is the party to which the payout will be made.
   *
   * @return accountHolderCode
   */
  @ApiModelProperty(
      required = true,
      value =
          "The code of the Account Holder who owns the account from which the payout is to be made. The Account Holder is the party to which the payout will be made.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountHolderCode() {
    return accountHolderCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
  }

  public PayoutAccountHolderRequest amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   *
   * @return amount
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  public PayoutAccountHolderRequest bankAccountUUID(String bankAccountUUID) {
    this.bankAccountUUID = bankAccountUUID;
    return this;
  }

  /**
   * The unique ID of the Bank Account held by the Account Holder to which the payout is to be made.
   * If left blank, a bank account is automatically selected.
   *
   * @return bankAccountUUID
   */
  @ApiModelProperty(
      value =
          "The unique ID of the Bank Account held by the Account Holder to which the payout is to be made. If left blank, a bank account is automatically selected.")
  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBankAccountUUID() {
    return bankAccountUUID;
  }

  @JsonProperty(JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankAccountUUID(String bankAccountUUID) {
    this.bankAccountUUID = bankAccountUUID;
  }

  public PayoutAccountHolderRequest description(String description) {
    this.description = description;
    return this;
  }

  /**
   * A description of the payout. Maximum 200 characters. Allowed:
   * **abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/?:().,&#39;+ \&quot;;**
   *
   * @return description
   */
  @ApiModelProperty(
      value =
          "A description of the payout. Maximum 200 characters. Allowed: **abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/?:().,'+ \";**")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  public PayoutAccountHolderRequest merchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
    return this;
  }

  /**
   * A value that can be supplied at the discretion of the executing user in order to link multiple
   * transactions to one another.
   *
   * @return merchantReference
   */
  @ApiModelProperty(
      value =
          "A value that can be supplied at the discretion of the executing user in order to link multiple transactions to one another.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantReference() {
    return merchantReference;
  }

  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }

  public PayoutAccountHolderRequest payoutMethodCode(String payoutMethodCode) {
    this.payoutMethodCode = payoutMethodCode;
    return this;
  }

  /**
   * The unique ID of the payout method held by the Account Holder to which the payout is to be
   * made. If left blank, a payout instrument is automatically selected.
   *
   * @return payoutMethodCode
   */
  @ApiModelProperty(
      value =
          "The unique ID of the payout method held by the Account Holder to which the payout is to be made. If left blank, a payout instrument is automatically selected.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_METHOD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPayoutMethodCode() {
    return payoutMethodCode;
  }

  @JsonProperty(JSON_PROPERTY_PAYOUT_METHOD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutMethodCode(String payoutMethodCode) {
    this.payoutMethodCode = payoutMethodCode;
  }

  public PayoutAccountHolderRequest payoutSpeed(PayoutSpeedEnum payoutSpeed) {
    this.payoutSpeed = payoutSpeed;
    return this;
  }

  /**
   * Speed with which payouts for this account are processed. Permitted values:
   * &#x60;STANDARD&#x60;, &#x60;SAME_DAY&#x60;.
   *
   * @return payoutSpeed
   */
  @ApiModelProperty(
      value =
          "Speed with which payouts for this account are processed. Permitted values: `STANDARD`, `SAME_DAY`.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_SPEED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayoutSpeedEnum getPayoutSpeed() {
    return payoutSpeed;
  }

  @JsonProperty(JSON_PROPERTY_PAYOUT_SPEED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutSpeed(PayoutSpeedEnum payoutSpeed) {
    this.payoutSpeed = payoutSpeed;
  }

  /** Return true if this PayoutAccountHolderRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayoutAccountHolderRequest payoutAccountHolderRequest = (PayoutAccountHolderRequest) o;
    return Objects.equals(this.accountCode, payoutAccountHolderRequest.accountCode)
        && Objects.equals(this.accountHolderCode, payoutAccountHolderRequest.accountHolderCode)
        && Objects.equals(this.amount, payoutAccountHolderRequest.amount)
        && Objects.equals(this.bankAccountUUID, payoutAccountHolderRequest.bankAccountUUID)
        && Objects.equals(this.description, payoutAccountHolderRequest.description)
        && Objects.equals(this.merchantReference, payoutAccountHolderRequest.merchantReference)
        && Objects.equals(this.payoutMethodCode, payoutAccountHolderRequest.payoutMethodCode)
        && Objects.equals(this.payoutSpeed, payoutAccountHolderRequest.payoutSpeed);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountCode,
        accountHolderCode,
        amount,
        bankAccountUUID,
        description,
        merchantReference,
        payoutMethodCode,
        payoutSpeed);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayoutAccountHolderRequest {\n");
    sb.append("    accountCode: ").append(toIndentedString(accountCode)).append("\n");
    sb.append("    accountHolderCode: ").append(toIndentedString(accountHolderCode)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    bankAccountUUID: ").append(toIndentedString(bankAccountUUID)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    payoutMethodCode: ").append(toIndentedString(payoutMethodCode)).append("\n");
    sb.append("    payoutSpeed: ").append(toIndentedString(payoutSpeed)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PayoutAccountHolderRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PayoutAccountHolderRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PayoutAccountHolderRequest
   */
  public static PayoutAccountHolderRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PayoutAccountHolderRequest.class);
  }

  /**
   * Convert an instance of PayoutAccountHolderRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
